/*
 * Decompiled with CFR 0.152.
 */
package com.github.maximuslotro.lotrrextended.common.datagen.models;

import com.github.maximuslotro.lotrrextended.client.render.item.ExtendedItemModelsProperties;
import com.github.maximuslotro.lotrrextended.common.block.ExtendedChainBlock;
import com.github.maximuslotro.lotrrextended.common.block.ExtendedLargeFlowerPotBlock;
import com.github.maximuslotro.lotrrextended.common.block.ExtendedLargePotBlock;
import com.github.maximuslotro.lotrrextended.common.datagen.models.ExtendedVesselModelBuilder;
import com.github.maximuslotro.lotrrextended.common.item.ExtendedBowItem;
import com.github.maximuslotro.lotrrextended.common.item.ExtendedBrandingIronItem;
import com.github.maximuslotro.lotrrextended.common.item.ExtendedCommandHornItem;
import com.github.maximuslotro.lotrrextended.common.item.ExtendedEntitySpawnerItem;
import com.github.maximuslotro.lotrrextended.common.item.ExtendedMCBannerItem;
import com.github.maximuslotro.lotrrextended.common.item.ExtendedSilverCoin;
import java.lang.reflect.Field;
import java.util.Map;
import lotr.common.block.ChandelierBlock;
import lotr.common.block.LOTRDoorBlock;
import lotr.common.block.LOTRSaplingBlock;
import lotr.common.block.LOTRStandingSignBlock;
import lotr.common.block.VesselDrinkBlock;
import lotr.common.init.ExtendedEntities;
import lotr.common.init.ExtendedItems;
import lotr.common.item.DaggerItem;
import lotr.common.item.FallenLeavesItem;
import lotr.common.item.LOTRArmorItem;
import lotr.common.item.LOTRAxeItem;
import lotr.common.item.LOTRHoeItem;
import lotr.common.item.LOTRPickaxeItem;
import lotr.common.item.LOTRShieldItem;
import lotr.common.item.LOTRShovelItem;
import lotr.common.item.LOTRSwordItem;
import lotr.common.item.SpearItem;
import lotr.common.item.VesselDrinkItem;
import net.minecraft.block.DoorBlock;
import net.minecraft.data.DataGenerator;
import net.minecraft.item.BannerPatternItem;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.generators.ItemModelBuilder;
import net.minecraftforge.client.model.generators.ItemModelProvider;
import net.minecraftforge.client.model.generators.ModelBuilder;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.fml.RegistryObject;

public class ExtendedItemModelGenerator
extends ItemModelProvider {
    public ExtendedItemModelGenerator(DataGenerator generator, String modid, ExistingFileHelper existingFileHelper) {
        super(generator, modid, existingFileHelper);
    }

    public ResourceLocation lotrExtendedLoc(String name) {
        return new ResourceLocation("lotrextended", name);
    }

    public ResourceLocation lotrLoc(String name) {
        return new ResourceLocation("lotr", name);
    }

    public void registerOverrides() {
        this.genGenerated(ExtendedItems.MORGUL_LANTERN.getId().func_110623_a(), this.lotrExtendedLoc("item/" + ExtendedItems.MORGUL_LANTERN.getId().func_110623_a()));
        this.genGenerated(ExtendedItems.WEAPON_RACK.getId().func_110623_a(), this.lotrExtendedLoc("item/" + ExtendedItems.WEAPON_RACK.getId().func_110623_a()));
        this.genGenerated(ExtendedItems.ENTITY_SPAWNER.getId().func_110623_a(), this.lotrExtendedLoc("block/spawner_block"));
        this.genGenerated(ExtendedItems.ROPE.getId().func_110623_a(), this.lotrExtendedLoc("item/" + ExtendedItems.ROPE.getId().func_110623_a()));
    }

    protected void registerModels() {
        for (Map.Entry<String, RegistryObject<Item>> item : ExtendedItems.REGISTEREDBLOCKITEMS.entrySet()) {
            if (((BlockItem)item.getValue().get()).func_179223_d() instanceof LOTRDoorBlock || ((BlockItem)item.getValue().get()).func_179223_d() instanceof DoorBlock || ((BlockItem)item.getValue().get()).func_179223_d() instanceof ChandelierBlock) {
                this.genGenerated(item.getKey(), this.lotrExtendedLoc("item/" + item.getKey()));
                continue;
            }
            if (((BlockItem)item.getValue().get()).func_179223_d() instanceof LOTRSaplingBlock) {
                this.genGenerated(item.getKey(), this.lotrExtendedLoc("block/" + item.getKey()));
                continue;
            }
            if (((BlockItem)item.getValue().get()).func_179223_d() instanceof ExtendedLargePotBlock) {
                this.genGenerated(item.getKey(), this.lotrExtendedLoc("item/" + item.getKey()));
                continue;
            }
            if (((BlockItem)item.getValue().get()).func_179223_d() instanceof ExtendedLargeFlowerPotBlock && !item.getKey().contains("large_pot_")) {
                this.genGenerated(item.getKey(), this.lotrExtendedLoc("item/" + item.getKey()));
                continue;
            }
            if (((BlockItem)item.getValue().get()).func_179223_d() instanceof LOTRStandingSignBlock) {
                this.genGenerated(item.getKey(), this.lotrExtendedLoc("item/" + item.getKey()));
                continue;
            }
            if (((BlockItem)item.getValue().get()).func_179223_d() instanceof VesselDrinkBlock) {
                this.genGenerated(item.getKey(), this.lotrExtendedLoc("item/" + item.getKey()));
                continue;
            }
            if (((BlockItem)item.getValue().get()).func_179223_d() instanceof ExtendedChainBlock) {
                this.genGenerated(item.getKey(), this.lotrExtendedLoc("item/" + item.getKey()));
                continue;
            }
            if (item.getKey().contains("vines")) {
                this.genGenerated(item.getKey(), this.lotrExtendedLoc("item/" + item.getKey() + "_hand"));
                continue;
            }
            if (!((BlockItem)item.getValue().get() instanceof FallenLeavesItem)) continue;
            try {
                this.genGenerated(item.getKey(), true, this.lotrExtendedLoc("block/" + item.getKey().substring(7)));
            }
            catch (IllegalArgumentException e) {
                this.genGenerated(item.getKey(), this.lotrExtendedLoc("block/" + item.getKey().substring(7) + "_0"));
            }
        }
        for (Map.Entry<String, RegistryObject<Item>> item : ExtendedItems.REGISTEREDITEMS.entrySet()) {
            if (item.getValue().get() instanceof ExtendedEntitySpawnerItem) continue;
            if (item.getKey().contains("torch")) {
                this.genGenerated(item.getKey(), this.lotrExtendedLoc("block/" + item.getKey()));
                continue;
            }
            if (item.getValue().get() instanceof LOTRArmorItem) {
                this.genGenerated(item.getKey(), this.lotrExtendedLoc("item/" + item.getKey()));
                continue;
            }
            if (item.getValue().get() instanceof VesselDrinkItem) {
                this.genDrink(item.getKey(), "item/" + item.getKey());
                continue;
            }
            if (item.getValue().get() instanceof BannerPatternItem) {
                this.genGenerated(item.getKey(), this.lotrExtendedLoc("item/" + item.getKey()));
                continue;
            }
            if (item.getValue().get() instanceof SpearItem) {
                this.genHandheld(item.getKey(), this.lotrExtendedLoc("item/" + item.getKey()));
                this.genSpearPulling(item.getKey());
                this.genSpear(item.getKey());
                continue;
            }
            if (item.getValue().get() instanceof DaggerItem) {
                this.genDaggerSneaking(item.getKey());
                this.genDagger(item.getKey());
                continue;
            }
            if (item.getValue().get() instanceof LOTRSwordItem) {
                this.genHandheld(item.getKey(), this.lotrExtendedLoc("item/" + item.getKey()));
                this.genSword(item.getKey());
                continue;
            }
            if (item.getValue().get() instanceof LOTRShieldItem) continue;
            if (item.getValue().get() instanceof ExtendedBowItem) {
                this.genBow(item.getKey());
                continue;
            }
            if (item.getValue().get() instanceof LOTRPickaxeItem || item.getValue().get() instanceof LOTRShovelItem || item.getValue().get() instanceof LOTRAxeItem || item.getValue().get() instanceof LOTRHoeItem) {
                this.genHandheld(item.getKey(), this.lotrExtendedLoc("item/" + item.getKey()));
                continue;
            }
            if (item.getValue().get() instanceof ExtendedCommandHornItem) {
                this.genCommandHorn(item.getKey(), "item/" + item.getKey());
                continue;
            }
            if (item.getValue().get() instanceof ExtendedBrandingIronItem) {
                this.genBrandingIron(item.getKey(), "item/" + item.getKey());
                continue;
            }
            if (item.getValue().get() instanceof ExtendedMCBannerItem) {
                this.genGenerated(item.getKey(), this.lotrExtendedLoc("item/banner/" + item.getKey()));
                continue;
            }
            if (item.getValue().get() instanceof ExtendedSilverCoin) {
                ItemModelBuilder builder = (ItemModelBuilder)this.withExistingParent("lotr:" + item.getKey(), "lotrextended:item/template_coin");
                builder.texture("layer0", this.lotrExtendedLoc("item/" + item.getKey()));
                continue;
            }
            try {
                this.genGenerated(item.getKey(), this.lotrExtendedLoc("item/" + item.getKey()));
            }
            catch (Exception e) {
                e.printStackTrace();
                System.out.println("Didn't make ItemModel for: " + item.getKey());
            }
        }
        for (String entity : ExtendedEntities.REGISTEREDNPCENTITIES) {
            this.withExistingParent("lotr:" + entity + "_spawn_egg", "item/template_spawn_egg");
        }
        for (String entity : ExtendedEntities.REGISTEREDANIMALENTITIES) {
            this.withExistingParent("lotr:" + entity + "_spawn_egg", "item/template_spawn_egg");
        }
        this.registerOverrides();
    }

    public String func_200397_b() {
        return "Renewed Extended Item Model Provider";
    }

    private void genBow(String name) {
        String bow = "lotr:" + name;
        String bowhandheld = "lotr:" + name + "_handheld";
        String bowhandheldPulling0 = name + "_handheld_pulling_0";
        String bowhandheldPulling1 = name + "_handheld_pulling_1";
        String bowhandheldPulling2 = name + "_handheld_pulling_2";
        ItemModelBuilder builder_bow_handleld = this.gen((ItemModelBuilder)this.withExistingParent(bowhandheld, "lotrextended:item/template_bow"), false, this.lotrExtendedLoc("item/" + name + "_handheld"));
        ItemModelBuilder builder_bow_handleld_p0 = this.gen((ItemModelBuilder)this.withExistingParent("lotr:item/" + bowhandheldPulling0, bowhandheld), false, this.lotrExtendedLoc("item/" + name + "_handheld_pulling_0"));
        ItemModelBuilder builder_bow_handleld_p1 = this.gen((ItemModelBuilder)this.withExistingParent("lotr:item/" + bowhandheldPulling1, bowhandheld), false, this.lotrExtendedLoc("item/" + name + "_handheld_pulling_1"));
        ItemModelBuilder builder_bow_handleld_2 = this.gen((ItemModelBuilder)this.withExistingParent("lotr:item/" + bowhandheldPulling2, bowhandheld), false, this.lotrExtendedLoc("item/" + name + "_handheld_pulling_2"));
        ItemModelBuilder builder_bow = this.gen((ItemModelBuilder)this.withExistingParent(bow, "lotrextended:item/template_bow"), false, this.lotrExtendedLoc("item/" + name));
        builder_bow_handleld.override().model((ModelFile)this.getExistingFile(this.lotrLoc(bowhandheldPulling0))).predicate(ExtendedItemModelsProperties.pulling, 1.0f);
        builder_bow_handleld.override().model((ModelFile)this.getExistingFile(this.lotrLoc(bowhandheldPulling1))).predicate(ExtendedItemModelsProperties.pulling, 1.0f).predicate(ExtendedItemModelsProperties.pull, 0.65f);
        builder_bow_handleld.override().model((ModelFile)this.getExistingFile(this.lotrLoc(bowhandheldPulling2))).predicate(ExtendedItemModelsProperties.pulling, 1.0f).predicate(ExtendedItemModelsProperties.pull, 0.9f);
    }

    private ItemModelBuilder genDrink(String name, String location) {
        ItemModelBuilder builder = (ItemModelBuilder)this.withExistingParent("lotr:" + name, "item/generated");
        builder.texture("liquid", this.lotrExtendedLoc(location + "_liquid"));
        builder.customLoader(ExtendedVesselModelBuilder::new);
        return builder;
    }

    private ItemModelBuilder genSword(String name) {
        ItemModelBuilder builder = (ItemModelBuilder)this.withExistingParent("lotr:" + name + "_handheld", "lotr:item/handheld_large");
        return this.gen(builder, false, this.lotrExtendedLoc("item/" + name + "_large"));
    }

    private ItemModelBuilder genSpear(String name) {
        ItemModelBuilder builder = (ItemModelBuilder)this.withExistingParent("lotr:" + name + "_handheld", "lotr:item/handheld_spear");
        builder.override().model((ModelFile)this.getExistingFile(this.lotrLoc("item/" + name + "_handheld_pulling"))).predicate(this.mcLoc("pulling"), 1.0f);
        return this.gen(builder, false, this.lotrExtendedLoc("item/" + name + "_large"));
    }

    private ItemModelBuilder genSpearPulling(String name) {
        ItemModelBuilder builder = (ItemModelBuilder)this.withExistingParent("lotr:" + name + "_handheld_pulling", "lotr:item/handheld_spear_pulling");
        return this.gen(builder, false, this.lotrExtendedLoc("item/" + name + "_large"));
    }

    private ItemModelBuilder genDagger(String name) {
        ItemModelBuilder builder = (ItemModelBuilder)this.withExistingParent("lotr:" + name, "lotr:item/handheld_dagger");
        builder.override().model((ModelFile)this.getExistingFile(this.lotrLoc("item/" + name + "_sneaking"))).predicate(this.lotrLoc("sneaking"), 1.0f);
        return this.gen(builder, false, this.lotrExtendedLoc("item/" + name));
    }

    private ItemModelBuilder genDaggerSneaking(String name) {
        ItemModelBuilder builder = (ItemModelBuilder)this.withExistingParent("lotr:" + name + "_sneaking", "lotr:item/handheld_dagger_sneaking");
        return this.gen(builder, false, this.lotrExtendedLoc("item/" + name));
    }

    private ItemModelBuilder genGenerated(String name, ResourceLocation ... layers) {
        ItemModelBuilder builder = (ItemModelBuilder)this.withExistingParent("lotr:" + name, "item/generated");
        return this.gen(builder, false, layers);
    }

    private ItemModelBuilder genGenerated(String name, boolean canFail, ResourceLocation ... layers) {
        ItemModelBuilder builder = (ItemModelBuilder)this.withExistingParent("lotr:" + name, "item/generated");
        return this.gen(builder, canFail, layers);
    }

    private ItemModelBuilder genHandheld(String name, ResourceLocation ... layers) {
        ItemModelBuilder builder = (ItemModelBuilder)this.withExistingParent("lotr:" + name, "item/handheld");
        return this.gen(builder, false, layers);
    }

    private ItemModelBuilder genCommandHorn(String name, String location) {
        ResourceLocation horn = this.lotrExtendedLoc(location);
        ResourceLocation horn_summon = this.lotrExtendedLoc(location + "_summon");
        ResourceLocation horn_halt = this.lotrExtendedLoc(location + "_halt");
        ItemModelBuilder builder_halt = this.genGenerated(name + "_halt", horn_halt);
        ItemModelBuilder builder_reddy = this.genGenerated(name + "_reddy", horn_halt);
        ItemModelBuilder builder_summon = this.genGenerated(name + "_summon", horn_summon);
        ItemModelBuilder builder = this.genGenerated(name, horn);
        builder.override().model((ModelFile)builder_halt).predicate(ExtendedItemModelsProperties.hornType, 1.0f);
        builder.override().model((ModelFile)builder_reddy).predicate(ExtendedItemModelsProperties.hornType, 2.0f);
        builder.override().model((ModelFile)builder_summon).predicate(ExtendedItemModelsProperties.hornType, 3.0f);
        return builder;
    }

    private ItemModelBuilder genBrandingIron(String name, String location) {
        ResourceLocation iron = this.lotrExtendedLoc(location);
        ResourceLocation iron_hot = this.lotrExtendedLoc(location + "_hot");
        ItemModelBuilder builder_iron_hot = this.genHandheld(name + "_hot", iron_hot);
        ItemModelBuilder builder = this.genHandheld(name, iron);
        builder.override().model((ModelFile)builder_iron_hot).predicate(ExtendedItemModelsProperties.heated, 1.0f);
        return builder;
    }

    private ItemModelBuilder gen(ItemModelBuilder builder, boolean canFail, ResourceLocation ... layers) {
        try {
            for (int i = 0; i < layers.length; ++i) {
                builder = (ItemModelBuilder)builder.texture("layer" + i, layers[i]);
            }
        }
        catch (IllegalArgumentException e) {
            if (!canFail) {
                for (int i = 0; i < layers.length; ++i) {
                    try {
                        Field f1 = ModelBuilder.class.getDeclaredField("textures");
                        f1.setAccessible(true);
                        ((Map)f1.get(builder)).put("layer" + i, layers[i].toString());
                        System.out.println("Missing texture for: " + layers[i]);
                        continue;
                    }
                    catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException e1) {
                        e1.printStackTrace();
                    }
                }
            }
            throw new IllegalArgumentException(e);
        }
        return builder;
    }
}

