/*
 * Decompiled with CFR 0.152.
 */
package com.github.maximuslotro.lotrrextended.common.datagen.structure.entities;

import com.github.maximuslotro.lotrrextended.ExtendedLog;
import com.github.maximuslotro.lotrrextended.common.spawners.ExtendedStructureEntitySpawnManager;
import com.github.maximuslotro.lotrrextended.common.spawners.ExtendedStructureEntitySpawner;
import com.github.maximuslotro.lotrrextended.common.spawners.SpawnerType;
import com.github.maximuslotro.lotrrextended.common.spawners.types.MultiSpawnType;
import com.google.gson.Gson;
import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import java.util.function.Consumer;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DirectoryCache;
import net.minecraft.data.IDataProvider;
import net.minecraft.entity.EntityType;
import net.minecraft.util.ResourceLocation;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class StructureEntitySpawnersProvider
implements IDataProvider {
    private static final Logger LOGGER = LogManager.getLogger();
    private final Map<ResourceLocation, ExtendedStructureEntitySpawner> dataHere = new TreeMap<ResourceLocation, ExtendedStructureEntitySpawner>();
    protected final DataGenerator dataGenerator;
    protected final String modId;

    StructureEntitySpawnersProvider(DataGenerator pDataGenerator, String pModId) {
        this.dataGenerator = pDataGenerator;
        this.modId = pModId;
    }

    public abstract void makeStructureSpawnPools(Consumer<ExtendedStructureEntitySpawner> var1);

    public void func_200398_a(DirectoryCache pCache) throws IOException {
        Path path = this.dataGenerator.func_200391_b();
        Consumer<ExtendedStructureEntitySpawner> consumer = spawner -> {
            if (this.dataHere.put(spawner.getId(), (ExtendedStructureEntitySpawner)spawner) != null) {
                throw new IllegalStateException("Duplicate structure spawner type " + spawner.getId().toString());
            }
            Path path1 = StructureEntitySpawnersProvider.createPath(path, spawner);
            try {
                StructureEntitySpawnersProvider.save(ExtendedStructureEntitySpawnManager.GSON_PRETTY_WRITER, pCache, spawner, path1);
            }
            catch (IOException ioexception) {
                LOGGER.error("Couldn't save advancement {}", (Object)path1, (Object)ioexception);
            }
        };
        this.makeStructureSpawnPools(consumer);
        ExtendedLog.info("Built " + this.dataHere.size() + " structure entity spawners.");
    }

    private static void save(Gson pGson, DirectoryCache pCache, ExtendedStructureEntitySpawner spawner, Path pPath) throws IOException {
        try {
            String s = ExtendedStructureEntitySpawnManager.serialize(pGson, spawner);
            String s1 = field_208307_a.hashUnencodedChars((CharSequence)s).toString();
            if (!Objects.equals(pCache.func_208323_a(pPath), s1) || !Files.exists(pPath, new LinkOption[0])) {
                Files.createDirectories(pPath.getParent(), new FileAttribute[0]);
                try (BufferedWriter bufferedwriter = Files.newBufferedWriter(pPath, new OpenOption[0]);){
                    bufferedwriter.write(s);
                }
            }
            pCache.func_208316_a(pPath, s1);
        }
        catch (IOException ioexception) {
            LOGGER.error("Couldn't save structure spawn pool {}", (Object)pPath, (Object)ioexception);
        }
    }

    private static Path createPath(Path pPath, ExtendedStructureEntitySpawner spawner) {
        return pPath.resolve("data/" + spawner.getId().func_110624_b() + "/entity_structure_spawners/" + spawner.getId().func_110623_a() + ".json");
    }

    public String func_200397_b() {
        return "Extended Structure Entity Spawner Provider";
    }

    public ExtendedStructureEntitySpawner.Builder make(SpawnerType spawnType) {
        return ExtendedStructureEntitySpawner.Builder.spawner(spawnType);
    }

    public ExtendedStructureEntitySpawner.Builder single(EntityType<?> type) {
        return this.singleWeighted(type, 100, 1, 1, 0);
    }

    public ExtendedStructureEntitySpawner.Builder single(EntityType<?> type, int spawnMin, int spawnMax, int spawnCap) {
        return this.singleWeighted(type, 100, spawnMin, spawnMax, spawnCap);
    }

    public ExtendedStructureEntitySpawner.Builder single(EntityType<?> type, int spawnMin, int spawnMax, boolean randomHome, int radius, int spawnCap) {
        return this.singleWeighted(type, 100, spawnMin, spawnMax, spawnCap).setHomeInfo(randomHome, radius);
    }

    public ExtendedStructureEntitySpawner.Builder couple(EntityType<?> type, int radius) {
        return this.multiWeighted(SpawnerType.SINGLE_FAMILY, type, 100, 1, 1, 0).setHomeInfo(false, radius);
    }

    public ExtendedStructureEntitySpawner.Builder singleWeighted(EntityType<?> type, int weight, int spawnMin, int spawnMax) {
        return this.multiWeighted(SpawnerType.SINGLE, type, weight, spawnMin, spawnMax, 0);
    }

    public ExtendedStructureEntitySpawner.Builder singleWeighted(EntityType<?> type, int weight, int spawnMin, int spawnMax, int spawnCap) {
        return this.multiWeighted(SpawnerType.SINGLE, type, weight, spawnMin, spawnMax, spawnCap);
    }

    public ExtendedStructureEntitySpawner.Builder persisted(EntityType<?> type) {
        return this.persisted(type, 1, 1, 4);
    }

    public ExtendedStructureEntitySpawner.Builder persisted(EntityType<?> type, int spawnMin, int spawnMax, int spawnCap) {
        return this.multiWeighted(SpawnerType.PERSISTED, type, 100, spawnMin, spawnMax, spawnCap);
    }

    public ExtendedStructureEntitySpawner.Builder persisted(EntityType<?> type, int spawnMin, int spawnMax, boolean randomHome, int radius, int spawnCap) {
        return this.multiWeighted(SpawnerType.PERSISTED, type, 100, spawnMin, spawnMax, spawnCap).setHomeInfo(randomHome, radius);
    }

    public ExtendedStructureEntitySpawner.Builder single(MultiSpawnType type) {
        return this.singleWeighted(type, 100, 1, 1, 0);
    }

    public ExtendedStructureEntitySpawner.Builder single(MultiSpawnType type, int spawnMin, int spawnMax, int spawnCap) {
        return this.singleWeighted(type, 100, spawnMin, spawnMax, spawnCap);
    }

    public ExtendedStructureEntitySpawner.Builder single(MultiSpawnType type, int spawnMin, int spawnMax, boolean randomHome, int radius, int spawnCap) {
        return this.singleWeighted(type, 100, spawnMin, spawnMax, spawnCap).setHomeInfo(randomHome, radius);
    }

    public ExtendedStructureEntitySpawner.Builder singleWeighted(MultiSpawnType type, int weight, int spawnMin, int spawnMax) {
        return this.multiWeighted(SpawnerType.SINGLE, type, weight, spawnMin, spawnMax, 0);
    }

    public ExtendedStructureEntitySpawner.Builder singleWeighted(MultiSpawnType type, int weight, int spawnMin, int spawnMax, int spawnCap) {
        return this.multiWeighted(SpawnerType.SINGLE, type, weight, spawnMin, spawnMax, spawnCap);
    }

    public ExtendedStructureEntitySpawner.Builder persisted(MultiSpawnType type) {
        return this.persisted(type, 1, 1, 4);
    }

    public ExtendedStructureEntitySpawner.Builder persisted(MultiSpawnType type, int spawnMin, int spawnMax, int spawnCap) {
        return this.multiWeighted(SpawnerType.PERSISTED, type, 100, spawnMin, spawnMax, spawnCap);
    }

    public ExtendedStructureEntitySpawner.Builder persisted(MultiSpawnType type, int spawnMin, int spawnMax, boolean randomHome, int radius, int spawnCap) {
        return this.multiWeighted(SpawnerType.PERSISTED, type, 100, spawnMin, spawnMax, spawnCap).setHomeInfo(randomHome, radius);
    }

    public ExtendedStructureEntitySpawner.Builder multiWeighted(SpawnerType spawnerType, MultiSpawnType type, int weight, int spawnMin, int spawnMax, int spawnCap) {
        return this.make(spawnerType).addMultiPool(type, weight, spawnMin, spawnMax).setlocalSpawnCap(spawnCap);
    }

    public ExtendedStructureEntitySpawner.Builder multiWeighted(SpawnerType spawnerType, EntityType<?> type, int weight, int spawnMin, int spawnMax, int spawnCap) {
        return this.make(spawnerType).addSinglePool(type, weight, spawnMin, spawnMax).setlocalSpawnCap(spawnCap);
    }
}

