/*
 * Decompiled with CFR 0.152.
 */
package com.github.maximuslotro.lotrrextended.common.datagen.tags;

import com.google.common.collect.Maps;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.text.Collator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DirectoryCache;
import net.minecraft.data.IDataProvider;
import net.minecraft.resources.ResourcePackType;
import net.minecraft.tags.ITag;
import net.minecraft.tags.Tag;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.common.extensions.IForgeTagBuilder;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class ExtendedTagsProvider<T>
implements IDataProvider {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    protected final DataGenerator generator;
    protected final Registry<T> registry;
    protected final Map<ResourceLocation, ITag.Builder> builders = Maps.newLinkedHashMap();
    protected final String modId;
    protected final String folder;
    protected final ExistingFileHelper existingFileHelper;
    private final ExistingFileHelper.IResourceType resourceType;

    protected ExtendedTagsProvider(DataGenerator pGenerator, Registry<T> pRegistry, String modId, @Nullable ExistingFileHelper existingFileHelper) {
        this(pGenerator, pRegistry, modId, existingFileHelper, null);
    }

    protected ExtendedTagsProvider(DataGenerator pGenerator, Registry<T> pRegistry, String modId, @Nullable ExistingFileHelper existingFileHelper, @Nullable String folder) {
        this.generator = pGenerator;
        this.registry = pRegistry;
        this.modId = modId;
        this.existingFileHelper = existingFileHelper;
        if (folder == null) {
            folder = this.getTagFolder();
        }
        this.folder = folder;
        this.resourceType = new ExistingFileHelper.ResourceType(ResourcePackType.SERVER_DATA, ".json", "tags/" + this.folder);
    }

    protected abstract void addTags();

    public void func_200398_a(DirectoryCache pCache) {
        this.builders.clear();
        this.addTags();
        Tag itag = Tag.func_241284_a_();
        Function<ResourceLocation, ITag> function = arg_0 -> this.lambda$run$0((ITag)itag, arg_0);
        Function<ResourceLocation, Object> function1 = tagLocation -> this.registry.func_241873_b(tagLocation).orElse(null);
        this.builders.forEach((tagLocation, tagBuilder) -> {
            List list = tagBuilder.func_232963_b_(function, function1).filter(this::missing).collect(Collectors.toList());
            if (!list.isEmpty()) {
                throw new IllegalArgumentException(String.format("Couldn't define tag %s as it is missing following references: %s", tagLocation, list.stream().map(Objects::toString).collect(Collectors.joining(","))));
            }
            JsonObject jsonobject = this.formatTags(tagBuilder.func_232965_c_());
            Path path = this.getPath((ResourceLocation)tagLocation);
            if (path == null) {
                return;
            }
            try {
                String s = GSON.toJson((JsonElement)jsonobject);
                String s1 = field_208307_a.hashUnencodedChars((CharSequence)s).toString();
                if (!Objects.equals(pCache.func_208323_a(path), s1) || !Files.exists(path, new LinkOption[0])) {
                    Files.createDirectories(path.getParent(), new FileAttribute[0]);
                    try (BufferedWriter bufferedwriter = Files.newBufferedWriter(path, new OpenOption[0]);){
                        bufferedwriter.write(s);
                    }
                }
                pCache.func_208316_a(path, s1);
            }
            catch (IOException ioexception) {
                LOGGER.error("Couldn't save tags to {}", (Object)path, (Object)ioexception);
            }
        });
    }

    private JsonObject formatTags(JsonObject unfomattedJson) {
        JsonObject formattedJson = new JsonObject();
        formattedJson.addProperty("replace", Boolean.valueOf(unfomattedJson.get("replace").getAsBoolean()));
        JsonArray values = unfomattedJson.getAsJsonArray("values");
        TreeMap<Object, JsonElement> elements = new TreeMap<Object, JsonElement>(Collator.getInstance());
        for (JsonElement value : values) {
            JsonObject object;
            if (value instanceof JsonPrimitive) {
                elements.put(value.getAsString(), value);
            }
            if (!(value instanceof JsonObject) || !(object = (JsonObject)value).has("id")) continue;
            elements.put(object.get("id").getAsString(), value);
        }
        JsonArray newArray = new JsonArray();
        for (JsonElement element : elements.values()) {
            newArray.add(element);
        }
        formattedJson.add("values", (JsonElement)newArray);
        return formattedJson;
    }

    private boolean missing(ITag.Proxy reference) {
        ITag.ITagEntry entry = reference.func_232968_a_();
        if (entry instanceof ITag.TagEntry) {
            return this.existingFileHelper == null || !this.existingFileHelper.exists(((ITag.TagEntry)entry).getId(), this.resourceType);
        }
        return false;
    }

    protected String getTagFolder() {
        return Registry.field_212617_f.func_177774_c(this.registry).func_110623_a() + "s";
    }

    protected abstract Path getPath(ResourceLocation var1);

    protected Builder<T> tag(ITag.INamedTag<T> pTag) {
        ITag.Builder itag$builder = this.getOrCreateRawBuilder(pTag);
        return new Builder(itag$builder, this.registry, this.modId);
    }

    protected ITag.Builder getOrCreateRawBuilder(ITag.INamedTag<T> pTag) {
        return this.builders.computeIfAbsent(pTag.func_230234_a_(), p_240526_0_ -> {
            this.existingFileHelper.trackGenerated(p_240526_0_, this.resourceType);
            return new ITag.Builder();
        });
    }

    private /* synthetic */ ITag lambda$run$0(ITag itag, ResourceLocation tagLocation) {
        return this.builders.containsKey(tagLocation) ? itag : null;
    }

    public static class Builder<T>
    implements IForgeTagBuilder<T> {
        private final ITag.Builder builder;
        private final Registry<T> registry;
        private final String source;

        private Builder(ITag.Builder pBuilder, Registry<T> pRegistry, String pSource) {
            this.builder = pBuilder;
            this.registry = pRegistry;
            this.source = pSource;
        }

        public Builder<T> add(T pItem) {
            this.builder.func_232961_a_(this.registry.func_177774_c(pItem), this.source);
            return this;
        }

        public Builder<T> addTag(ITag.INamedTag<T> pTag) {
            this.builder.func_232964_b_(pTag.func_230234_a_(), this.source);
            return this;
        }

        @SafeVarargs
        public final Builder<T> add(T ... pToAdd) {
            Stream.of(pToAdd).map(arg_0 -> this.registry.func_177774_c(arg_0)).forEach(p_240533_1_ -> this.builder.func_232961_a_(p_240533_1_, this.source));
            return this;
        }

        public Builder<T> add(ITag.ITagEntry tag) {
            this.builder.func_232955_a_(tag, this.source);
            return this;
        }

        public ITag.Builder getInternalBuilder() {
            return this.builder;
        }

        public String getModID() {
            return this.source;
        }
    }
}

