/*
 * Decompiled with CFR 0.152.
 */
package com.github.maximuslotro.lotrrextended.common.entity.passive;

import com.github.maximuslotro.lotrrextended.common.entity.passive.ExtendedGenderedAnimalEntity;
import com.github.maximuslotro.lotrrextended.common.enums.EntityGender;
import com.github.maximuslotro.lotrrextended.common.init.ExtendedSounds;
import com.github.maximuslotro.lotrrextended.common.init.ExtendedTags;
import java.util.Random;
import lotr.common.init.ExtendedEntities;
import lotr.common.init.ExtendedItems;
import lotr.common.init.LOTRItems;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.AgeableEntity;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.BreedGoal;
import net.minecraft.entity.ai.goal.FollowParentGoal;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.PanicGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.ai.goal.TemptGoal;
import net.minecraft.entity.ai.goal.WaterAvoidingRandomWalkingGoal;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.server.ServerWorld;

public class ExtendedDuckEntity
extends ExtendedGenderedAnimalEntity<ExtendedDuckEntity> {
    public float flap;
    public float flapSpeed;
    public float oFlapSpeed;
    public float oFlap;
    public float flapping = 1.0f;
    public int eggTime = this.field_70146_Z.nextInt(6000) + 6000;
    private static final DataParameter<Boolean> IS_BOB = EntityDataManager.func_187226_a(ExtendedDuckEntity.class, (IDataSerializer)DataSerializers.field_187198_h);

    public ExtendedDuckEntity(EntityType<? extends ExtendedDuckEntity> p_i50282_1_, World p_i50282_2_) {
        super(p_i50282_1_, p_i50282_2_);
        this.func_184644_a(PathNodeType.WATER, 0.0f);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (Goal)new SwimGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(1, (Goal)new PanicGoal((CreatureEntity)this, 1.4));
        this.field_70714_bg.func_75776_a(2, (Goal)new BreedGoal((AnimalEntity)this, 1.0));
        this.field_70714_bg.func_75776_a(3, (Goal)new TemptGoal((CreatureEntity)this, 1.0, false, Ingredient.func_199805_a(ExtendedTags.Items.DUCK_FOOD)));
        this.field_70714_bg.func_75776_a(4, (Goal)new FollowParentGoal((AnimalEntity)this, 1.1));
        this.field_70714_bg.func_75776_a(5, (Goal)new WaterAvoidingRandomWalkingGoal((CreatureEntity)this, 1.0));
        this.field_70714_bg.func_75776_a(6, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 6.0f));
        this.field_70714_bg.func_75776_a(7, (Goal)new LookRandomlyGoal((MobEntity)this));
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(IS_BOB, (Object)false);
    }

    protected float func_213348_b(Pose p_213348_1_, EntitySize p_213348_2_) {
        return this.func_70631_g_() ? p_213348_2_.field_220316_b * 0.85f : p_213348_2_.field_220316_b * 0.92f;
    }

    public static AttributeModifierMap.MutableAttribute createAttributes() {
        return MobEntity.func_233666_p_().func_233815_a_(Attributes.field_233818_a_, 4.0).func_233815_a_(Attributes.field_233821_d_, 0.25);
    }

    public static boolean checkTurtleSpawnRules(EntityType<ExtendedDuckEntity> pTurtle, IWorld pLevel, SpawnReason pSpawnType, BlockPos pPos, Random pRandom) {
        return ExtendedDuckEntity.isNearWater(pLevel, pPos, pRandom) && ExtendedDuckEntity.onSandOrGrassOrGravel((IBlockReader)pLevel, pPos) && pLevel.func_226659_b_(pPos, 0) > 8;
    }

    public static boolean isNearWater(IWorld pReader, BlockPos pPos, Random pRandom) {
        Biome biome = pReader.func_226691_t_(pPos);
        if (biome.func_201856_r() == Biome.Category.RIVER || pRandom.nextInt(4) == 0) {
            return true;
        }
        for (BlockPos pos : BlockPos.func_218278_a((BlockPos)pPos.func_177982_a(-12, -5, -12), (BlockPos)pPos.func_177982_a(12, 4, 12))) {
            if (!pReader.func_180495_p(pPos).func_203425_a(Blocks.field_150355_j)) continue;
            return true;
        }
        return false;
    }

    public static boolean onSandOrGrassOrGravel(IBlockReader pReader, BlockPos pPos) {
        return ExtendedDuckEntity.isSand(pReader, pPos.func_177977_b()) || ExtendedDuckEntity.isGrass(pReader, pPos.func_177977_b());
    }

    public static boolean isSand(IBlockReader pReader, BlockPos pPos) {
        return pReader.func_180495_p(pPos).func_235714_a_((ITag)BlockTags.field_203436_u);
    }

    public static boolean isGrass(IBlockReader pReader, BlockPos pPos) {
        return pReader.func_180495_p(pPos).func_203425_a(Blocks.field_196658_i);
    }

    public void func_70636_d() {
        super.func_70636_d();
        this.oFlap = this.flap;
        this.oFlapSpeed = this.flapSpeed;
        this.flapSpeed = (float)((double)this.flapSpeed + (double)(this.field_70122_E ? -1 : 4) * 0.3);
        this.flapSpeed = MathHelper.func_76131_a((float)this.flapSpeed, (float)0.0f, (float)1.0f);
        if (!this.field_70122_E && this.flapping < 1.0f) {
            this.flapping = 1.0f;
        }
        this.flapping = (float)((double)this.flapping * 0.9);
        Vector3d vector3d = this.func_213322_ci();
        if (!this.field_70122_E && vector3d.field_72448_b < 0.0) {
            this.func_213317_d(vector3d.func_216372_d(1.0, 0.6, 1.0));
        }
        this.flap += this.flapping * 2.0f;
        if (!this.field_70170_p.field_72995_K && this.func_70089_S() && !this.func_70631_g_() && --this.eggTime <= 0) {
            this.func_184185_a((SoundEvent)ExtendedSounds.DUCK_EGG.get(), 1.0f, (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f + 1.0f);
            this.func_199703_a((IItemProvider)ExtendedItems.DUCK_EGG.get());
            this.eggTime = this.field_70146_Z.nextInt(6000) + 6000;
        }
    }

    public ActionResultType func_230254_b_(PlayerEntity pPlayer, Hand pHand) {
        ItemStack itemstack = pPlayer.func_184586_b(pHand);
        if (Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{(IItemProvider)LOTRItems.FISH_AND_CHIPS.get()}).test(itemstack)) {
            if (this.getGender() == EntityGender.MALE) {
                this.setBob(true);
            }
            super.func_230254_b_(pPlayer, pHand);
            return ActionResultType.func_233537_a_((boolean)this.field_70170_p.field_72995_K);
        }
        return super.func_230254_b_(pPlayer, pHand);
    }

    public boolean func_225503_b_(float p_225503_1_, float p_225503_2_) {
        return false;
    }

    protected SoundEvent func_184639_G() {
        return (SoundEvent)ExtendedSounds.DUCK_AMBIANT.get();
    }

    protected SoundEvent func_184601_bQ(DamageSource p_184601_1_) {
        return (SoundEvent)ExtendedSounds.DUCK_HURT.get();
    }

    protected SoundEvent func_184615_bR() {
        return (SoundEvent)ExtendedSounds.DUCK_DEATH.get();
    }

    protected void func_180429_a(BlockPos p_180429_1_, BlockState p_180429_2_) {
        this.func_184185_a((SoundEvent)ExtendedSounds.DUCK_STEP.get(), 0.15f, 1.0f);
    }

    @Override
    public void func_70037_a(CompoundNBT nbt) {
        super.func_70037_a(nbt);
        if (nbt.func_74764_b("EggLayTime")) {
            this.eggTime = nbt.func_74762_e("EggLayTime");
        }
        if (nbt.func_74764_b("IsBobModeActivated")) {
            this.setBob(nbt.func_74767_n("IsBobModeActivated"));
        }
    }

    @Override
    public void func_213281_b(CompoundNBT nbt) {
        super.func_213281_b(nbt);
        nbt.func_74768_a("EggLayTime", this.eggTime);
        if (this.isBob()) {
            nbt.func_74757_a("IsBobModeActivated", true);
        }
    }

    public void func_184232_k(Entity p_184232_1_) {
        super.func_184232_k(p_184232_1_);
        float f = MathHelper.func_76126_a((float)(this.field_70761_aq * ((float)Math.PI / 180)));
        float f1 = MathHelper.func_76134_b((float)(this.field_70761_aq * ((float)Math.PI / 180)));
        float f2 = 0.1f;
        float f3 = 0.0f;
        p_184232_1_.func_70107_b(this.func_226277_ct_() + (double)(f2 * f), this.func_226283_e_(0.5) + p_184232_1_.func_70033_W() + (double)f3, this.func_226281_cx_() - (double)(f2 * f1));
        if (p_184232_1_ instanceof LivingEntity) {
            ((LivingEntity)p_184232_1_).field_70761_aq = this.field_70761_aq;
        }
    }

    @Override
    public boolean getBreedableFood(ItemStack stack) {
        return Ingredient.func_199805_a(ExtendedTags.Items.DUCK_FOOD).test(stack);
    }

    public boolean isBob() {
        return (Boolean)this.field_70180_af.func_187225_a(IS_BOB);
    }

    public void setBob(boolean isBob) {
        this.field_70180_af.func_187227_b(IS_BOB, (Object)isBob);
    }

    @Override
    public boolean isGendered() {
        return true;
    }

    @Override
    public ExtendedDuckEntity getBreedingOffspring(ServerWorld pServerLevel, AgeableEntity pMate) {
        return (ExtendedDuckEntity)((EntityType)ExtendedEntities.DUCK.get()).func_200721_a((World)pServerLevel);
    }

    @Override
    public ExtendedDuckEntity modifyBreedingOffspring(ExtendedDuckEntity baby, ServerWorld pServerLevel, AgeableEntity pMate) {
        if (baby.getGender() == EntityGender.MALE) {
            if (this.getGender() == EntityGender.MALE) {
                if (this.isBob()) {
                    baby.setBob(true);
                }
            } else if (((ExtendedDuckEntity)pMate).getGender() == EntityGender.MALE && ((ExtendedDuckEntity)pMate).isBob()) {
                baby.setBob(true);
            }
        }
        return baby;
    }
}

