/*
 * Decompiled with CFR 0.152.
 */
package com.github.maximuslotro.lotrrextended.common.entity.passive;

import com.github.maximuslotro.lotrrextended.common.enums.EntityGender;
import net.minecraft.entity.AgeableEntity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public abstract class ExtendedGenderedAnimalEntity<T extends ExtendedGenderedAnimalEntity<?>>
extends AnimalEntity {
    private static final DataParameter<Integer> GENDER = EntityDataManager.func_187226_a(ExtendedGenderedAnimalEntity.class, (IDataSerializer)DataSerializers.field_187192_b);

    protected ExtendedGenderedAnimalEntity(EntityType<? extends ExtendedGenderedAnimalEntity<T>> entityType, World world) {
        super(entityType, world);
        this.setGenderRandomly(this.isGendered(), world);
    }

    public boolean func_70877_b(ItemStack pStack) {
        return this.getBreedableFood(pStack);
    }

    public abstract boolean getBreedableFood(ItemStack var1);

    public abstract boolean isGendered();

    public abstract T getBreedingOffspring(ServerWorld var1, AgeableEntity var2);

    public T modifyBreedingOffspring(T baby, ServerWorld pServerLevel, AgeableEntity pMate) {
        return baby;
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(GENDER, (Object)3);
    }

    public AgeableEntity func_241840_a(ServerWorld pServerLevel, AgeableEntity pMate) {
        T baby = this.getBreedingOffspring(pServerLevel, pMate);
        if (((ExtendedGenderedAnimalEntity)((Object)baby)).isGendered() != this.isGendered() || ((ExtendedGenderedAnimalEntity)((Object)baby)).isGendered() != ((ExtendedGenderedAnimalEntity)pMate).isGendered()) {
            ((ExtendedGenderedAnimalEntity)((Object)baby)).setGenderRandomly(this.isGendered(), (World)pServerLevel);
        }
        return this.modifyBreedingOffspring(baby, pServerLevel, pMate);
    }

    public void func_70037_a(CompoundNBT nbt) {
        super.func_70037_a(nbt);
        if (nbt.func_74764_b("EntityGender")) {
            this.setGender(EntityGender.byGenderName(nbt.func_74779_i("EntityGender")));
        }
    }

    public void func_213281_b(CompoundNBT nbt) {
        super.func_213281_b(nbt);
        nbt.func_74778_a("EntityGender", this.getGender().getGenderName());
    }

    public boolean func_70878_b(AnimalEntity pOtherAnimal) {
        boolean canMateGeneric;
        if (pOtherAnimal == this) {
            return false;
        }
        if (pOtherAnimal.getClass() != ((Object)((Object)this)).getClass()) {
            return false;
        }
        if (!(pOtherAnimal instanceof ExtendedGenderedAnimalEntity) && !(this instanceof ExtendedGenderedAnimalEntity)) {
            return this.func_70880_s() && pOtherAnimal.func_70880_s();
        }
        boolean bl = canMateGeneric = this.func_70880_s() && pOtherAnimal.func_70880_s();
        if (!canMateGeneric) {
            return false;
        }
        EntityGender otherAnimalGender = ((ExtendedGenderedAnimalEntity)pOtherAnimal).getGender();
        if (otherAnimalGender == EntityGender.UNKNOWN || this.getGender() == EntityGender.UNKNOWN) {
            return false;
        }
        if (otherAnimalGender == EntityGender.FEMALE && this.getGender() == EntityGender.MALE) {
            return true;
        }
        if (otherAnimalGender == EntityGender.MALE && this.getGender() == EntityGender.FEMALE) {
            return true;
        }
        return otherAnimalGender == EntityGender.GENDERLESS && this.getGender() == EntityGender.GENDERLESS;
    }

    public EntityGender getGender() {
        return EntityGender.byGenderId((Integer)this.field_70180_af.func_187225_a(GENDER));
    }

    public void setGender(EntityGender gender) {
        this.field_70180_af.func_187227_b(GENDER, (Object)gender.getGenderId());
    }

    public void setGenderRandomly(boolean gendered, World serverWorld) {
        if (!gendered) {
            this.setGender(EntityGender.GENDERLESS);
        }
        this.setGender(serverWorld.field_73012_v.nextBoolean() ? EntityGender.MALE : EntityGender.FEMALE);
    }
}

