/*
 * Decompiled with CFR 0.152.
 */
package com.github.maximuslotro.lotrrextended.common.entity.special;

import com.github.maximuslotro.lotrrextended.common.config.ExtendedClientConfig;
import com.github.maximuslotro.lotrrextended.common.tileentity.ExtendedMEBannerTileEntity;
import com.github.maximuslotro.lotrrextended.common.utils.AxisAlignedBBUtils;
import java.util.Optional;
import java.util.UUID;
import lotr.common.init.ExtendedEntities;
import net.minecraft.block.material.PushReaction;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.Util;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.network.NetworkHooks;

public class ExtendedBannerEntity
extends Entity {
    private static final DataParameter<Integer> SPAWNER_BOUNDS = EntityDataManager.func_187226_a(ExtendedBannerEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Optional<UUID>> OWNER = EntityDataManager.func_187226_a(ExtendedBannerEntity.class, (IDataSerializer)DataSerializers.field_187203_m);
    private boolean queueToRemove = false;
    private ExtendedMEBannerTileEntity connectedTileEntity;

    public ExtendedBannerEntity(EntityType<? extends ExtendedBannerEntity> pType, World pLevel) {
        super(pType, pLevel);
        this.field_70158_ak = true;
    }

    public ExtendedBannerEntity(World pLevel) {
        this((EntityType<? extends ExtendedBannerEntity>)((EntityType)ExtendedEntities.BANNER_HOLDER.get()), pLevel);
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean func_145770_h(double pX, double pY, double pZ) {
        return true;
    }

    public void func_70071_h_() {
        this.field_70145_X = true;
        this.field_70145_X = false;
        this.func_189654_d(true);
        this.func_213317_d(Vector3d.field_186680_a);
        this.func_184224_h(true);
        if (!this.field_70170_p.func_201670_d()) {
            if (this.queueToRemove) {
                this.func_70106_y();
            } else {
                TileEntity tileentity = this.field_70170_p.func_175625_s(this.func_233580_cy_());
                if (tileentity instanceof ExtendedMEBannerTileEntity) {
                    ExtendedMEBannerTileEntity banner = (ExtendedMEBannerTileEntity)tileentity;
                    if (!banner.isActiveHalf() || !this.func_110124_au().equals(banner.getEntityID())) {
                        this.queueToRemove = true;
                    } else {
                        this.setProtectionRange(banner.getProtectionRadius());
                        this.setProtectionOwner(banner.getPlacedPlayerUUID());
                        this.connectedTileEntity = banner;
                    }
                } else {
                    this.queueToRemove = true;
                }
            }
        }
    }

    public ExtendedMEBannerTileEntity getConnectedTileEntity() {
        return this.connectedTileEntity;
    }

    public boolean isValid() {
        return this.connectedTileEntity != null && !this.queueToRemove && this.getProtectionRange() > 0;
    }

    public AxisAlignedBB getProtectionArea() {
        return AxisAlignedBBUtils.makeCroppedBB(this.func_226277_ct_() - 0.5, this.func_174813_aQ().field_72338_b, this.func_226281_cx_() - 0.5).func_186662_g((double)this.getProtectionRange() - 0.01);
    }

    protected void func_70037_a(CompoundNBT pCompound) {
        if (pCompound.func_74764_b("protectionRange")) {
            this.setProtectionRange(pCompound.func_74762_e("protectionRange"));
        }
    }

    protected void func_213281_b(CompoundNBT pCompound) {
        if (this.getProtectionRange() > 0) {
            pCompound.func_74768_a("protectionRange", this.getProtectionRange());
        }
    }

    public int getProtectionRange() {
        return (Integer)this.func_184212_Q().func_187225_a(SPAWNER_BOUNDS);
    }

    public void setProtectionRange(int range) {
        this.func_184212_Q().func_187227_b(SPAWNER_BOUNDS, (Object)range);
    }

    public UUID getProtectionOwner() {
        return ((Optional)this.func_184212_Q().func_187225_a(OWNER)).orElse(Util.field_240973_b_);
    }

    public void setProtectionOwner(UUID owner) {
        if (owner != null) {
            this.func_184212_Q().func_187227_b(OWNER, Optional.of(owner));
        }
    }

    public ActionResultType func_184230_a(PlayerEntity pPlayer, Hand pHand) {
        return ActionResultType.func_233537_a_((boolean)this.field_70170_p.field_72995_K);
    }

    public ItemStack getPickedResult(RayTraceResult target) {
        return ItemStack.field_190927_a;
    }

    public void func_82142_c(boolean pInvisible) {
        if (!this.field_70170_p.func_201670_d()) {
            super.func_82142_c(pInvisible);
        }
    }

    public boolean func_82150_aj() {
        return true;
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean func_98034_c(PlayerEntity pPlayer) {
        return !pPlayer.func_175149_v() && !pPlayer.func_184812_l_() && (Boolean)ExtendedClientConfig.enableDevMode.get() == false;
    }

    public void func_174812_G() {
    }

    public void func_70106_y() {
        if (!this.queueToRemove) {
            this.field_70170_p.func_184148_a((PlayerEntity)null, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), SoundEvents.field_187561_bM, SoundCategory.NEUTRAL, 0.5f, 0.4f / (this.field_70146_Z.nextFloat() * 0.4f + 0.8f));
        }
        super.func_70106_y();
    }

    protected void func_70088_a() {
        this.func_184212_Q().func_187214_a(SPAWNER_BOUNDS, (Object)0);
        this.func_184212_Q().func_187214_a(OWNER, Optional.empty());
    }

    public boolean func_184222_aU() {
        return false;
    }

    public boolean func_145773_az() {
        return true;
    }

    public boolean func_180427_aV() {
        return true;
    }

    public boolean func_230279_az_() {
        return true;
    }

    public boolean func_70027_ad() {
        return false;
    }

    public boolean func_70097_a(DamageSource pSource, float pAmount) {
        return false;
    }

    public boolean func_70067_L() {
        return false;
    }

    public boolean func_70104_M() {
        return false;
    }

    public boolean func_241845_aY() {
        return false;
    }

    protected boolean func_184228_n(Entity pEntity) {
        return false;
    }

    public boolean func_190530_aW() {
        return true;
    }

    public PushReaction func_184192_z() {
        return PushReaction.IGNORE;
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }
}

