/*
 * Decompiled with CFR 0.152.
 */
package com.github.maximuslotro.lotrrextended.common.entity.special;

import com.github.maximuslotro.lotrrextended.ExtendedLog;
import com.github.maximuslotro.lotrrextended.common.config.ExtendedClientConfig;
import com.github.maximuslotro.lotrrextended.common.config.ExtendedServerConfig;
import com.github.maximuslotro.lotrrextended.common.spawners.ExtendedSpawners;
import com.github.maximuslotro.lotrrextended.common.spawners.ExtendedStructureEntitySpawnManager;
import com.github.maximuslotro.lotrrextended.common.spawners.ExtendedStructureEntitySpawner;
import com.github.maximuslotro.lotrrextended.common.spawners.SpawnerType;
import com.github.maximuslotro.lotrrextended.mixins.lotr.common.entity.npc.MixinNPCEntityInvoker;
import java.util.List;
import java.util.Locale;
import java.util.Random;
import java.util.function.Predicate;
import lotr.common.entity.npc.ExtendedNPCEntity;
import lotr.common.entity.npc.NPCEntity;
import lotr.common.entity.npc.data.ExtendedNpcMarriageHolder;
import lotr.common.entity.npc.data.NPCGenderProvider;
import lotr.common.init.ExtendedEntities;
import lotr.common.init.ExtendedItems;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.material.PushReaction;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.Util;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.World;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.network.NetworkHooks;

public class ExtendedStructureSpawnerEntity
extends Entity {
    private static final DataParameter<String> DATA_SPAWNER_TYPE = EntityDataManager.func_187226_a(ExtendedStructureSpawnerEntity.class, (IDataSerializer)DataSerializers.field_187194_d);
    private static final DataParameter<BlockPos> DATA_SPAWNER_CBoundMin = EntityDataManager.func_187226_a(ExtendedStructureSpawnerEntity.class, (IDataSerializer)DataSerializers.field_187200_j);
    private static final DataParameter<BlockPos> DATA_SPAWNER_CBoundMax = EntityDataManager.func_187226_a(ExtendedStructureSpawnerEntity.class, (IDataSerializer)DataSerializers.field_187200_j);
    private static final DataParameter<BlockPos> DATA_SPAWNER_SBoundMin = EntityDataManager.func_187226_a(ExtendedStructureSpawnerEntity.class, (IDataSerializer)DataSerializers.field_187200_j);
    private static final DataParameter<BlockPos> DATA_SPAWNER_SBoundMax = EntityDataManager.func_187226_a(ExtendedStructureSpawnerEntity.class, (IDataSerializer)DataSerializers.field_187200_j);
    private ExtendedStructureEntitySpawner spawnerInstance = ExtendedStructureEntitySpawner.EMPTY;
    private ResourceLocation spawnerType;
    private static boolean isInvisible = true;
    private boolean queueToRemove = false;
    private boolean firstTick = true;
    public double spin = 0.0;
    public double spinO = 0.0;

    public ExtendedStructureSpawnerEntity(EntityType<? extends ExtendedStructureSpawnerEntity> pType, World pLevel) {
        super(pType, pLevel);
    }

    public ExtendedStructureSpawnerEntity(World pLevel) {
        this((EntityType<? extends ExtendedStructureSpawnerEntity>)((EntityType)ExtendedEntities.STRUCTURE_ENTITY_SPAWNER.get()), pLevel);
    }

    public void func_70071_h_() {
        this.field_70145_X = true;
        super.func_70071_h_();
        this.field_70145_X = false;
        this.func_189654_d(true);
        this.func_213317_d(Vector3d.field_186680_a);
        if (this.field_70170_p.func_201670_d()) {
            this.spinO = this.spin;
            this.spin = (this.spin + 0.1) % 360.0;
        }
        this.func_184224_h(true);
        if (!this.field_70170_p.func_201670_d()) {
            if (this.queueToRemove) {
                this.func_70106_y();
            } else {
                if (this.spawnerInstance.isEmptySpawner() && this.spawnerType != null && !this.spawnerType.equals((Object)ExtendedSpawners.EMPTY) && !((Boolean)ExtendedServerConfig.enableDevMode.get()).booleanValue()) {
                    this.setSpawnerFromResourceLocation();
                }
                if (!this.spawnerInstance.isEmptySpawner() && this.spawnerInstance.shouldTick() && !this.spawnerInstance.getSpawnType().isUnknown() && (this.field_70173_aa % this.spawnerInstance.getEntitySpawnTickRate() == 0 || this.firstTick) && this.trySpawningEntities((ServerWorld)this.field_70170_p)) {
                    this.firstTick = false;
                }
            }
        }
    }

    private boolean trySpawningEntities(ServerWorld world) {
        if (!world.func_175707_a(this.getCMinBlockPos(), this.getCMaxBlockPos())) {
            return false;
        }
        if (world.func_217358_a(this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), (double)this.spawnerInstance.getPlayerMinSpawnDistance())) {
            return false;
        }
        if (!world.func_217358_a(this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), (double)this.spawnerInstance.getPlayerMaxSpawnDistance())) {
            return false;
        }
        int nearbyEntitySpawnCount = 0;
        if (this.spawnerInstance.getSpawnType().isShouldCheckBoundries()) {
            AxisAlignedBB checkBox = new AxisAlignedBB(this.getCMinBlockPos(), this.getCMaxBlockPos());
            Predicate<LivingEntity> pred = entity -> ExtendedStructureEntitySpawnManager.INSTANCE.getEntities(this.spawnerInstance.getId().toString(), this.spawnerInstance.getEntries()).contains(entity.func_200600_R().getRegistryName().toString());
            nearbyEntitySpawnCount = world.func_175647_a(LivingEntity.class, checkBox, pred).size();
        }
        block0: for (int roll = 0; roll < this.spawnerInstance.getPoolRolls(); ++roll) {
            if (this.spawnerInstance.shouldCheckRandomDiscardChance() && this.field_70146_Z.nextInt(100) + 1 <= this.spawnerInstance.getRandomDiscardChance()) continue;
            for (int attempt = 0; attempt < 16; ++attempt) {
                if (nearbyEntitySpawnCount < this.spawnerInstance.getLocalSpawnCap() || !this.spawnerInstance.getSpawnType().isShouldCheckBoundries()) {
                    int y;
                    int z;
                    int x;
                    if (this.spawnerInstance.getSpawnType().isShouldCheckBoundries() && !this.shouldSpawnInside()) {
                        x = MathHelper.func_76128_c((double)this.func_226277_ct_()) + MathHelper.func_76136_a((Random)this.field_70146_Z, (int)(-this.spawnerInstance.getSpawnBoundaries().horizontalBounds), (int)this.spawnerInstance.getSpawnBoundaries().horizontalBounds);
                        z = MathHelper.func_76128_c((double)this.func_226281_cx_()) + MathHelper.func_76136_a((Random)this.field_70146_Z, (int)(-this.spawnerInstance.getSpawnBoundaries().horizontalBounds), (int)this.spawnerInstance.getSpawnBoundaries().horizontalBounds);
                        y = world.func_201676_a(Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, x, z);
                        if (!this.spawnerInstance.getSpawnBoundaries().isInYRange(y, MathHelper.func_76128_c((double)this.func_226278_cu_()))) {
                            continue;
                        }
                    } else {
                        x = MathHelper.func_76128_c((double)this.func_226277_ct_());
                        y = MathHelper.func_76128_c((double)this.func_226278_cu_());
                        z = MathHelper.func_76128_c((double)this.func_226281_cx_());
                    }
                    BlockPos footPos = new BlockPos(x, y, z);
                    if (this.spawnerInstance.getSpawnType().isShouldCheckBoundries()) {
                        BlockState headBlock;
                        BlockState footBlock;
                        if (this.spawnerInstance.insideSpawning()) {
                            BlockState potentialFloorBlock1 = world.func_180495_p(footPos);
                            if (!Block.func_208061_a((VoxelShape)potentialFloorBlock1.func_215685_b((IBlockReader)world, footPos, ISelectionContext.func_216377_a()), (Direction)Direction.UP) || !potentialFloorBlock1.func_185904_a().func_76220_a()) {
                                BlockState potentialFloorBlock2 = world.func_180495_p(footPos.func_177977_b());
                                if (!Block.func_208061_a((VoxelShape)potentialFloorBlock2.func_215685_b((IBlockReader)world, footPos.func_177977_b(), ISelectionContext.func_216377_a()), (Direction)Direction.UP) || !potentialFloorBlock2.func_185904_a().func_76220_a()) {
                                    BlockState potentialFloorBlock3 = world.func_180495_p(footPos.func_177977_b().func_177977_b());
                                    if (!Block.func_208061_a((VoxelShape)potentialFloorBlock3.func_215685_b((IBlockReader)world, footPos.func_177977_b().func_177977_b(), ISelectionContext.func_216377_a()), (Direction)Direction.UP) || !potentialFloorBlock3.func_185904_a().func_76220_a()) continue;
                                    BlockState footBlock2 = world.func_180495_p(footPos);
                                    BlockState headBlock2 = world.func_180495_p(footPos.func_177984_a());
                                    if (!footBlock2.func_177230_c().func_181623_g() || !headBlock2.func_177230_c().func_181623_g()) {
                                        continue;
                                    }
                                } else {
                                    BlockState footBlock3 = world.func_180495_p(footPos.func_177984_a());
                                    BlockState headBlock3 = world.func_180495_p(footPos.func_177984_a().func_177984_a());
                                    if (!footBlock3.func_177230_c().func_181623_g() || !headBlock3.func_177230_c().func_181623_g()) {
                                        continue;
                                    }
                                }
                            } else {
                                footBlock = world.func_180495_p(footPos);
                                headBlock = world.func_180495_p(footPos.func_177984_a());
                                if (!footBlock.func_177230_c().func_181623_g() || !headBlock.func_177230_c().func_181623_g()) {
                                    continue;
                                }
                            }
                        } else {
                            BlockState floorBlock = world.func_180495_p(new BlockPos(x, y - 1, z));
                            if (!Block.func_208061_a((VoxelShape)floorBlock.func_215685_b((IBlockReader)world, new BlockPos(x, y - 1, z), ISelectionContext.func_216377_a()), (Direction)Direction.UP) || !floorBlock.func_185904_a().func_76220_a()) continue;
                            footBlock = world.func_180495_p(footPos);
                            headBlock = world.func_180495_p(new BlockPos(x, y + 1, z));
                            if (!footBlock.func_177230_c().func_181623_g() || !headBlock.func_177230_c().func_181623_g()) continue;
                        }
                    }
                    List<EntityType<?>> generatedSpawns = this.spawnerInstance.getSpawns(this.field_70146_Z);
                    for (EntityType<?> generatedSpawn : generatedSpawns) {
                        if (this.spawnerInstance.getSpawnType().equals((Object)SpawnerType.SINGLE_FAMILY)) {
                            Entity entityMale = generatedSpawn.func_200721_a((World)world);
                            Entity entityFemale = generatedSpawn.func_200721_a((World)world);
                            if (!(entityMale instanceof NPCEntity) || !(entityFemale instanceof NPCEntity)) {
                                // empty if block
                            }
                            NPCEntity entityMaleNpc = (NPCEntity)entityMale;
                            NPCEntity entityFemaleNpc = (NPCEntity)entityFemale;
                            if (((MixinNPCEntityInvoker)entityMaleNpc).invokeGenderProvider().equals(NPCGenderProvider.MALE) || ((MixinNPCEntityInvoker)entityMaleNpc).invokeGenderProvider().equals(NPCGenderProvider.FEMALE) || ((MixinNPCEntityInvoker)entityFemaleNpc).invokeGenderProvider().equals(NPCGenderProvider.MALE) || ((MixinNPCEntityInvoker)entityFemaleNpc).invokeGenderProvider().equals(NPCGenderProvider.FEMALE)) {
                                ExtendedLog.error("Failed spawning %s because it does not support multiple genders - %s", generatedSpawn.getRegistryName().toString(), this.spawnerInstance.getId().toString());
                                return false;
                            }
                            entityMaleNpc.getPersonalInfo().setMale(true);
                            entityMaleNpc.getPersonalInfo().setName(((MixinNPCEntityInvoker)entityMaleNpc).invokeNameGenerator().generateName(this.field_70146_Z, true));
                            entityFemaleNpc.getPersonalInfo().setMale(false);
                            entityFemaleNpc.getPersonalInfo().setName(((MixinNPCEntityInvoker)entityFemaleNpc).invokeNameGenerator().generateName(this.field_70146_Z, false));
                            entityMaleNpc.func_174828_a(footPos, this.field_70146_Z.nextFloat() * 360.0f, 0.0f);
                            entityFemaleNpc.func_174828_a(footPos, this.field_70146_Z.nextFloat() * 360.0f, 0.0f);
                            entityMaleNpc.func_213386_a((IServerWorld)world, world.func_175649_E(footPos), SpawnReason.SPAWNER, null, null);
                            entityMaleNpc.func_110163_bv();
                            entityFemaleNpc.func_213386_a((IServerWorld)world, world.func_175649_E(footPos), SpawnReason.SPAWNER, null, null);
                            entityFemaleNpc.func_110163_bv();
                            if (!this.spawnerInstance.isSetHomePositionOnSpawn()) {
                                entityMaleNpc.clearHomePos();
                                entityFemaleNpc.clearHomePos();
                            } else {
                                entityMaleNpc.func_213390_a(this.func_233580_cy_(), this.spawnerInstance.getHomeRadius());
                                entityFemaleNpc.func_213390_a(this.func_233580_cy_(), this.spawnerInstance.getHomeRadius());
                            }
                            ExtendedNpcMarriageHolder marriageInfoMale = ((ExtendedNPCEntity)entityMaleNpc).getMarriageInfo();
                            marriageInfoMale.maleID = entityMaleNpc.func_110124_au();
                            marriageInfoMale.femaleID = entityFemaleNpc.func_110124_au();
                            marriageInfoMale.spouseID = entityFemaleNpc.func_110124_au();
                            ExtendedNpcMarriageHolder marriageInfoFemale = ((ExtendedNPCEntity)entityFemaleNpc).getMarriageInfo();
                            marriageInfoFemale.maleID = entityMaleNpc.func_110124_au();
                            marriageInfoFemale.femaleID = entityFemaleNpc.func_110124_au();
                            marriageInfoFemale.spouseID = entityMaleNpc.func_110124_au();
                            world.func_242417_l((Entity)entityMaleNpc);
                            world.func_242417_l((Entity)entityFemaleNpc);
                            attempt = 100;
                            roll = 100;
                        } else {
                            Entity entity2 = generatedSpawn.func_200721_a((World)world);
                            entity2.func_174828_a(footPos, this.field_70146_Z.nextFloat() * 360.0f, 0.0f);
                            if (entity2 instanceof NPCEntity) {
                                ((NPCEntity)entity2).func_213386_a((IServerWorld)world, world.func_175649_E(footPos), SpawnReason.SPAWNER, null, null);
                                ((NPCEntity)entity2).func_110163_bv();
                                if (!this.spawnerInstance.isSetHomePositionOnSpawn()) {
                                    ((NPCEntity)entity2).clearHomePos();
                                } else if (this.spawnerInstance.isSetHomeRandom()) {
                                    ((NPCEntity)entity2).func_213390_a(footPos, this.spawnerInstance.getHomeRadius());
                                } else {
                                    ((NPCEntity)entity2).func_213390_a(this.func_233580_cy_(), this.spawnerInstance.getHomeRadius());
                                }
                            } else if (entity2 instanceof MobEntity) {
                                ((MobEntity)entity2).func_213386_a((IServerWorld)world, world.func_175649_E(footPos), SpawnReason.SPAWNER, null, null);
                                ((MobEntity)entity2).func_110163_bv();
                                if (!this.spawnerInstance.isSetHomePositionOnSpawn()) {
                                    ((MobEntity)entity2).func_213390_a(BlockPos.field_177992_a, -1);
                                } else if (this.spawnerInstance.isSetHomeRandom()) {
                                    ((MobEntity)entity2).func_213390_a(footPos, this.spawnerInstance.getHomeRadius());
                                } else {
                                    ((MobEntity)entity2).func_213390_a(this.func_233580_cy_(), this.spawnerInstance.getHomeRadius());
                                }
                            } else {
                                ExtendedLog.error("Failed spawning %s because it is not a supported Entity Class - %s", generatedSpawn.getRegistryName().toString(), this.spawnerInstance.getId().toString());
                                return false;
                            }
                            world.func_242417_l(entity2);
                            if (++nearbyEntitySpawnCount < this.spawnerInstance.getLocalSpawnCap() || !this.spawnerInstance.getSpawnType().isShouldCheckBoundries()) continue;
                            attempt = 100;
                            roll = 100;
                        }
                        break;
                    }
                } else {
                    attempt = 100;
                    roll = 100;
                    continue block0;
                }
                attempt = 100;
            }
        }
        if (this.spawnerInstance.getSpawnType().isSingleSpawnType()) {
            this.queueToRemove = true;
        }
        return true;
    }

    private boolean shouldSpawnInside() {
        return this.spawnerInstance.insideSpawning() && this.field_70146_Z.nextInt(100) + 1 <= this.spawnerInstance.getinsideSpawningChance();
    }

    private void setSpawnerFromResourceLocation() {
        this.spawnerInstance = ExtendedStructureEntitySpawnManager.INSTANCE.get(this.spawnerType);
        if (this.spawnerInstance.isEmptySpawner()) {
            ExtendedLog.warn("Structure Spawner loaded and invalid SpawnerType %s, spawner has been set to default %s preset!", this.spawnerType.toString(), ExtendedSpawners.EMPTY.toString());
        }
        this.func_184212_Q().func_187227_b(DATA_SPAWNER_TYPE, (Object)this.spawnerType.toString());
        this.reCalculateBounds();
    }

    public void setSpawnerToDefaultPreset(ResourceLocation preset, boolean isCreation) {
        this.spawnerType = preset;
        if (!isCreation) {
            this.setSpawnerFromResourceLocation();
        } else {
            this.spawnerInstance = ExtendedStructureEntitySpawner.EMPTY;
        }
    }

    protected void func_70037_a(CompoundNBT pCompound) {
        if (pCompound.func_74764_b("spawnerData")) {
            this.spawnerInstance = ExtendedStructureEntitySpawnManager.deserialize(ExtendedStructureEntitySpawnManager.GSON, pCompound.func_74779_i("spawnerData"), ExtendedStructureEntitySpawner.class);
            this.func_184212_Q().func_187227_b(DATA_SPAWNER_TYPE, (Object)this.spawnerInstance.getId().toString());
            this.reCalculateBounds();
        } else if (pCompound.func_74764_b("setSpawnerType")) {
            this.spawnerType = new ResourceLocation(pCompound.func_74779_i("setSpawnerType"));
            this.func_184212_Q().func_187227_b(DATA_SPAWNER_TYPE, (Object)this.spawnerType.toString());
            this.reCalculateBounds();
        }
        if (pCompound.func_74764_b("firstTick")) {
            this.firstTick = pCompound.func_74767_n("firstTick");
        }
    }

    protected void func_213281_b(CompoundNBT pCompound) {
        if (!this.spawnerInstance.isEmptySpawner() && this.spawnerInstance.isCustom()) {
            pCompound.func_74778_a("spawnerData", ExtendedStructureEntitySpawnManager.serialize(ExtendedStructureEntitySpawnManager.GSON, this.spawnerInstance));
        } else if (!this.spawnerInstance.isEmptySpawner() && !this.spawnerInstance.isCustom()) {
            pCompound.func_74778_a("setSpawnerType", this.spawnerInstance.getId().toString());
        } else if (this.spawnerInstance.isEmptySpawner() && this.spawnerType != null) {
            pCompound.func_74778_a("setSpawnerType", this.spawnerType.toString());
        } else {
            pCompound.func_74778_a("setSpawnerType", ExtendedSpawners.EMPTY.toString());
        }
        if (!this.firstTick) {
            pCompound.func_74757_a("firstTick", false);
        }
    }

    public ActionResultType func_184230_a(PlayerEntity pPlayer, Hand pHand) {
        if (!pPlayer.field_70170_p.func_201670_d() && pPlayer.func_184812_l_()) {
            pPlayer.func_145747_a((ITextComponent)new StringTextComponent("Spawner Raw Type: ").func_240699_a_(TextFormatting.GREEN).func_230529_a_((ITextComponent)new StringTextComponent(this.spawnerType != null ? this.spawnerType.func_110623_a() : "Unset").func_240699_a_(TextFormatting.WHITE)), Util.field_240973_b_);
            pPlayer.func_145747_a((ITextComponent)new StringTextComponent("Spawner Instanced: ").func_240699_a_(TextFormatting.GREEN).func_230529_a_((ITextComponent)new StringTextComponent(this.spawnerInstance.getId().func_110623_a()).func_240699_a_(TextFormatting.WHITE)), Util.field_240973_b_);
            pPlayer.func_145747_a((ITextComponent)new StringTextComponent("Is Empty Spawner: ").func_240699_a_(TextFormatting.GREEN).func_230529_a_((ITextComponent)new StringTextComponent(Boolean.toString(this.spawnerInstance.isEmptySpawner())).func_240699_a_(TextFormatting.WHITE)).func_230529_a_((ITextComponent)new StringTextComponent(", Is Ticking: ").func_240699_a_(TextFormatting.GREEN)).func_230529_a_((ITextComponent)new StringTextComponent(Boolean.toString(this.spawnerInstance.shouldTick())).func_240699_a_(TextFormatting.WHITE)), Util.field_240973_b_);
            pPlayer.func_145747_a((ITextComponent)new StringTextComponent("Local Spawn Cap: ").func_240699_a_(TextFormatting.GREEN).func_230529_a_((ITextComponent)new StringTextComponent(Integer.toString(this.spawnerInstance.getLocalSpawnCap())).func_240699_a_(TextFormatting.WHITE)).func_230529_a_((ITextComponent)new StringTextComponent(", Spawn TickRate: ").func_240699_a_(TextFormatting.GREEN)).func_230529_a_((ITextComponent)new StringTextComponent(Integer.toString(this.spawnerInstance.getEntitySpawnTickRate())).func_240699_a_(TextFormatting.WHITE)), Util.field_240973_b_);
            pPlayer.func_145747_a((ITextComponent)new StringTextComponent("Inside Spawning: ").func_240699_a_(TextFormatting.GREEN).func_230529_a_((ITextComponent)new StringTextComponent(Boolean.toString(this.spawnerInstance.insideSpawning())).func_240699_a_(TextFormatting.WHITE)).func_230529_a_((ITextComponent)new StringTextComponent(", Inside Chance: ").func_240699_a_(TextFormatting.GREEN)).func_230529_a_((ITextComponent)new StringTextComponent(Integer.toString(this.spawnerInstance.getinsideSpawningChance())).func_240699_a_(TextFormatting.WHITE)), Util.field_240973_b_);
            String str = "";
            for (String entity : ExtendedStructureEntitySpawnManager.INSTANCE.getEntities(this.spawnerInstance.getId().toString(), this.spawnerInstance.getEntries())) {
                if (str.equals("")) {
                    str = entity;
                    continue;
                }
                str = str + ", " + entity;
            }
            pPlayer.func_145747_a((ITextComponent)new StringTextComponent("Pool Entities: ").func_240699_a_(TextFormatting.GREEN).func_230529_a_((ITextComponent)new StringTextComponent(str).func_240699_a_(TextFormatting.WHITE)), Util.field_240973_b_);
            if (this.spawnerInstance.shouldTick()) {
                int tickModulus = this.field_70173_aa % this.spawnerInstance.getEntitySpawnTickRate();
                double percent = (float)tickModulus / (float)this.spawnerInstance.getEntitySpawnTickRate();
                pPlayer.func_145747_a((ITextComponent)new StringTextComponent("Current tick times: ").func_240699_a_(TextFormatting.GREEN).func_230529_a_((ITextComponent)new StringTextComponent(Integer.toString(tickModulus)).func_240699_a_(TextFormatting.WHITE)), Util.field_240973_b_);
                pPlayer.func_145747_a((ITextComponent)new StringTextComponent("Current spawns percents: ").func_240699_a_(TextFormatting.GREEN).func_230529_a_((ITextComponent)new StringTextComponent(String.format(Locale.US, "%.2f", percent * 100.0)).func_240699_a_(TextFormatting.WHITE)), Util.field_240973_b_);
                pPlayer.func_145747_a((ITextComponent)new StringTextComponent("Current spawns sec till: ").func_240699_a_(TextFormatting.GREEN).func_230529_a_((ITextComponent)new StringTextComponent(String.format(Locale.US, "%.2f", (1.0 - percent) * (double)((float)this.spawnerInstance.getEntitySpawnTickRate() / 20.0f))).func_240699_a_(TextFormatting.WHITE)), Util.field_240973_b_);
                pPlayer.func_145747_a((ITextComponent)new StringTextComponent("Current spawns min till: ").func_240699_a_(TextFormatting.GREEN).func_230529_a_((ITextComponent)new StringTextComponent(String.format(Locale.US, "%.2f", (1.0 - percent) * (double)((float)this.spawnerInstance.getEntitySpawnTickRate() / 20.0f / 60.0f))).func_240699_a_(TextFormatting.WHITE)), Util.field_240973_b_);
            }
            pPlayer.func_145747_a((ITextComponent)new StringTextComponent("In future will open GUI"), Util.field_240973_b_);
        }
        return ActionResultType.func_233537_a_((boolean)this.field_70170_p.field_72995_K);
    }

    public ItemStack getPickedResult(RayTraceResult target) {
        ItemStack stack = new ItemStack((IItemProvider)ExtendedItems.ENTITY_SPAWNER.get());
        if (!this.getSpawnerName().equals(ExtendedSpawners.EMPTY.toString())) {
            if (stack.func_77942_o()) {
                CompoundNBT nbt = stack.func_77978_p();
                nbt.func_74778_a("setSpawnerType", this.getSpawnerName());
                stack.func_77982_d(nbt);
            } else {
                CompoundNBT nbt = new CompoundNBT();
                nbt.func_74778_a("setSpawnerType", this.getSpawnerName());
                stack.func_77982_d(nbt);
            }
        }
        return stack;
    }

    public void func_82142_c(boolean pInvisible) {
        if (!this.field_70170_p.func_201670_d()) {
            super.func_82142_c(pInvisible);
        }
    }

    public boolean func_82150_aj() {
        if (!this.field_70170_p.func_201670_d()) {
            return super.func_82150_aj();
        }
        return isInvisible;
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean func_98034_c(PlayerEntity pPlayer) {
        if (pPlayer.func_175149_v() || pPlayer.func_184812_l_() || ((Boolean)ExtendedClientConfig.enableDevMode.get()).booleanValue()) {
            isInvisible = false;
            return false;
        }
        isInvisible = true;
        return true;
    }

    public BlockPos getCMinBlockPos() {
        return (BlockPos)this.func_184212_Q().func_187225_a(DATA_SPAWNER_CBoundMin);
    }

    public BlockPos getCMaxBlockPos() {
        return (BlockPos)this.func_184212_Q().func_187225_a(DATA_SPAWNER_CBoundMax);
    }

    public BlockPos getSMinBlockPos() {
        return (BlockPos)this.func_184212_Q().func_187225_a(DATA_SPAWNER_SBoundMin);
    }

    public BlockPos getSMaxBlockPos() {
        return (BlockPos)this.func_184212_Q().func_187225_a(DATA_SPAWNER_SBoundMax);
    }

    public String getSpawnerName() {
        return (String)this.func_184212_Q().func_187225_a(DATA_SPAWNER_TYPE);
    }

    public void reCalculateBounds() {
        this.func_184212_Q().func_187227_b(DATA_SPAWNER_CBoundMin, (Object)this.spawnerInstance.getCheckBoundaries().getMinPos(MathHelper.func_76128_c((double)this.func_226277_ct_()), MathHelper.func_76128_c((double)this.func_226278_cu_()), MathHelper.func_76128_c((double)this.func_226281_cx_())));
        this.func_184212_Q().func_187227_b(DATA_SPAWNER_CBoundMax, (Object)this.spawnerInstance.getCheckBoundaries().getMaxPos(MathHelper.func_76128_c((double)this.func_226277_ct_()), MathHelper.func_76128_c((double)this.func_226278_cu_()), MathHelper.func_76128_c((double)this.func_226281_cx_())));
        this.func_184212_Q().func_187227_b(DATA_SPAWNER_SBoundMin, (Object)this.spawnerInstance.getSpawnBoundaries().getMinPos(MathHelper.func_76128_c((double)this.func_226277_ct_()), MathHelper.func_76128_c((double)this.func_226278_cu_()), MathHelper.func_76128_c((double)this.func_226281_cx_())));
        this.func_184212_Q().func_187227_b(DATA_SPAWNER_SBoundMax, (Object)this.spawnerInstance.getSpawnBoundaries().getMaxPos(MathHelper.func_76128_c((double)this.func_226277_ct_()), MathHelper.func_76128_c((double)this.func_226278_cu_()), MathHelper.func_76128_c((double)this.func_226281_cx_())));
    }

    public ITextComponent func_145748_c_() {
        if (!this.getSpawnerName().equals(ExtendedSpawners.EMPTY.toString())) {
            return new StringTextComponent("Spawner type: " + this.getSpawnerName());
        }
        return this.func_200200_C_();
    }

    public void func_70106_y() {
        if (!this.queueToRemove) {
            this.field_70170_p.func_184148_a((PlayerEntity)null, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), SoundEvents.field_187561_bM, SoundCategory.NEUTRAL, 0.5f, 0.4f / (this.field_70146_Z.nextFloat() * 0.4f + 0.8f));
        }
        super.func_70106_y();
    }

    protected void func_70088_a() {
        this.func_184212_Q().func_187214_a(DATA_SPAWNER_TYPE, (Object)ExtendedSpawners.EMPTY.toString());
        this.func_184212_Q().func_187214_a(DATA_SPAWNER_CBoundMin, (Object)BlockPos.field_177992_a);
        this.func_184212_Q().func_187214_a(DATA_SPAWNER_CBoundMax, (Object)BlockPos.field_177992_a);
        this.func_184212_Q().func_187214_a(DATA_SPAWNER_SBoundMin, (Object)BlockPos.field_177992_a);
        this.func_184212_Q().func_187214_a(DATA_SPAWNER_SBoundMax, (Object)BlockPos.field_177992_a);
    }

    public boolean func_184222_aU() {
        return false;
    }

    public boolean func_145773_az() {
        return true;
    }

    public boolean func_180427_aV() {
        return true;
    }

    public boolean func_230279_az_() {
        return true;
    }

    public boolean func_70027_ad() {
        return false;
    }

    public boolean func_70097_a(DamageSource pSource, float pAmount) {
        if (this.func_180431_b(pSource)) {
            return false;
        }
        Entity entity = pSource.func_76346_g();
        if (entity != null && entity instanceof PlayerEntity && ((PlayerEntity)entity).field_71075_bZ.field_75098_d) {
            if (((PlayerEntity)entity).func_213453_ef()) {
                this.func_70106_y();
            }
        } else {
            this.func_70106_y();
        }
        return false;
    }

    public boolean func_70067_L() {
        return true;
    }

    public boolean func_70104_M() {
        return false;
    }

    public boolean func_241845_aY() {
        return false;
    }

    protected boolean func_184228_n(Entity pEntity) {
        return false;
    }

    public boolean func_190530_aW() {
        return true;
    }

    public PushReaction func_184192_z() {
        return PushReaction.IGNORE;
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }
}

