/*
 * Decompiled with CFR 0.152.
 */
package com.github.maximuslotro.lotrrextended.common.entity.special;

import com.github.maximuslotro.lotrrextended.ExtendedLog;
import com.github.maximuslotro.lotrrextended.common.spawners.ExtendedStructureEntitySpawnerEntry;
import java.util.Locale;
import lotr.common.entity.npc.ExtendedCaptainEntity;
import lotr.common.entity.npc.ExtendedTraderEntity;
import lotr.common.entity.npc.NPCEntity;
import lotr.common.init.ExtendedEntities;
import net.minecraft.block.material.PushReaction;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.SpawnEggItem;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.network.IPacket;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ForgeSpawnEggItem;
import net.minecraftforge.fml.network.NetworkHooks;

public class ExtendedTraderRespawnEntity
extends Entity {
    private static final DataParameter<String> DATA_SPAWNER_TYPE = EntityDataManager.func_187226_a(ExtendedTraderRespawnEntity.class, (IDataSerializer)DataSerializers.field_187194_d);
    private static final DataParameter<Integer> TICKPERCENTAGE = EntityDataManager.func_187226_a(ExtendedTraderRespawnEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    private boolean queueToRemove = false;
    private int setEntityTickBackRate;
    private int entityTickBacksRemaining = this.setEntityTickBackRate = 24000;
    public double spin = 0.0;
    public double spinO = 0.0;
    public boolean offTick = false;
    private CompoundNBT nbt = new CompoundNBT();
    private String entityType;
    private BlockPos homePos = BlockPos.field_177992_a;
    private int homeRadius = -1;

    public ExtendedTraderRespawnEntity(EntityType<? extends ExtendedTraderRespawnEntity> pType, World pLevel) {
        super(pType, pLevel);
    }

    public ExtendedTraderRespawnEntity(World pLevel) {
        this((EntityType<? extends ExtendedTraderRespawnEntity>)((EntityType)ExtendedEntities.TRADER_RESPAWNER_ENTITY.get()), pLevel);
    }

    public void setTickValues(int tickBackRate) {
        this.entityTickBacksRemaining = this.setEntityTickBackRate = tickBackRate;
        this.func_184212_Q().func_187227_b(TICKPERCENTAGE, (Object)this.entityTickBacksRemaining);
    }

    public void setEntityType(EntityType<?> type) {
        this.entityType = type.getRegistryName().toString();
        this.func_184212_Q().func_187227_b(DATA_SPAWNER_TYPE, (Object)this.entityType);
    }

    public void setEntityData(CompoundNBT compund) {
        this.nbt = compund;
    }

    public void setHomeInfo(BlockPos homePos, int homeRadius) {
        this.homeRadius = homeRadius;
        this.homePos = homePos;
    }

    public void func_70071_h_() {
        this.field_70145_X = true;
        super.func_70071_h_();
        this.field_70145_X = false;
        this.func_189654_d(true);
        if (this.field_70170_p.func_201670_d()) {
            this.spinO = this.spin;
            this.spin = (this.spin + (double)(1000.0f / (float)this.getTickpercentage())) % 360.0;
        }
        this.func_213317_d(Vector3d.field_186680_a);
        this.func_184224_h(true);
        if (this.field_70173_aa % 20 == 0 && !this.field_70170_p.func_201670_d()) {
            this.func_184212_Q().func_187227_b(TICKPERCENTAGE, (Object)this.entityTickBacksRemaining);
        }
        if (!this.field_70170_p.func_201670_d()) {
            if (this.queueToRemove) {
                this.func_70106_y();
            } else if (this.entityTickBacksRemaining == 0) {
                this.spawnTrader((ServerWorld)this.field_70170_p);
            } else if (this.entityTickBacksRemaining != -1) {
                --this.entityTickBacksRemaining;
            }
        }
    }

    private void spawnTrader(ServerWorld world) {
        Entity spawnedEntity;
        EntityType<?> traderEntityType = ExtendedStructureEntitySpawnerEntry.Serializer.getEntityTypeFromString(this.entityType);
        if (traderEntityType != null) {
            spawnedEntity = traderEntityType.func_200721_a((World)world);
            spawnedEntity.func_225653_b_(this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_());
            if (spawnedEntity instanceof NPCEntity) {
                NPCEntity npcEntity = (NPCEntity)spawnedEntity;
                npcEntity.func_213386_a((IServerWorld)world, world.func_175649_E(this.func_226268_ag_()), SpawnReason.SPAWNER, null, null);
                npcEntity.func_110163_bv();
                if (this.homeRadius > 0) {
                    npcEntity.func_213390_a(this.homePos, this.homeRadius);
                }
            }
            if (spawnedEntity instanceof ExtendedTraderEntity) {
                ((ExtendedTraderEntity)spawnedEntity).loadAllTrades(this.nbt);
            }
            if (spawnedEntity instanceof ExtendedCaptainEntity) {
                // empty if block
            }
        } else {
            ExtendedLog.error("Entity Respawner tried spawning unknown entity! " + this.entityType + ", with data: " + this.nbt.toString());
            this.queueToRemove = false;
            return;
        }
        world.func_217376_c(spawnedEntity);
        this.queueToRemove = true;
    }

    protected void func_70037_a(CompoundNBT pCompound) {
        if (pCompound.func_74764_b("entityType")) {
            this.entityType = pCompound.func_74779_i("entityType");
            this.func_184212_Q().func_187227_b(DATA_SPAWNER_TYPE, (Object)this.entityType);
        } else {
            this.queueToRemove = true;
        }
        this.entityTickBacksRemaining = pCompound.func_74764_b("ticksRemaining") ? pCompound.func_74762_e("ticksRemaining") : this.setEntityTickBackRate;
        this.func_184212_Q().func_187227_b(TICKPERCENTAGE, (Object)this.entityTickBacksRemaining);
        if (pCompound.func_74764_b("ticksSet")) {
            this.setEntityTickBackRate = pCompound.func_74762_e("ticksSet");
        }
        this.nbt = pCompound.func_74764_b("traderTrades") ? pCompound.func_74775_l("traderTrades") : new CompoundNBT();
        if (pCompound.func_74764_b("homeRadius")) {
            this.homeRadius = pCompound.func_74762_e("homeRadius");
        }
        if (pCompound.func_74764_b("homePos")) {
            this.homePos = NBTUtil.func_186861_c((CompoundNBT)pCompound.func_74775_l("homePos"));
        }
    }

    protected void func_213281_b(CompoundNBT pCompound) {
        if (this.entityType != null) {
            pCompound.func_74778_a("entityType", this.entityType);
        } else {
            this.queueToRemove = true;
        }
        pCompound.func_74768_a("ticksRemaining", this.entityTickBacksRemaining);
        pCompound.func_74768_a("ticksSet", this.setEntityTickBackRate);
        pCompound.func_218657_a("traderTrades", (INBT)this.nbt);
        if ((float)this.homeRadius != -1.0f) {
            pCompound.func_74768_a("homeRadius", this.homeRadius);
            pCompound.func_218657_a("homePos", (INBT)NBTUtil.func_186859_a((BlockPos)this.homePos));
        }
    }

    public ActionResultType func_184230_a(PlayerEntity pPlayer, Hand pHand) {
        if (!pPlayer.field_70170_p.func_201670_d() && pPlayer.func_184812_l_()) {
            pPlayer.func_145747_a((ITextComponent)new StringTextComponent("Spawner Entity: ").func_240699_a_(TextFormatting.GREEN).func_230529_a_((ITextComponent)new StringTextComponent(this.entityType != null ? this.entityType : "Unset").func_240699_a_(TextFormatting.WHITE)), Util.field_240973_b_);
            float percent = 1.0f - (float)this.entityTickBacksRemaining / (float)this.setEntityTickBackRate;
            pPlayer.func_145747_a((ITextComponent)new StringTextComponent("Current spawn percentage: ").func_240699_a_(TextFormatting.GREEN).func_230529_a_((ITextComponent)new StringTextComponent(String.format(Locale.US, "%.2f", Float.valueOf(percent * 100.0f))).func_240699_a_(TextFormatting.WHITE)), Util.field_240973_b_);
            pPlayer.func_145747_a((ITextComponent)new StringTextComponent("Current spawn ticks till: ").func_240699_a_(TextFormatting.GREEN).func_230529_a_((ITextComponent)new StringTextComponent(Integer.toString(this.entityTickBacksRemaining)).func_240699_a_(TextFormatting.WHITE)), Util.field_240973_b_);
            pPlayer.func_145747_a((ITextComponent)new StringTextComponent("Current spawns sec till: ").func_240699_a_(TextFormatting.GREEN).func_230529_a_((ITextComponent)new StringTextComponent(String.format(Locale.US, "%.2f", Float.valueOf((float)this.entityTickBacksRemaining / 20.0f))).func_240699_a_(TextFormatting.WHITE)), Util.field_240973_b_);
            pPlayer.func_145747_a((ITextComponent)new StringTextComponent("Current spawns min till: ").func_240699_a_(TextFormatting.GREEN).func_230529_a_((ITextComponent)new StringTextComponent(String.format(Locale.US, "%.2f", Float.valueOf((float)this.entityTickBacksRemaining / 20.0f / 60.0f))).func_240699_a_(TextFormatting.WHITE)), Util.field_240973_b_);
            pPlayer.func_145747_a((ITextComponent)new StringTextComponent("In future will open GUI"), Util.field_240973_b_);
        }
        return ActionResultType.func_233537_a_((boolean)this.field_70170_p.field_72995_K);
    }

    public ItemStack getPickedResult(RayTraceResult target) {
        if (this.getSpawnerName() != null) {
            SpawnEggItem egg = ForgeSpawnEggItem.fromEntityType(ExtendedStructureEntitySpawnerEntry.Serializer.getEntityTypeFromString(this.getSpawnerName()));
            if (egg == null) {
                return ItemStack.field_190927_a;
            }
            return new ItemStack((IItemProvider)egg);
        }
        return ItemStack.field_190927_a;
    }

    public void func_82142_c(boolean pInvisible) {
        super.func_82142_c(false);
    }

    public boolean func_82150_aj() {
        return false;
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean func_98034_c(PlayerEntity pPlayer) {
        return false;
    }

    public ITextComponent func_145748_c_() {
        return new StringTextComponent("Trader Respawner: " + this.getSpawnerName());
    }

    public void func_70106_y() {
        if (!this.queueToRemove) {
            this.field_70170_p.func_184148_a((PlayerEntity)null, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), SoundEvents.field_187561_bM, SoundCategory.NEUTRAL, 0.5f, 0.4f / (this.field_70146_Z.nextFloat() * 0.4f + 0.8f));
        }
        super.func_70106_y();
    }

    public String getSpawnerName() {
        return (String)this.func_184212_Q().func_187225_a(DATA_SPAWNER_TYPE);
    }

    protected void func_70088_a() {
        this.func_184212_Q().func_187214_a(DATA_SPAWNER_TYPE, (Object)"empty");
        this.func_184212_Q().func_187214_a(TICKPERCENTAGE, (Object)3600);
    }

    public boolean func_184222_aU() {
        return false;
    }

    public boolean func_145773_az() {
        return true;
    }

    public boolean func_180427_aV() {
        return true;
    }

    public boolean func_230279_az_() {
        return true;
    }

    public boolean func_70027_ad() {
        return false;
    }

    public boolean func_70097_a(DamageSource pSource, float pAmount) {
        if (this.func_180431_b(pSource)) {
            return false;
        }
        Entity entity = pSource.func_76346_g();
        if (entity != null && entity instanceof PlayerEntity && ((PlayerEntity)entity).field_71075_bZ.field_75098_d) {
            if (((PlayerEntity)entity).func_213453_ef()) {
                this.func_70106_y();
            }
        } else {
            this.func_70106_y();
        }
        return false;
    }

    public boolean func_70067_L() {
        return true;
    }

    public boolean func_70104_M() {
        return false;
    }

    public boolean func_241845_aY() {
        return false;
    }

    protected boolean func_184228_n(Entity pEntity) {
        return false;
    }

    public boolean func_190530_aW() {
        return true;
    }

    public PushReaction func_184192_z() {
        return PushReaction.IGNORE;
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public int getTickpercentage() {
        return (Integer)this.func_184212_Q().func_187225_a(TICKPERCENTAGE);
    }
}

