/*
 * Decompiled with CFR 0.152.
 */
package com.github.maximuslotro.lotrrextended.common.eventhandlers;

import com.github.maximuslotro.lotrrextended.common.bannerprotection.ExtendedBannerProtectionManager;
import com.github.maximuslotro.lotrrextended.common.block.ExtendedBookshelfBlock;
import com.github.maximuslotro.lotrrextended.common.block.ExtendedConquestTableBlock;
import com.github.maximuslotro.lotrrextended.common.block.ExtendedMEBannerBlock;
import com.github.maximuslotro.lotrrextended.common.block.ExtendedWeaponRackBlock;
import com.github.maximuslotro.lotrrextended.common.enums.BannerPermission;
import java.util.List;
import lotr.common.block.FactionCraftingTableBlock;
import lotr.common.block.GateBlock;
import lotr.common.block.KegBlock;
import lotr.common.block.PlateBlock;
import lotr.common.block.VesselDrinkBlock;
import lotr.common.entity.npc.NPCEntity;
import net.minecraft.block.AbstractButtonBlock;
import net.minecraft.block.AnvilBlock;
import net.minecraft.block.BedBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.CakeBlock;
import net.minecraft.block.CampfireBlock;
import net.minecraft.block.CraftingTableBlock;
import net.minecraft.block.DaylightDetectorBlock;
import net.minecraft.block.DoorBlock;
import net.minecraft.block.EnderChestBlock;
import net.minecraft.block.FenceGateBlock;
import net.minecraft.block.FireBlock;
import net.minecraft.block.JukeboxBlock;
import net.minecraft.block.LecternBlock;
import net.minecraft.block.LeverBlock;
import net.minecraft.block.TrapDoorBlock;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.item.ArmorStandEntity;
import net.minecraft.entity.item.HangingEntity;
import net.minecraft.entity.item.TNTEntity;
import net.minecraft.entity.item.minecart.TNTMinecartEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.ProjectileEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.state.Property;
import net.minecraft.state.properties.DoubleBlockHalf;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.Explosion;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.living.LivingSpawnEvent;
import net.minecraftforge.event.entity.player.AttackEntityEvent;
import net.minecraftforge.event.entity.player.FillBucketEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.event.world.ExplosionEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class BannerEventHandlers {
    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void handleBannerBlockBreak(BlockEvent.BreakEvent event) {
        if (!event.getWorld().func_201670_d() && ExtendedBannerProtectionManager.isBannerProtected(event.getWorld(), event.getPos(), new ExtendedBannerProtectionManager.SingleProtectionInstance.PlayerProtection(event.getPlayer()), true, "handleBannerBlockBreak")) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void handleBannerBlucketFill(FillBucketEvent event) {
        BlockPos pos;
        World world = event.getWorld();
        if (!world.func_201670_d() && event.getTarget().func_216346_c() == RayTraceResult.Type.BLOCK && ExtendedBannerProtectionManager.isBannerProtected((IWorld)world, pos = ((BlockRayTraceResult)event.getTarget()).func_216350_a(), new ExtendedBannerProtectionManager.SingleProtectionInstance.PlayerProtection(event.getPlayer()), true, "handleBannerBlucketFill")) {
            event.setResult(Event.Result.DENY);
            BlockState state = world.func_180495_p(pos);
            world.func_184138_a(pos, state, state, 2);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void fallOnBlockEvent(BlockEvent.FarmlandTrampleEvent event) {
        if ((double)event.getFallDistance() < 0.5) {
            return;
        }
        if (!event.getWorld().func_201670_d() && ExtendedBannerProtectionManager.isBannerProtected(event.getWorld(), event.getPos(), new ExtendedBannerProtectionManager.SingleProtectionInstance.EntityProtection(event.getEntity()), true, "fallOnBlockEvent")) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void handleBannerEntitySpawn(LivingSpawnEvent.CheckSpawn event) {
        IWorld world = event.getWorld();
        LivingEntity entity = event.getEntityLiving();
        if (!world.func_201670_d() && entity instanceof MobEntity && ExtendedBannerProtectionManager.isBannerProtected(world, entity.func_233580_cy_(), new ExtendedBannerProtectionManager.SingleProtectionInstance.AnyProtection(), false, "handleBannerEntitySpawn")) {
            event.setResult(Event.Result.DENY);
            return;
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void handleBannerEntityInteract(PlayerInteractEvent.EntityInteractSpecific event) {
        World world = event.getWorld();
        Entity entity = event.getEntity();
        if (!world.func_201670_d() && entity instanceof HangingEntity && ExtendedBannerProtectionManager.isBannerProtected((IWorld)world, entity.func_233580_cy_(), new ExtendedBannerProtectionManager.SingleProtectionInstance.PlayerProtection(event.getPlayer()), true, "handleBannerEntityInteractHangingEntity")) {
            event.setCanceled(true);
            return;
        }
        if (!world.func_201670_d() && entity instanceof ArmorStandEntity && ExtendedBannerProtectionManager.isBannerProtected((IWorld)world, entity.func_233580_cy_(), new ExtendedBannerProtectionManager.SingleProtectionInstance.PlayerProtection(event.getPlayer(), BannerPermission.CONTAINERS), true, "handleBannerEntityInteractArmorStand")) {
            event.setCanceled(true);
            return;
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void handleBannerEntityAttacked(AttackEntityEvent event) {
        World level = event.getEntity().field_70170_p;
        Entity entity = event.getEntity();
        if (!level.func_201670_d() && entity instanceof HangingEntity && ExtendedBannerProtectionManager.isBannerProtected((IWorld)level, entity.func_233580_cy_(), new ExtendedBannerProtectionManager.SingleProtectionInstance.PlayerProtection(event.getPlayer()), true, "handleBannerEntityAttacked")) {
            event.setCanceled(true);
            return;
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void handleBannerBlockLeftInteract(PlayerInteractEvent.LeftClickBlock event) {
        World world = event.getWorld();
        if (!world.func_201670_d() && world.func_180495_p(event.getPos()).func_177230_c() instanceof FireBlock && ExtendedBannerProtectionManager.isBannerProtected((IWorld)world, event.getPos(), new ExtendedBannerProtectionManager.SingleProtectionInstance.PlayerProtection(event.getPlayer()), false, "handleBannerBlockLeftInteract")) {
            event.setCanceled(true);
            return;
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void handleBannerBlockRightInteract(PlayerInteractEvent.RightClickBlock event) {
        if (!event.getWorld().func_201670_d()) {
            World world = event.getWorld();
            BlockState bState = world.func_180495_p(event.getPos());
            Block block = bState.func_177230_c();
            BannerPermission perm = BannerPermission.EVERYTHING;
            if (!event.getPlayer().func_225608_bj_() || event.getPlayer().func_184586_b(event.getHand()).func_190926_b()) {
                if (block == Blocks.field_150342_X || block instanceof ExtendedBookshelfBlock || block instanceof LecternBlock) {
                    perm = BannerPermission.KNOWLEDGE;
                } else if (block instanceof DoorBlock || block instanceof TrapDoorBlock || block instanceof FenceGateBlock || block instanceof GateBlock) {
                    perm = BannerPermission.DOORS;
                } else if (block instanceof CraftingTableBlock || block instanceof FactionCraftingTableBlock || block instanceof AnvilBlock || block instanceof ExtendedConquestTableBlock) {
                    perm = BannerPermission.CRAFTING;
                } else if (world.func_175625_s(event.getPos()) instanceof IInventory) {
                    perm = block instanceof KegBlock || block instanceof CampfireBlock ? BannerPermission.EDITABLES : BannerPermission.CONTAINERS;
                } else if (block instanceof EnderChestBlock || block instanceof ExtendedWeaponRackBlock || block instanceof JukeboxBlock) {
                    perm = BannerPermission.CONTAINERS;
                } else if (block instanceof PlateBlock || block instanceof CakeBlock || block instanceof VesselDrinkBlock) {
                    perm = BannerPermission.EDITABLES;
                } else if (block instanceof BedBlock) {
                    perm = BannerPermission.BEDS;
                } else if (block instanceof AbstractButtonBlock || block instanceof LeverBlock || block instanceof DaylightDetectorBlock) {
                    perm = BannerPermission.FLICKABLES;
                } else if (block instanceof ExtendedMEBannerBlock) {
                    perm = BannerPermission.BANNER;
                }
            }
            if (ExtendedBannerProtectionManager.isBannerProtected((IWorld)world, event.getPos(), new ExtendedBannerProtectionManager.SingleProtectionInstance.PlayerProtection(event.getPlayer(), perm), true, "handleBannerBlockRightInteract")) {
                event.setCanceled(true);
                if (block instanceof DoorBlock) {
                    if (bState.func_177229_b((Property)DoorBlock.field_176523_O) == DoubleBlockHalf.UPPER) {
                        BlockState belowBlock = world.func_180495_p(event.getPos().func_177977_b());
                        if (belowBlock.func_235901_b_((Property)DoorBlock.field_176523_O) && belowBlock.func_235901_b_((Property)DoorBlock.field_176519_b)) {
                            world.func_175656_a(event.getPos().func_177977_b(), (BlockState)belowBlock.func_206870_a((Property)DoorBlock.field_176519_b, (Comparable)Boolean.valueOf((Boolean)bState.func_177229_b((Property)DoorBlock.field_176519_b) == false)));
                        }
                        world.func_175656_a(event.getPos(), bState);
                    } else {
                        BlockState aboveBlock = world.func_180495_p(event.getPos().func_177984_a());
                        if (aboveBlock.func_235901_b_((Property)DoorBlock.field_176523_O) && aboveBlock.func_235901_b_((Property)DoorBlock.field_176519_b)) {
                            world.func_175656_a(event.getPos().func_177984_a(), (BlockState)aboveBlock.func_206870_a((Property)DoorBlock.field_176519_b, (Comparable)Boolean.valueOf((Boolean)bState.func_177229_b((Property)DoorBlock.field_176519_b) == false)));
                        }
                        world.func_175656_a(event.getPos(), bState);
                    }
                }
                return;
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void handleBannerDetonateEvent(ExplosionEvent.Detonate event) {
        Explosion explosion = event.getExplosion();
        World world = event.getWorld();
        LivingEntity exploder = event.getExplosion().func_94613_c();
        if (!world.field_72995_K && exploder != null) {
            ExtendedBannerProtectionManager.SingleProtectionInstance protectionInstance = null;
            if (exploder instanceof NPCEntity || exploder instanceof MobEntity) {
                protectionInstance = new ExtendedBannerProtectionManager.SingleProtectionInstance.AnyProtection();
            } else if (exploder instanceof ProjectileEntity) {
                protectionInstance = new ExtendedBannerProtectionManager.SingleProtectionInstance.LaunchedProtection((ProjectileEntity)exploder);
            } else if (exploder instanceof TNTEntity) {
                LivingEntity owner;
                protectionInstance = ((TNTEntity)exploder).func_94083_c() != null ? ((owner = ((TNTEntity)exploder).func_94083_c()) instanceof NPCEntity || owner instanceof MobEntity ? new ExtendedBannerProtectionManager.SingleProtectionInstance.AnyProtection() : (owner instanceof PlayerEntity ? new ExtendedBannerProtectionManager.SingleProtectionInstance.PlayerProtection((PlayerEntity)owner) : new ExtendedBannerProtectionManager.SingleProtectionInstance.AnyProtection())) : new ExtendedBannerProtectionManager.SingleProtectionInstance.TNTProtection((TNTEntity)exploder);
            } else if (exploder instanceof TNTMinecartEntity) {
                protectionInstance = new ExtendedBannerProtectionManager.SingleProtectionInstance.AnyProtection();
            }
            if (protectionInstance != null) {
                BannerEventHandlers.saveBlocks(world, explosion.func_180343_e(), protectionInstance);
            }
        }
    }

    private static void saveBlocks(World world, List<BlockPos> blocksToBlow, ExtendedBannerProtectionManager.SingleProtectionInstance instance) {
        blocksToBlow.removeIf(pos -> ExtendedBannerProtectionManager.isBannerProtected((IWorld)world, pos, instance, true, "handleBannerDetonateEvent"));
    }
}

