/*
 * Decompiled with CFR 0.152.
 */
package com.github.maximuslotro.lotrrextended.common.eventhandlers;

import lotr.common.data.ExtendedLevelData;
import lotr.common.init.LOTRDimensions;
import net.minecraft.util.RegistryKey;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.LogicalSide;

public class ExtendedTickHandlerServer {
    public ExtendedTickHandlerServer() {
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent
    public void onWorldTick(TickEvent.WorldTickEvent event) {
        if (event.side == LogicalSide.SERVER) {
            ServerWorld world = (ServerWorld)event.world;
            TickEvent.Phase phase = event.phase;
            ExtendedLevelData levelData = ExtendedLevelData.serverInstance();
            if (phase == TickEvent.Phase.START && LOTRDimensions.isDimension((World)world, (RegistryKey)World.field_234918_g_) && levelData.needsLoad()) {
                levelData.load(world);
            }
            if (phase == TickEvent.Phase.END) {
                if (LOTRDimensions.isDimension((World)world, (RegistryKey)World.field_234918_g_)) {
                    if (levelData.doesNeedSaving()) {
                        levelData.save(world);
                    }
                    if (world.func_82737_E() % 600L == 0L) {
                        levelData.save(world);
                    }
                } else if (LOTRDimensions.isDimension((World)world, (RegistryKey)LOTRDimensions.MIDDLE_EARTH_WORLD_KEY)) {
                    if (world.func_82737_E() % 20L == 0L) {
                        levelData.decrementPlayerTraderCooldowns((World)world);
                        levelData.incrementPlayerTimeInBarrows((World)world);
                    }
                    levelData.checkForWanderingTraderSpawns((World)world);
                }
            }
        }
    }
}

