/*
 * Decompiled with CFR 0.152.
 */
package com.github.maximuslotro.lotrrextended.common.eventhandlers;

import com.github.maximuslotro.lotrrextended.common.entity.passive.ExtendedDuckEntity;
import com.github.maximuslotro.lotrrextended.common.inventory.ExtendedHiredUnitContainer;
import com.github.maximuslotro.lotrrextended.common.inventory.ExtendedHiredUnitEquipmentContainer;
import java.util.UUID;
import lotr.common.entity.npc.ExtendedHirableEntity;
import lotr.common.entity.npc.ExtendedHiredBreeGuard;
import lotr.common.entity.npc.NPCEntity;
import lotr.common.entity.npc.data.NPCEntitySettings;
import lotr.common.entity.npc.data.NPCEntitySettingsManager;
import lotr.common.util.ExtendedHiredUnitHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.passive.ChickenEntity;
import net.minecraft.entity.passive.CowEntity;
import net.minecraft.entity.passive.PigEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.player.PlayerContainerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class HiredUnitEventHandlers {
    @SubscribeEvent
    public static void playerCloseInventory(PlayerContainerEvent.Close event) {
        if (!(event.getContainer() instanceof ExtendedHiredUnitContainer) && !(event.getContainer() instanceof ExtendedHiredUnitEquipmentContainer)) {
            return;
        }
        Entity entity = event.getContainer() instanceof ExtendedHiredUnitContainer ? event.getPlayer().field_70170_p.func_73045_a(((ExtendedHiredUnitContainer)event.getContainer()).getEntityId()) : event.getPlayer().field_70170_p.func_73045_a(((ExtendedHiredUnitEquipmentContainer)event.getContainer()).getEntityId());
        if (event.getContainer() instanceof ExtendedHiredUnitContainer) {
            if (entity instanceof ExtendedHiredBreeGuard) {
                ((ExtendedHiredBreeGuard)entity).setInventoryOpen(false);
            }
        } else if (event.getContainer() instanceof ExtendedHiredUnitEquipmentContainer && entity instanceof ExtendedHiredBreeGuard) {
            ((ExtendedHiredBreeGuard)entity).setEquipmentOpen(false);
        }
    }

    @SubscribeEvent
    public static void giveExperience(LivingDeathEvent event) {
        Entity companion = event.getSource().func_76346_g();
        if (companion instanceof ExtendedHiredBreeGuard) {
            float xpPoints = 0.0f;
            if (event.getEntity() instanceof NPCEntity) {
                NPCEntitySettings settings = NPCEntitySettingsManager.getEntityTypeSettings((Entity)event.getEntity());
                xpPoints = settings != null && settings.getKillAlignmentBonus() > 0.0f ? (float)((int)settings.getKillAlignmentBonus()) : 1.0f;
            } else if (event.getEntity() instanceof PigEntity || event.getEntity() instanceof ChickenEntity || event.getEntity() instanceof CowEntity || event.getEntity() instanceof ExtendedDuckEntity) {
                xpPoints = 0.25f;
            }
            ((ExtendedHirableEntity)companion).giveExperiencePoints(xpPoints);
            ((ExtendedHirableEntity)companion).setMobKills(((ExtendedHirableEntity)companion).getMobKills() + 1);
        }
    }

    @SubscribeEvent
    public static void preventFriendlyFireFromPlayerToCompanion(LivingAttackEvent event) {
        ExtendedHirableEntity hired = ExtendedHiredUnitHelper.getExtendedHirableEntity(event.getEntity());
        if (hired == null) {
            return;
        }
        UUID owner = hired.getOwnerUUID();
        if (event.getSource() == null) {
            return;
        }
        if (event.getSource() != null && event.getSource().func_76346_g() != null && event.getSource().func_76346_g() instanceof PlayerEntity) {
            PlayerEntity player = (PlayerEntity)event.getSource().func_76346_g();
            if (owner == null) {
                return;
            }
            if (owner.equals(player.func_110124_au())) {
                event.setCanceled(true);
            }
        }
    }
}

