/*
 * Decompiled with CFR 0.152.
 */
package com.github.maximuslotro.lotrrextended.common.eventhandlers;

import com.github.maximuslotro.lotrrextended.common.advancements.ExtendedCriteriaTriggers;
import com.github.maximuslotro.lotrrextended.common.block.beds.ExtendedBedrollBlock;
import com.github.maximuslotro.lotrrextended.common.entity.special.ExtendedTraderRespawnEntity;
import java.util.List;
import lotr.common.entity.npc.ExtendedBarrowWightEntity;
import lotr.common.entity.npc.ExtendedCaptainEntity;
import lotr.common.entity.npc.ExtendedDunedainRangerEntity;
import lotr.common.entity.npc.ExtendedTraderEntity;
import lotr.common.entity.npc.NPCEntity;
import lotr.common.item.LOTRSpawnEggItem;
import lotr.common.util.ExtendedTraderHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.SpawnEggItem;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.Util;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.event.entity.EntityEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingSetAttackTargetEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.entity.player.PlayerSetSpawnEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class WorldEventHandlers {
    @SubscribeEvent
    public static void onEntityRightClick(PlayerInteractEvent.EntityInteract event) {
        if ((event.getPlayer().func_184586_b(event.getHand()).func_77973_b() instanceof SpawnEggItem || event.getPlayer().func_184586_b(event.getHand()).func_77973_b() instanceof LOTRSpawnEggItem) && event.getTarget() instanceof ExtendedTraderEntity) {
            ExtendedTraderEntity trader = (ExtendedTraderEntity)event.getTarget();
            ExtendedTraderHelper.openTraderGui((NPCEntity)event.getTarget(), event.getPlayer(), trader);
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void preventCloakedRangersFromBeingTargeted(LivingSetAttackTargetEvent event) {
        ExtendedDunedainRangerEntity ranger;
        if (event.getTarget() instanceof ExtendedDunedainRangerEntity && (ranger = (ExtendedDunedainRangerEntity)event.getTarget()).isCloaked() && event.getEntityLiving() instanceof NPCEntity) {
            NPCEntity npc = (NPCEntity)event.getEntityLiving();
            npc.func_70624_b(null);
        }
    }

    @SubscribeEvent
    public static void handleBedRollCancelSpawn(PlayerSetSpawnEvent event) {
        if (event.isForced() || event.getNewSpawn() == null) {
            return;
        }
        if (event.getPlayer().field_70170_p.func_180495_p(event.getNewSpawn()) != null && event.getPlayer().field_70170_p.func_180495_p(event.getNewSpawn()).func_177230_c() instanceof ExtendedBedrollBlock) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void handleBlockBreakAdvancement(BlockEvent.BreakEvent event) {
        if (event.getPlayer() instanceof ServerPlayerEntity) {
            ServerPlayerEntity player = (ServerPlayerEntity)event.getPlayer();
            ExtendedCriteriaTriggers.PLAYER_BREAK_BLOCK_TRIGGER.trigger(player, event.getPos(), player.func_184586_b(player.func_184600_cs()));
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void handleCaptainTraderDeath(LivingDeathEvent event) {
        if (!(event.getEntity() instanceof ExtendedTraderEntity) && !(event.getEntity() instanceof ExtendedCaptainEntity)) {
            return;
        }
        if (event.getEntity() instanceof ExtendedTraderEntity && ((ExtendedTraderEntity)event.getEntity()).isWanderingTrader()) {
            ExtendedTraderEntity trader = (ExtendedTraderEntity)event.getEntity();
            if (trader.getEscortUUIDs() == null || trader.getEscortUUIDs().isEmpty()) {
                return;
            }
            AxisAlignedBB initial = new AxisAlignedBB(event.getEntity().func_226277_ct_(), event.getEntity().func_226278_cu_(), event.getEntity().func_226281_cx_(), event.getEntity().func_226277_ct_() + 1.0, event.getEntity().func_226278_cu_() + 1.0, event.getEntity().func_226281_cx_() + 1.0);
            List potentialEscorts = event.getEntity().field_70170_p.func_217357_a(NPCEntity.class, initial.func_186662_g(256.0));
            for (NPCEntity entity : potentialEscorts) {
                if (!trader.getEscortUUIDs().contains(entity.func_110124_au())) continue;
                entity.func_70106_y();
            }
            for (PlayerEntity player : event.getEntity().field_70170_p.func_217369_A()) {
                ITextComponent text = event.getSource().func_151519_b(event.getEntityLiving());
                player.func_145747_a(text, Util.field_240973_b_);
            }
        } else {
            NPCEntity npc = (NPCEntity)event.getEntity();
            ExtendedTraderRespawnEntity respawnerEntity = new ExtendedTraderRespawnEntity(npc.field_70170_p);
            respawnerEntity.func_225653_b_(npc.func_226277_ct_(), npc.func_226278_cu_() + (double)(npc.func_213302_cg() / 2.0f), npc.func_226281_cx_());
            respawnerEntity.setEntityType(npc.func_200600_R());
            CompoundNBT compound = new CompoundNBT();
            if (event.getEntity() instanceof ExtendedTraderEntity) {
                ((ExtendedTraderEntity)event.getEntity()).saveAllTrades(compound);
            }
            if (event.getEntity() instanceof ExtendedCaptainEntity) {
                // empty if block
            }
            respawnerEntity.setEntityData(compound);
            if (npc.func_213394_dL()) {
                respawnerEntity.setHomeInfo(npc.func_213384_dI(), (int)npc.func_213391_dJ());
            }
            npc.field_70170_p.func_217376_c((Entity)respawnerEntity);
        }
    }

    @SubscribeEvent
    public static void handleWightSizeChange(EntityEvent.Size event) {
        if (event.getEntity() != null && event.getEntity().field_70170_p != null && event.getEntity().field_70170_p.func_201670_d() && event.getEntity() instanceof ExtendedBarrowWightEntity) {
            event.setNewSize(EntitySize.func_220314_b((float)0.8f, (float)2.4f));
        }
    }
}

