/*
 * Decompiled with CFR 0.152.
 */
package com.github.maximuslotro.lotrrextended.common.init;

import com.github.maximuslotro.lotrrextended.common.datagen.DataGenValueHolder;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.DatagenModLoader;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;

public class ExtendedSounds {
    public static final DeferredRegister<SoundEvent> SOUNDS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.SOUND_EVENTS, (String)"lotrextended");
    public static final RegistryObject<SoundEvent> HORN_BLOW = ExtendedSounds.register("item.horn_blow", "Horn Blows");
    public static final RegistryObject<SoundEvent> TRADE = ExtendedSounds.register("event.trade", "Coins Jingle");
    public static final RegistryObject<SoundEvent> DUCK_DEATH = ExtendedSounds.register("entity.duck.death", "Duck Dies");
    public static final RegistryObject<SoundEvent> DUCK_HURT = ExtendedSounds.register("entity.duck.hurt", "Duck Hurts");
    public static final RegistryObject<SoundEvent> DUCK_AMBIANT = ExtendedSounds.register("entity.duck.idle", "Duck Quacks");
    public static final RegistryObject<SoundEvent> DUCK_STEP = ExtendedSounds.register("entity.duck.step", "Footsteps");
    public static final RegistryObject<SoundEvent> DUCK_EGG = ExtendedSounds.register("entity.duck.egg", "Duck Egg Plops");
    public static final RegistryObject<SoundEvent> BASKET_OPEN = ExtendedSounds.register("block.reed_basket.open", "Reed Basket Opens");
    public static final RegistryObject<SoundEvent> BASKET_CLOSE = ExtendedSounds.register("block.reed_basket.close", "Reed Basket Closes");
    public static final RegistryObject<SoundEvent> STONE_CHEST_OPEN = ExtendedSounds.register("block.stone_chest.open", "Stone Chest Opens");
    public static final RegistryObject<SoundEvent> STONE_CHEST_CLOSE = ExtendedSounds.register("block.stone_chest.close", "Stone Chest Closes");
    public static final RegistryObject<SoundEvent> MILLSTONE_GRINDING = ExtendedSounds.register("block.stone_grinder.grinding", "Stone Grinder Grinds");
    public static final RegistryObject<SoundEvent> CHEESE_SLICE = ExtendedSounds.register("block.cheese_wheel.slice", "Cheese Wheel Sliced");
    public static final RegistryObject<SoundEvent> CONQUEST_TABLE_OPEN = ExtendedSounds.register("block.conquest_table.open", null);
    public static final RegistryObject<SoundEvent> MOSS_BROKEN = ExtendedSounds.register("block.moss.break", null);
    public static final RegistryObject<SoundEvent> MOSS_PLACED = ExtendedSounds.register("block.moss.place", null);
    public static final RegistryObject<SoundEvent> MOSS_HIT = ExtendedSounds.register("block.moss.hit", null);
    public static final RegistryObject<SoundEvent> MOSS_FALL = ExtendedSounds.register("block.moss.fall", null);
    public static final RegistryObject<SoundEvent> MOSS_STEP = ExtendedSounds.register("block.moss.step", null);
    public static final RegistryObject<SoundEvent> WIGHT_AMBIENCE = ExtendedSounds.register("entity.wight.ambience", "Creepy Noises");
    public static final RegistryObject<SoundEvent> WIGHT_SPAWN = ExtendedSounds.register("entity.wight.spawn", "Wight Spawns");
    public static final RegistryObject<SoundEvent> WIGHT_DEATH = ExtendedSounds.register("entity.wight.death", "Wight Death");
    public static final RegistryObject<SoundEvent> ROPE_BROKEN = ExtendedSounds.register("block.rope.break", null);
    public static final RegistryObject<SoundEvent> ROPE_PLACED = ExtendedSounds.register("block.rope.place", null);
    public static final RegistryObject<SoundEvent> ROPE_STEP = ExtendedSounds.register("block.rope.step", null);

    public static RegistryObject<SoundEvent> register(String name, String defaultName) {
        if (DatagenModLoader.isRunningDataGen() && defaultName != null) {
            DataGenValueHolder.soundEventHolder.put("subtitles.lotrextended." + name, defaultName);
        }
        return SOUNDS.register(name, () -> new SoundEvent(new ResourceLocation("lotrextended", name)));
    }

    public static void register(IEventBus bus) {
        SOUNDS.register(bus);
    }
}

