/*
 * Decompiled with CFR 0.152.
 */
package com.github.maximuslotro.lotrrextended.common.item;

import com.github.maximuslotro.lotrrextended.common.enums.ExtendedBowMaterial;
import java.util.List;
import javax.annotation.Nullable;
import lotr.common.init.LOTRItemGroups;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.AbstractArrowEntity;
import net.minecraft.item.ArrowItem;
import net.minecraft.item.BowItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.stats.Stats;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeEventFactory;

public class ExtendedBowItem
extends BowItem {
    private final ExtendedBowMaterial bowMaterial;

    public ExtendedBowItem(ExtendedBowMaterial material) {
        super(new Item.Properties().func_200916_a(LOTRItemGroups.COMBAT).func_200918_c(material.getDurability()));
        this.bowMaterial = material;
    }

    public void func_77624_a(ItemStack stack, @Nullable World world, List<ITextComponent> tooltip, ITooltipFlag flag) {
        super.func_77624_a(stack, world, tooltip, flag);
        tooltip.add((ITextComponent)new StringTextComponent(""));
        tooltip.add((ITextComponent)new TranslationTextComponent("gui.lotrextended.bow.speed", new Object[]{(int)(1.0f / ((float)this.bowMaterial.getDrawSpeedTicks() / 20.0f) * 100.0f) + "%"}).func_240699_a_(TextFormatting.DARK_GREEN));
        tooltip.add((ITextComponent)new TranslationTextComponent("gui.lotrextended.bow.damage", new Object[]{String.format("%.0f%%", Float.valueOf(this.bowMaterial.getAttackDamageBonusScale() * 100.0f))}).func_240699_a_(TextFormatting.DARK_GREEN));
        tooltip.add((ITextComponent)new TranslationTextComponent("gui.lotrextended.bow.range", new Object[]{String.format("%.0f%%", Float.valueOf(this.bowMaterial.getAttackDamageBonusScale() * 100.0f))}).func_240699_a_(TextFormatting.DARK_GREEN));
    }

    public void func_77615_a(ItemStack bow, World p_77615_2_, LivingEntity p_77615_3_, int p_77615_4_) {
        if (p_77615_3_ instanceof PlayerEntity) {
            PlayerEntity playerentity = (PlayerEntity)p_77615_3_;
            boolean flag = playerentity.field_71075_bZ.field_75098_d || EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185312_x, (ItemStack)bow) > 0;
            ItemStack itemstack = playerentity.func_213356_f(bow);
            int i = this.func_77626_a(bow) - p_77615_4_;
            if ((i = ForgeEventFactory.onArrowLoose((ItemStack)bow, (World)p_77615_2_, (PlayerEntity)playerentity, (int)i, (!itemstack.func_190926_b() || flag ? 1 : 0) != 0)) < 0) {
                return;
            }
            if (!itemstack.func_190926_b() || flag) {
                if (itemstack.func_190926_b()) {
                    itemstack = new ItemStack((IItemProvider)Items.field_151032_g);
                }
                float charge = (float)i / (float)this.bowMaterial.getDrawSpeedTicks();
                if ((charge = (charge * charge + charge * 2.0f) / 3.0f) > 1.0f) {
                    charge = 1.0f;
                }
                if ((double)charge >= 0.1) {
                    boolean flag1;
                    boolean bl = flag1 = playerentity.field_71075_bZ.field_75098_d || itemstack.func_77973_b() instanceof ArrowItem && ((ArrowItem)itemstack.func_77973_b()).isInfinite(itemstack, bow, playerentity);
                    if (!p_77615_2_.field_72995_K) {
                        int k;
                        int j;
                        ArrowItem arrowitem = (ArrowItem)(itemstack.func_77973_b() instanceof ArrowItem ? itemstack.func_77973_b() : Items.field_151032_g);
                        AbstractArrowEntity abstractarrowentity = arrowitem.func_200887_a(p_77615_2_, itemstack, (LivingEntity)playerentity);
                        abstractarrowentity = this.customArrow(abstractarrowentity);
                        abstractarrowentity.func_234612_a_((Entity)playerentity, playerentity.field_70125_A, playerentity.field_70177_z, 0.0f, charge * 3.0f * ExtendedBowItem.getLaunchSpeedFactor(bow), 1.0f);
                        if (charge == 1.0f) {
                            abstractarrowentity.func_70243_d(true);
                        }
                        if ((j = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185309_u, (ItemStack)bow)) > 0) {
                            abstractarrowentity.func_70239_b(abstractarrowentity.func_70242_d() + (double)j * 0.5 + 0.5);
                        }
                        if ((k = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185310_v, (ItemStack)bow)) > 0) {
                            abstractarrowentity.func_70240_a(k);
                        }
                        if (EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185311_w, (ItemStack)bow) > 0) {
                            abstractarrowentity.func_70015_d(100);
                        }
                        bow.func_222118_a(1, (LivingEntity)playerentity, p_220009_1_ -> p_220009_1_.func_213334_d(playerentity.func_184600_cs()));
                        if (flag1 || playerentity.field_71075_bZ.field_75098_d && (itemstack.func_77973_b() == Items.field_185166_h || itemstack.func_77973_b() == Items.field_185167_i)) {
                            abstractarrowentity.field_70251_a = AbstractArrowEntity.PickupStatus.CREATIVE_ONLY;
                        }
                        p_77615_2_.func_217376_c((Entity)abstractarrowentity);
                    }
                    p_77615_2_.func_184148_a(null, playerentity.func_226277_ct_(), playerentity.func_226278_cu_(), playerentity.func_226281_cx_(), SoundEvents.field_187737_v, SoundCategory.PLAYERS, 1.0f, 1.0f / (field_77697_d.nextFloat() * 0.4f + 1.2f) + charge * 0.5f);
                    if (!flag1 && !playerentity.field_71075_bZ.field_75098_d) {
                        itemstack.func_190918_g(1);
                        if (itemstack.func_190926_b()) {
                            playerentity.field_71071_by.func_184437_d(itemstack);
                        }
                    }
                    playerentity.func_71029_a(Stats.field_75929_E.func_199076_b((Object)this));
                }
            }
        }
    }

    public static float getLaunchSpeedFactor(ItemStack itemstack) {
        float f = 1.0f;
        if (itemstack != null && itemstack.func_77973_b() instanceof ExtendedBowItem) {
            f *= ((ExtendedBowItem)itemstack.func_77973_b()).getMaterial().getAttackDamageBonusScale();
        }
        return f;
    }

    public int func_230305_d_() {
        return 15;
    }

    public int func_77619_b() {
        return this.bowMaterial.getEnchantabilityValue();
    }

    public boolean func_82789_a(ItemStack pToRepair, ItemStack pRepair) {
        return this.bowMaterial.getRepairIngredient().test(pRepair) || super.func_82789_a(pToRepair, pRepair);
    }

    public ExtendedBowMaterial getMaterial() {
        return this.bowMaterial;
    }
}

