/*
 * Decompiled with CFR 0.152.
 */
package com.github.maximuslotro.lotrrextended.common.loot;

import com.github.maximuslotro.lotrrextended.ExtendedLog;
import net.minecraft.item.Item;
import net.minecraft.loot.ConstantRange;
import net.minecraft.loot.IRandomRange;
import net.minecraft.loot.ItemLootEntry;
import net.minecraft.loot.LootEntry;
import net.minecraft.loot.RandomValueRange;
import net.minecraft.loot.StandaloneLootEntry;
import net.minecraft.loot.conditions.ILootCondition;
import net.minecraft.loot.functions.ILootFunction;
import net.minecraft.loot.functions.SetCount;
import net.minecraft.loot.functions.SetDamage;
import net.minecraft.util.IItemProvider;

public class EItemLootEntry
extends ItemLootEntry {
    public EItemLootEntry(Item pItem, int pWeight, int pQuality, ILootCondition[] pConditions, ILootFunction[] pFunctions) {
        super(pItem, pWeight, pQuality, pConditions, pFunctions);
    }

    public static StandaloneLootEntry.Builder<ExtendedBuilder> lootItem(IItemProvider pItem) {
        return new ExtendedBuilder((p_216169_1_, p_216169_2_, p_216169_3_, p_216169_4_) -> new EItemLootEntry(pItem.func_199767_j(), p_216169_1_, p_216169_2_, p_216169_3_, p_216169_4_), pItem.func_199767_j().func_77645_m());
    }

    public static class ExtendedBuilder
    extends StandaloneLootEntry.Builder<ExtendedBuilder> {
        private final StandaloneLootEntry.ILootEntryBuilder constructor;
        private final boolean isDamagable;

        public ExtendedBuilder(StandaloneLootEntry.ILootEntryBuilder lootEntryConstructor, boolean canDamage) {
            this.constructor = lootEntryConstructor;
            this.isDamagable = canDamage;
        }

        protected ExtendedBuilder getThis() {
            return this;
        }

        public LootEntry func_216081_b() {
            return this.constructor.build(this.field_216087_a, this.field_216088_b, this.func_216079_f(), this.func_216084_a());
        }

        public ExtendedBuilder setDamageRange(float minDamagePercent, float maxDamagePercent) {
            float modifiedMin = (float)(100 - (int)(maxDamagePercent * 100.0f)) / 100.0f;
            float modifiedMax = (float)(100 - (int)(minDamagePercent * 100.0f)) / 100.0f;
            if (!this.isDamagable) {
                ExtendedLog.error("Tried Setting damage value range to a non-damageable item! " + modifiedMin + ":" + modifiedMax);
                return this.getThis();
            }
            if (modifiedMin > modifiedMax) {
                ExtendedLog.error("Tried Setting an inverted damage value range to an item! " + modifiedMin + ":" + modifiedMax);
                return this.getThis();
            }
            this.func_212841_b_((ILootFunction.IBuilder)SetDamage.func_215931_a((RandomValueRange)RandomValueRange.func_215837_a((float)modifiedMin, (float)modifiedMax)));
            return this.getThis();
        }

        public ExtendedBuilder setExactly(int number) {
            this.func_212841_b_((ILootFunction.IBuilder)SetCount.func_215932_a((IRandomRange)ConstantRange.func_215835_a((int)number)));
            return this.getThis();
        }

        public ExtendedBuilder setRange(int min, int max) {
            if (min >= max) {
                ExtendedLog.error("Tried Setting an incorrect item count rage! " + min + ">=" + max);
                return this.getThis();
            }
            this.func_212841_b_((ILootFunction.IBuilder)SetCount.func_215932_a((IRandomRange)RandomValueRange.func_215837_a((float)min, (float)max)));
            return this.getThis();
        }
    }
}

