/*
 * Decompiled with CFR 0.152.
 */
package com.github.maximuslotro.lotrrextended.common.loot.modifiers;

import com.github.maximuslotro.lotrrextended.ExtendedLog;
import com.github.maximuslotro.lotrrextended.common.config.ExtendedServerConfig;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import lotr.common.init.LOTRDimensions;
import net.minecraft.entity.Entity;
import net.minecraft.entity.projectile.FishingBobberEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.loot.LootContext;
import net.minecraft.loot.LootParameters;
import net.minecraft.loot.conditions.ILootCondition;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.loot.GlobalLootModifierSerializer;
import net.minecraftforge.common.loot.LootModifier;

public class EnchantmentedInMEDisabler
extends LootModifier {
    List<ResourceLocation> fishingRods;

    public EnchantmentedInMEDisabler(ILootCondition[] conds, List<ResourceLocation> fishingRods) {
        super(conds);
        this.fishingRods = fishingRods;
    }

    public List<ItemStack> doApply(List<ItemStack> generatedLoot, LootContext context) {
        ServerWorld world = context.func_202879_g();
        if (LOTRDimensions.isModDimension((World)world)) {
            if (!((Boolean)ExtendedServerConfig.enableEnchantedLootDrops.get()).booleanValue()) {
                Vector3d location = (Vector3d)context.func_216031_c(LootParameters.field_237457_g_);
                if (location == null) {
                    location = new Vector3d(0.0, 0.0, 0.0);
                }
                if (generatedLoot.removeIf(item -> item.func_77973_b() == Items.field_151134_bR)) {
                    ExtendedLog.info("Removed Enchanted Book from loot in %s at %s ", context.func_202879_g().func_234923_W_().func_240901_a_(), location.toString());
                }
                if (generatedLoot.removeIf(item -> item.func_77948_v())) {
                    ExtendedLog.info("Removed Enchanted Item from loot in %s at %s ", context.func_202879_g().func_234923_W_().func_240901_a_(), location.toString());
                }
                return generatedLoot;
            }
            if (!((Boolean)ExtendedServerConfig.enableFishingEnchantedItems.get()).booleanValue()) {
                ItemStack tool = (ItemStack)context.func_216031_c(LootParameters.field_216289_i);
                Vector3d location = (Vector3d)context.func_216031_c(LootParameters.field_237457_g_);
                Entity entity = (Entity)context.func_216031_c(LootParameters.field_216281_a);
                if (tool != null && this.fishingRods.contains(tool.func_77973_b().getRegistryName()) || entity != null && entity instanceof FishingBobberEntity) {
                    if (location == null) {
                        location = new Vector3d(0.0, 0.0, 0.0);
                    }
                    if (generatedLoot.removeIf(item -> item.func_77973_b() == Items.field_151134_bR)) {
                        ExtendedLog.info("Removed Enchanted Book from fishing loot in %s at %s ", context.func_202879_g().func_234923_W_().func_240901_a_(), location.toString());
                    }
                    if (generatedLoot.removeIf(item -> item.func_77948_v())) {
                        ExtendedLog.info("Removed Enchanted Item from fishing loot in %s at %s ", context.func_202879_g().func_234923_W_().func_240901_a_(), location.toString());
                    }
                }
            }
        }
        return generatedLoot;
    }

    public static class Serializer
    extends GlobalLootModifierSerializer<EnchantmentedInMEDisabler> {
        public EnchantmentedInMEDisabler read(ResourceLocation name, JsonObject jObject, ILootCondition[] conditions) {
            ArrayList<ResourceLocation> fishingRods = new ArrayList<ResourceLocation>();
            JsonArray rodArray = jObject.get("fishing_rods_affected").getAsJsonArray();
            for (JsonElement rod : rodArray) {
                fishingRods.add(new ResourceLocation(rod.getAsString()));
            }
            return new EnchantmentedInMEDisabler(conditions, fishingRods);
        }

        public JsonObject write(EnchantmentedInMEDisabler instance) {
            JsonObject jObject = this.makeConditions(instance.conditions);
            JsonArray list = new JsonArray();
            for (ResourceLocation fishingRodResourceLocation : instance.fishingRods) {
                list.add(fishingRodResourceLocation.toString());
            }
            jObject.add("fishing_rods_affected", (JsonElement)list);
            return jObject;
        }
    }
}

