/*
 * Decompiled with CFR 0.152.
 */
package com.github.maximuslotro.lotrrextended.common.network;

import com.github.maximuslotro.lotrrextended.common.bannerprotection.ExtendedBannerProtectionManager;
import com.github.maximuslotro.lotrrextended.common.bannerprotection.whitelist.ExtendedBannerProfileBase;
import com.github.maximuslotro.lotrrextended.common.bannerprotection.whitelist.ExtendedBannerProfileFellowship;
import com.github.maximuslotro.lotrrextended.common.bannerprotection.whitelist.ExtendedBannerProfilePlayer;
import com.github.maximuslotro.lotrrextended.common.config.ExtendedServerConfig;
import com.github.maximuslotro.lotrrextended.common.enums.BannerPermission;
import com.github.maximuslotro.lotrrextended.common.enums.BannerProtectionType;
import com.github.maximuslotro.lotrrextended.common.network.ExtendedPacketHandler;
import com.github.maximuslotro.lotrrextended.common.network.ExtendedSBannerOpenChangedScreenPacket;
import com.github.maximuslotro.lotrrextended.common.tileentity.ExtendedMEBannerTileEntity;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.minecraftforge.fml.network.NetworkEvent;

public class ExtendedCBannerSaveInfoPacket {
    public List<BannerPermission> defaultPerms;
    public float alignmentLevel;
    public List<ExtendedMEBannerTileEntity.ProtectionEntry> whitelist;
    public boolean canSelfProtect;
    public int protectionType;
    private BlockPos configurePos;

    public ExtendedCBannerSaveInfoPacket() {
    }

    public ExtendedCBannerSaveInfoPacket(List<BannerPermission> defaultPerms, float alignmentLevel, List<ExtendedMEBannerTileEntity.ProtectionEntry> whitelist, boolean canSelfProtect, int protectionType, BlockPos configurePos) {
        this.defaultPerms = defaultPerms;
        this.alignmentLevel = alignmentLevel;
        this.whitelist = whitelist;
        this.canSelfProtect = canSelfProtect;
        this.configurePos = configurePos;
        this.protectionType = protectionType;
    }

    public static void encode(ExtendedCBannerSaveInfoPacket packet, PacketBuffer buf) {
        buf.writeInt(packet.defaultPerms.size());
        for (BannerPermission perm : packet.defaultPerms) {
            buf.writeByte((int)((byte)perm.ordinal()));
        }
        buf.writeFloat(packet.alignmentLevel);
        buf.writeInt(packet.whitelist.size());
        for (ExtendedMEBannerTileEntity.ProtectionEntry entry : packet.whitelist) {
            buf.writeInt(entry.getEntryPerms().size());
            for (BannerPermission perm : entry.getEntryPerms()) {
                buf.writeByte((int)((byte)perm.ordinal()));
            }
            buf.func_179252_a(entry.getProfile().getId());
            buf.func_211400_a(entry.getProfile().getDisplayName(), Short.MAX_VALUE);
        }
        buf.writeBoolean(packet.canSelfProtect);
        buf.writeInt(packet.protectionType);
        buf.func_179255_a(packet.configurePos);
    }

    public static ExtendedCBannerSaveInfoPacket decode(PacketBuffer buf) {
        ExtendedCBannerSaveInfoPacket packet = new ExtendedCBannerSaveInfoPacket();
        int defaultPermsSize = buf.readInt();
        packet.defaultPerms = new ArrayList<BannerPermission>();
        for (int i = 0; i < defaultPermsSize; ++i) {
            packet.defaultPerms.add(BannerPermission.values[buf.readByte()]);
        }
        packet.alignmentLevel = buf.readFloat();
        packet.whitelist = new ArrayList<ExtendedMEBannerTileEntity.ProtectionEntry>();
        int whitelistSize = buf.readInt();
        for (int i = 0; i < whitelistSize; ++i) {
            int permListSize = buf.readInt();
            ArrayList<BannerPermission> profilePerms = new ArrayList<BannerPermission>();
            for (int j = 0; j < permListSize; ++j) {
                profilePerms.add(BannerPermission.values[buf.readByte()]);
            }
            UUID id = buf.func_179253_g();
            String name = buf.func_150789_c(Short.MAX_VALUE);
            ExtendedBannerProfileBase type = name.startsWith("f/") ? new ExtendedBannerProfileFellowship(name.substring(2), id) : new ExtendedBannerProfilePlayer(id, name);
            ExtendedMEBannerTileEntity.ProtectionEntry entry = new ExtendedMEBannerTileEntity.ProtectionEntry(type);
            entry.setPerms(profilePerms);
            packet.whitelist.add(entry);
        }
        packet.canSelfProtect = buf.readBoolean();
        packet.protectionType = buf.readInt();
        packet.configurePos = buf.func_179259_c();
        return packet;
    }

    public static void handle(ExtendedCBannerSaveInfoPacket pPacket, Supplier<NetworkEvent.Context> context) {
        ServerPlayerEntity player = context.get().getSender();
        TileEntity tileEntity = player.field_70170_p.func_175625_s(pPacket.configurePos);
        if (tileEntity instanceof ExtendedMEBannerTileEntity && ((Boolean)ExtendedServerConfig.enableBannerProtection.get()).booleanValue()) {
            ExtendedMEBannerTileEntity bannerTE = (ExtendedMEBannerTileEntity)tileEntity;
            if (!ExtendedBannerProtectionManager.isBannerProtected((IWorld)player.field_70170_p, pPacket.configurePos, new ExtendedBannerProtectionManager.SingleProtectionInstance.PlayerProtection((PlayerEntity)player, BannerPermission.BANNER), true, "ExtendedCBannerSaveInfoPacket")) {
                bannerTE.setDefaultPerms(pPacket.defaultPerms);
                bannerTE.setAlignmentLevel(pPacket.alignmentLevel);
                bannerTE.setProtectionWhitelist(pPacket.whitelist);
                bannerTE.setCanProtectSelf(pPacket.canSelfProtect);
                bannerTE.setProtectionType(BannerProtectionType.getByID(pPacket.protectionType));
                ExtendedSBannerOpenChangedScreenPacket returnPacket = bannerTE.verifyInfo(true, player);
                if (returnPacket != null) {
                    ExtendedPacketHandler.sendToClient(returnPacket, player);
                }
            }
        }
        context.get().setPacketHandled(true);
    }
}

