/*
 * Decompiled with CFR 0.152.
 */
package com.github.maximuslotro.lotrrextended.common.network;

import com.github.maximuslotro.lotrrextended.ExtendedLog;
import com.github.maximuslotro.lotrrextended.common.advancements.ExtendedCriteriaTriggers;
import java.util.Objects;
import java.util.function.Supplier;
import lotr.common.entity.npc.ExtendedCaptainEntity;
import lotr.common.entity.npc.ExtendedHiredBreeGuard;
import lotr.common.init.ExtendedEntities;
import lotr.common.util.CoinUtils;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.fml.network.NetworkEvent;

public class ExtendedCPacketHireUnit {
    private int captainId;

    public ExtendedCPacketHireUnit() {
    }

    public ExtendedCPacketHireUnit(int captainId) {
        this.captainId = captainId;
    }

    public static void encode(ExtendedCPacketHireUnit packet, PacketBuffer buf) {
        buf.writeInt(packet.captainId);
    }

    public static ExtendedCPacketHireUnit decode(PacketBuffer buf) {
        ExtendedCPacketHireUnit packet = new ExtendedCPacketHireUnit();
        packet.captainId = buf.readInt();
        return packet;
    }

    public static void handle(ExtendedCPacketHireUnit packet, Supplier<NetworkEvent.Context> context) {
        Entity entity = Objects.requireNonNull(context.get().getSender()).field_70170_p.func_73045_a(packet.captainId);
        if (!(entity instanceof ExtendedCaptainEntity)) {
            ExtendedLog.error("Received a captain entity not of type ExtendedCaptainEntity from %s", Objects.requireNonNull(context.get().getSender()).func_200200_C_().getString());
            context.get().setPacketHandled(true);
            return;
        }
        ExtendedCaptainEntity captain = (ExtendedCaptainEntity)entity;
        ServerPlayerEntity player = Objects.requireNonNull(context.get().getSender());
        if (!captain.canHire((PlayerEntity)player)) {
            player.func_145747_a((ITextComponent)new TranslationTextComponent("gui.lotrextended.hiring.captain_alignment_too_low"), Util.field_240973_b_);
            context.get().setPacketHandled(true);
            return;
        }
        int cost = captain.getCost("BREE_GUARD", (PlayerEntity)player);
        if (CoinUtils.totalValueInInventory((IInventory)player.field_71071_by) < cost) {
            player.func_145747_a((ITextComponent)new TranslationTextComponent("gui.lotrextended.hiring.not_enough_money", new Object[]{cost}), Util.field_240973_b_);
            context.get().setPacketHandled(true);
            return;
        }
        ExtendedHiredBreeGuard newEntity = (ExtendedHiredBreeGuard)((EntityType)ExtendedEntities.HIRED_BREE_GUARD.get()).func_220331_a((ServerWorld)entity.field_70170_p, null, (PlayerEntity)player, new BlockPos(entity.func_226277_ct_(), entity.func_226278_cu_(), entity.func_226281_cx_()), SpawnReason.NATURAL, false, false);
        if (newEntity != null) {
            newEntity.tame((PlayerEntity)player);
            CoinUtils.removeCoins((PlayerEntity)player, player.field_71071_by, cost);
            player.func_145747_a((ITextComponent)new TranslationTextComponent("gui.lotrextended.hiring.unit_has_been_hired", new Object[]{"Bree-land Guard", cost}), Util.field_240973_b_);
            ExtendedCriteriaTriggers.UNIT_HIRED_TRIGGER.trigger(player, entity.func_200600_R(), newEntity.func_200600_R(), cost);
        }
        context.get().setPacketHandled(true);
    }
}

