/*
 * Decompiled with CFR 0.152.
 */
package com.github.maximuslotro.lotrrextended.common.network;

import com.github.maximuslotro.lotrrextended.ExtendedLog;
import io.netty.buffer.Unpooled;
import java.util.Objects;
import java.util.function.Supplier;
import lotr.common.entity.npc.ExtendedTraderEntity;
import lotr.common.init.ExtendedContainers;
import lotr.common.inventory.ExtendedCoinExchangeContainer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.inventory.container.SimpleNamedContainerProvider;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.Util;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.fml.network.NetworkEvent;
import net.minecraftforge.fml.network.NetworkHooks;

public class ExtendedCPacketOpenCoinExchange {
    private int traderId;

    public ExtendedCPacketOpenCoinExchange() {
    }

    public ExtendedCPacketOpenCoinExchange(int traderId) {
        this.traderId = traderId;
    }

    public static void encode(ExtendedCPacketOpenCoinExchange packet, PacketBuffer buf) {
        buf.writeInt(packet.traderId);
    }

    public static ExtendedCPacketOpenCoinExchange decode(PacketBuffer buf) {
        ExtendedCPacketOpenCoinExchange packet = new ExtendedCPacketOpenCoinExchange();
        packet.traderId = buf.readInt();
        return packet;
    }

    public static void handle(ExtendedCPacketOpenCoinExchange packet, Supplier<NetworkEvent.Context> context) {
        Entity entity = Objects.requireNonNull(context.get().getSender()).field_70170_p.func_73045_a(packet.traderId);
        if (!(entity instanceof ExtendedTraderEntity)) {
            ExtendedLog.error("Recieved a trader eneity not of type ExtendedTraderEntity from %s", context.get().getSender().func_200200_C_().getString());
            context.get().setPacketHandled(true);
            return;
        }
        ExtendedTraderEntity trader = (ExtendedTraderEntity)entity;
        if (!trader.canTradeWith((PlayerEntity)context.get().getSender())) {
            context.get().getSender().func_145747_a((ITextComponent)new TranslationTextComponent("gui.lotrextended.trading.trader_alignment_too_low"), Util.field_240973_b_);
            context.get().setPacketHandled(true);
            return;
        }
        ContainerType containerType = (ContainerType)ExtendedContainers.COIN_TRADING.get();
        PacketBuffer initData = new PacketBuffer(Unpooled.buffer());
        ExtendedCoinExchangeContainer.writeContainerInitData(initData, packet.traderId);
        NetworkHooks.openGui((ServerPlayerEntity)context.get().getSender(), (INamedContainerProvider)new SimpleNamedContainerProvider((i, inv, p) -> (ExtendedCoinExchangeContainer)containerType.create(i, inv, initData), ExtendedCoinExchangeContainer.CONTAINER_TITLE), buf -> ExtendedCoinExchangeContainer.writeContainerInitData(buf, packet.traderId));
        context.get().setPacketHandled(true);
    }
}

