/*
 * Decompiled with CFR 0.152.
 */
package com.github.maximuslotro.lotrrextended.common.network;

import com.github.maximuslotro.lotrrextended.common.inventory.ExtendedHiredUnitEquipmentContainer;
import io.netty.buffer.Unpooled;
import java.util.ArrayList;
import java.util.Objects;
import java.util.function.Supplier;
import lotr.common.entity.npc.ExtendedHiredBreeGuard;
import lotr.common.entity.npc.NPCEntity;
import lotr.common.init.ExtendedContainers;
import lotr.common.util.ExtendedHiredUnitHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.Inventory;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.inventory.container.SimpleNamedContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkEvent;
import net.minecraftforge.fml.network.NetworkHooks;

public class ExtendedCPacketOpenHiredEquipmentMenu {
    private final int entityId;

    public ExtendedCPacketOpenHiredEquipmentMenu(int entityId) {
        this.entityId = entityId;
    }

    public static ExtendedCPacketOpenHiredEquipmentMenu decode(PacketBuffer buf) {
        return new ExtendedCPacketOpenHiredEquipmentMenu(buf.readInt());
    }

    public static void encode(ExtendedCPacketOpenHiredEquipmentMenu msg, PacketBuffer buf) {
        buf.writeInt(msg.entityId);
    }

    public int getEntityId() {
        return this.entityId;
    }

    public static void handle(ExtendedCPacketOpenHiredEquipmentMenu msg, Supplier<NetworkEvent.Context> context) {
        context.get().enqueueWork(() -> {
            NPCEntity npcEntity;
            ArrayList<ItemStack> equipment = new ArrayList<ItemStack>(6);
            Entity entity = Objects.requireNonNull(((NetworkEvent.Context)context.get()).getSender()).field_70170_p.func_73045_a(msg.entityId);
            Inventory inventory = null;
            ItemStack[] baseGear = ExtendedHiredUnitHelper.getBaseGear(entity);
            if (entity instanceof ExtendedHiredBreeGuard) {
                inventory = ((ExtendedHiredBreeGuard)entity).inventory;
            }
            for (int i = 9; i < 15; ++i) {
                if (inventory != null) {
                    ItemStack item = inventory.func_70301_a(i);
                    if (baseGear[i - 9] != null && msg.areItemStacksExactlyEqual(baseGear[i - 9], item)) {
                        item = ItemStack.field_190927_a;
                    }
                    equipment.add(item);
                    continue;
                }
                equipment.add(ItemStack.field_190927_a);
            }
            PacketBuffer initData = new PacketBuffer(Unpooled.buffer());
            ExtendedHiredUnitEquipmentContainer.writeContainerInitData(initData, msg.entityId, equipment);
            if (entity instanceof NPCEntity && (npcEntity = (NPCEntity)entity) instanceof ExtendedHiredBreeGuard) {
                ((ExtendedHiredBreeGuard)npcEntity).setEquipmentOpen(true);
            }
            NetworkHooks.openGui((ServerPlayerEntity)((NetworkEvent.Context)context.get()).getSender(), (INamedContainerProvider)new SimpleNamedContainerProvider((windowId, playerInventory, player) -> (ExtendedHiredUnitEquipmentContainer)((ContainerType)ExtendedContainers.HIRED_UNIT_EQUIPMENT.get()).create(windowId, playerInventory, initData), ExtendedHiredUnitEquipmentContainer.CONTAINER_TITLE), buf -> ExtendedHiredUnitEquipmentContainer.writeContainerInitData(buf, msg.entityId, equipment));
            ((NetworkEvent.Context)context.get()).setPacketHandled(true);
        });
    }

    private boolean areItemStacksExactlyEqual(ItemStack stack1, ItemStack stack2) {
        if (stack1 == stack2) {
            return true;
        }
        if (stack1.func_190926_b() || stack2.func_190926_b() || !stack1.func_77973_b().equals(stack2.func_77973_b()) || stack1.func_190916_E() != stack2.func_190916_E()) {
            return false;
        }
        CompoundNBT nbt1 = stack1.func_77978_p();
        CompoundNBT nbt2 = stack2.func_77978_p();
        return nbt1 == null ? nbt2 == null : nbt1.equals((Object)nbt2);
    }
}

