/*
 * Decompiled with CFR 0.152.
 */
package com.github.maximuslotro.lotrrextended.common.network;

import com.github.maximuslotro.lotrrextended.common.inventory.ExtendedHiredUnitContainer;
import io.netty.buffer.Unpooled;
import java.util.Objects;
import java.util.function.Supplier;
import lotr.common.entity.npc.ExtendedHirableEntity;
import lotr.common.entity.npc.NPCEntity;
import lotr.common.init.ExtendedContainers;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.inventory.container.SimpleNamedContainerProvider;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkEvent;
import net.minecraftforge.fml.network.NetworkHooks;

public class ExtendedCPacketOpenHiredMenu {
    private final int entityId;

    public ExtendedCPacketOpenHiredMenu(int entityId) {
        this.entityId = entityId;
    }

    public static ExtendedCPacketOpenHiredMenu decode(PacketBuffer buf) {
        return new ExtendedCPacketOpenHiredMenu(buf.readInt());
    }

    public static void encode(ExtendedCPacketOpenHiredMenu msg, PacketBuffer buf) {
        buf.writeInt(msg.entityId);
    }

    public int getId() {
        return this.entityId;
    }

    public int getEntityId() {
        return this.entityId;
    }

    public static void handle(ExtendedCPacketOpenHiredMenu msg, Supplier<NetworkEvent.Context> context) {
        context.get().enqueueWork(() -> {
            NPCEntity npcEntity;
            Entity entity = Objects.requireNonNull(((NetworkEvent.Context)context.get()).getSender()).field_70170_p.func_73045_a(msg.entityId);
            PacketBuffer initData = new PacketBuffer(Unpooled.buffer());
            ExtendedHiredUnitContainer.writeContainerInitData(initData, msg.entityId);
            ExtendedHirableEntity hirableEntity = null;
            if (entity instanceof ExtendedHirableEntity) {
                hirableEntity = (ExtendedHirableEntity)entity;
            }
            if (entity instanceof NPCEntity && (npcEntity = (NPCEntity)entity) instanceof ExtendedHirableEntity) {
                ((ExtendedHirableEntity)npcEntity).setInventoryOpen(true);
            }
            assert (hirableEntity != null);
            NetworkHooks.openGui((ServerPlayerEntity)Objects.requireNonNull(((NetworkEvent.Context)context.get()).getSender()), (INamedContainerProvider)new SimpleNamedContainerProvider((windowId, playerInventory, player) -> (ExtendedHiredUnitContainer)((ContainerType)ExtendedContainers.HIRED_UNIT_CONTAINER.get()).create(windowId, playerInventory, initData), hirableEntity.getHiredUnitName()), buf -> ExtendedHiredUnitContainer.writeContainerInitData(buf, msg.entityId));
            ((NetworkEvent.Context)context.get()).setPacketHandled(true);
        });
    }
}

