/*
 * Decompiled with CFR 0.152.
 */
package com.github.maximuslotro.lotrrextended.common.network;

import java.util.Objects;
import java.util.Random;
import java.util.function.Supplier;
import lotr.common.config.LOTRConfig;
import lotr.common.entity.npc.NPCEntity;
import lotr.common.stat.LOTRStats;
import lotr.common.util.LOTRUtil;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkEvent;

public class ExtendedCPacketTalkWithTrader {
    private int traderId;

    public ExtendedCPacketTalkWithTrader() {
    }

    public ExtendedCPacketTalkWithTrader(int traderId) {
        this.traderId = traderId;
    }

    public static void encode(ExtendedCPacketTalkWithTrader packet, PacketBuffer buf) {
        buf.writeInt(packet.traderId);
    }

    public static ExtendedCPacketTalkWithTrader decode(PacketBuffer buf) {
        ExtendedCPacketTalkWithTrader packet = new ExtendedCPacketTalkWithTrader();
        packet.traderId = buf.readInt();
        return packet;
    }

    public static void handle(ExtendedCPacketTalkWithTrader packet, Supplier<NetworkEvent.Context> context) {
        Entity entity = Objects.requireNonNull(context.get().getSender()).field_70170_p.func_73045_a(packet.traderId);
        if (!(entity instanceof NPCEntity)) {
            return;
        }
        NPCEntity npc = (NPCEntity)entity;
        if (npc.sendNormalSpeechTo(context.get().getSender())) {
            int talkingToTime = LOTRUtil.secondsToTicks((int)LOTRConfig.COMMON.getRandomNPCTalkToPlayerDuration(new Random()));
            npc.setTalkingToEntity((LivingEntity)context.get().getSender(), talkingToTime);
            Objects.requireNonNull(context.get().getSender()).func_195066_a(LOTRStats.TALK_TO_NPC);
        }
        context.get().setPacketHandled(true);
    }
}

