/*
 * Decompiled with CFR 0.152.
 */
package com.github.maximuslotro.lotrrextended.common.network;

import com.github.maximuslotro.lotrrextended.common.bannerprotection.whitelist.ExtendedBannerProfileBase;
import com.github.maximuslotro.lotrrextended.common.bannerprotection.whitelist.ExtendedBannerProfileFellowship;
import com.github.maximuslotro.lotrrextended.common.bannerprotection.whitelist.ExtendedBannerProfilePlayer;
import com.github.maximuslotro.lotrrextended.common.enums.BannerPermission;
import com.github.maximuslotro.lotrrextended.common.tileentity.ExtendedMEBannerTileEntity;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.function.Supplier;
import lotr.common.util.client.ExtendedClientsideSeperatedScreenHandler;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.network.NetworkEvent;

public class ExtendedSBannerOpenChangedScreenPacket {
    public List<BannerPermission> defaultPerms;
    public float alignmentLevel;
    public List<ExtendedMEBannerTileEntity.ProtectionEntry> whitelist;
    public boolean canSelfProtect;
    public int protectionType;
    public BlockPos configurePos;
    public boolean enabled;

    public ExtendedSBannerOpenChangedScreenPacket() {
    }

    public ExtendedSBannerOpenChangedScreenPacket(boolean enabled) {
        this.defaultPerms = new ArrayList<BannerPermission>();
        this.alignmentLevel = 0.0f;
        this.whitelist = new ArrayList<ExtendedMEBannerTileEntity.ProtectionEntry>();
        this.canSelfProtect = false;
        this.protectionType = 0;
        this.configurePos = new BlockPos(0, 0, 0);
        this.enabled = enabled;
    }

    public ExtendedSBannerOpenChangedScreenPacket(ExtendedMEBannerTileEntity bannerEntity) {
        this.defaultPerms = bannerEntity.getDefaultPerms();
        this.alignmentLevel = bannerEntity.getAlignmentLevel();
        this.whitelist = bannerEntity.getProtectionWhitelist();
        this.canSelfProtect = bannerEntity.isCanProtectSelf();
        this.protectionType = bannerEntity.getProtectionType().getId();
        this.configurePos = bannerEntity.func_174877_v();
        this.enabled = true;
    }

    public static void encode(ExtendedSBannerOpenChangedScreenPacket packet, PacketBuffer buf) {
        buf.writeInt(packet.defaultPerms.size());
        for (BannerPermission perm : packet.defaultPerms) {
            buf.writeByte((int)((byte)perm.ordinal()));
        }
        buf.writeFloat(packet.alignmentLevel);
        buf.writeInt(packet.whitelist.size());
        for (ExtendedMEBannerTileEntity.ProtectionEntry entry : packet.whitelist) {
            buf.writeInt(entry.getEntryPerms().size());
            for (BannerPermission perm : entry.getEntryPerms()) {
                buf.writeByte((int)((byte)perm.ordinal()));
            }
            buf.func_179252_a(entry.getProfile().getId());
            buf.func_211400_a(entry.getProfile().getDisplayName(), Short.MAX_VALUE);
        }
        buf.writeBoolean(packet.canSelfProtect);
        buf.writeInt(packet.protectionType);
        buf.func_179255_a(packet.configurePos);
        buf.writeBoolean(packet.enabled);
    }

    public static ExtendedSBannerOpenChangedScreenPacket decode(PacketBuffer buf) {
        ExtendedSBannerOpenChangedScreenPacket packet = new ExtendedSBannerOpenChangedScreenPacket();
        int defaultPermsSize = buf.readInt();
        packet.defaultPerms = new ArrayList<BannerPermission>();
        for (int i = 0; i < defaultPermsSize; ++i) {
            packet.defaultPerms.add(BannerPermission.values[buf.readByte()]);
        }
        packet.alignmentLevel = buf.readFloat();
        packet.whitelist = new ArrayList<ExtendedMEBannerTileEntity.ProtectionEntry>();
        int whitelistSize = buf.readInt();
        for (int i = 0; i < whitelistSize; ++i) {
            int permListSize = buf.readInt();
            ArrayList<BannerPermission> profilePerms = new ArrayList<BannerPermission>();
            for (int j = 0; j < permListSize; ++j) {
                profilePerms.add(BannerPermission.values[buf.readByte()]);
            }
            UUID id = buf.func_179253_g();
            String name = buf.func_150789_c(Short.MAX_VALUE);
            ExtendedBannerProfileBase type = name.startsWith("f/") ? new ExtendedBannerProfileFellowship(name.substring(2), id) : new ExtendedBannerProfilePlayer(id, name);
            ExtendedMEBannerTileEntity.ProtectionEntry entry = new ExtendedMEBannerTileEntity.ProtectionEntry(type);
            entry.setPerms(profilePerms);
            packet.whitelist.add(entry);
        }
        packet.canSelfProtect = buf.readBoolean();
        packet.protectionType = buf.readInt();
        packet.configurePos = buf.func_179259_c();
        packet.enabled = buf.readBoolean();
        return packet;
    }

    public static void handle(ExtendedSBannerOpenChangedScreenPacket pPacket, Supplier<NetworkEvent.Context> context) {
        ExtendedClientsideSeperatedScreenHandler.handleBannerGUIUpdate(pPacket);
        context.get().setPacketHandled(true);
    }
}

