/*
 * Decompiled with CFR 0.152.
 */
package com.github.maximuslotro.lotrrextended.common.recipe;

import com.github.maximuslotro.lotrrextended.common.recipe.ExtendeGrinderRecipe;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSyntaxException;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.ForgeRegistryEntry;

public class ExtendedMillingRecipeSerializer
extends ForgeRegistryEntry<IRecipeSerializer<?>>
implements IRecipeSerializer<ExtendeGrinderRecipe> {
    public ExtendeGrinderRecipe fromJson(ResourceLocation recipeId, JsonObject json) {
        String group = JSONUtils.func_151219_a((JsonObject)json, (String)"group", (String)"");
        Ingredient ingredient = Ingredient.func_199802_a((JsonElement)JSONUtils.func_152754_s((JsonObject)json, (String)"ingredient"));
        if (ingredient.func_203189_d()) {
            throw new JsonParseException("No ingredients for stone grinding recipe");
        }
        if (!json.has("result")) {
            throw new JsonSyntaxException("Missing result, expected to find a string or object");
        }
        ItemStack result = ExtendedMillingRecipeSerializer.getItemStack(json);
        float experience = JSONUtils.func_151221_a((JsonObject)json, (String)"experience", (float)0.0f);
        int grindingtime = JSONUtils.func_151208_a((JsonObject)json, (String)"grindingtime", (int)200);
        float breakChance = JSONUtils.func_151221_a((JsonObject)json, (String)"breakchance", (float)0.0f);
        return new ExtendeGrinderRecipe(recipeId, group, ingredient, result, experience, grindingtime, breakChance);
    }

    public static ItemStack getItemStack(JsonObject json) {
        String itemName = JSONUtils.func_151200_h((JsonObject)json, (String)"result");
        Item item = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(itemName));
        if (item == null) {
            throw new JsonSyntaxException("Unknown item '" + itemName + "'");
        }
        return new ItemStack((IItemProvider)item, JSONUtils.func_151208_a((JsonObject)json, (String)"count", (int)1));
    }

    public ExtendeGrinderRecipe fromNetwork(ResourceLocation recipeId, PacketBuffer buffer) {
        String group = buffer.func_150789_c(Short.MAX_VALUE);
        Ingredient ingredient = Ingredient.func_199566_b((PacketBuffer)buffer);
        ItemStack result = buffer.func_150791_c();
        float experience = buffer.readFloat();
        int grindingtime = buffer.func_150792_a();
        float breakChance = buffer.readFloat();
        return new ExtendeGrinderRecipe(recipeId, group, ingredient, result, experience, grindingtime, breakChance);
    }

    public void toNetwork(PacketBuffer buffer, ExtendeGrinderRecipe recipe) {
        buffer.func_180714_a(recipe.group);
        recipe.ingredient.func_199564_a(buffer);
        buffer.func_150788_a(recipe.result);
        buffer.writeFloat(recipe.experience);
        buffer.func_150787_b(recipe.grindingTime);
        buffer.writeFloat(recipe.breakChance);
    }
}

