/*
 * Decompiled with CFR 0.152.
 */
package com.github.maximuslotro.lotrrextended.common.spawners;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.math.BlockPos;

public class ExtendedSpawnerBoundsEntry {
    public static final ExtendedSpawnerBoundsEntry DEFAULT = new ExtendedSpawnerBoundsEntry(0, 0, 0);
    public int topYvalue;
    public int lowerYvalue;
    public int horizontalBounds;

    public ExtendedSpawnerBoundsEntry(int topY, int bottomY, int horizontal) {
        this.topYvalue = topY;
        this.lowerYvalue = bottomY;
        this.horizontalBounds = horizontal;
    }

    public BlockPos getMinPos(int x, int y, int z) {
        return new BlockPos(x - this.horizontalBounds, y + this.lowerYvalue, z - this.horizontalBounds);
    }

    public BlockPos getMaxPos(int x, int y, int z) {
        return new BlockPos(x + this.horizontalBounds, y + this.topYvalue, z + this.horizontalBounds);
    }

    public boolean isInYRange(int blockHeight, int entityHeight) {
        return entityHeight + this.lowerYvalue < blockHeight && blockHeight < entityHeight + this.topYvalue;
    }

    public static class Serializer
    implements JsonDeserializer<ExtendedSpawnerBoundsEntry>,
    JsonSerializer<ExtendedSpawnerBoundsEntry> {
        public ExtendedSpawnerBoundsEntry deserialize(JsonElement json, Type p_deserialize_2_, JsonDeserializationContext context) throws JsonParseException {
            JsonObject jsonobject = JSONUtils.func_151210_l((JsonElement)json, (String)"ExtendedStructureEntitySpawner");
            int topY = jsonobject.get("topYvalue").getAsInt();
            int bottomY = jsonobject.get("lowerYvalue").getAsInt();
            int horizontal = jsonobject.get("horizontal_bounds").getAsInt();
            return new ExtendedSpawnerBoundsEntry(topY, bottomY, horizontal);
        }

        public JsonElement serialize(ExtendedSpawnerBoundsEntry entitySpawner, Type p_serialize_2_, JsonSerializationContext context) {
            JsonObject jsonobject = new JsonObject();
            jsonobject.addProperty("topYvalue", (Number)entitySpawner.topYvalue);
            jsonobject.addProperty("lowerYvalue", (Number)entitySpawner.lowerYvalue);
            jsonobject.addProperty("horizontal_bounds", (Number)entitySpawner.horizontalBounds);
            return jsonobject;
        }
    }
}

