/*
 * Decompiled with CFR 0.152.
 */
package com.github.maximuslotro.lotrrextended.common.spawners;

import com.github.maximuslotro.lotrrextended.ExtendedLog;
import com.github.maximuslotro.lotrrextended.common.json.GsonSerializers;
import com.github.maximuslotro.lotrrextended.common.spawners.ExtendedSpawners;
import com.github.maximuslotro.lotrrextended.common.spawners.ExtendedStructureEntitySpawner;
import com.github.maximuslotro.lotrrextended.common.spawners.ExtendedStructureEntitySpawnerEntry;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.client.resources.ReloadListener;
import net.minecraft.profiler.IProfiler;
import net.minecraft.resources.IResource;
import net.minecraft.resources.IResourceManager;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;

public class ExtendedStructureEntitySpawnManager
extends ReloadListener<Map<ResourceLocation, JsonElement>> {
    public static final ExtendedStructureEntitySpawnManager INSTANCE = new ExtendedStructureEntitySpawnManager();
    public static final Gson GSON = GsonSerializers.createStructureSpawnerSerializer().disableHtmlEscaping().create();
    public static final Gson GSON_PRETTY_WRITER = GsonSerializers.createStructureSpawnerSerializer().disableHtmlEscaping().setPrettyPrinting().create();
    private static final int PATH_SUFFIX_LENGTH = ".json".length();
    private final String directory = "entity_structure_spawners";
    private Map<ResourceLocation, ExtendedStructureEntitySpawner> spawners = ImmutableMap.of();
    private HashMap<String, List<String>> cachedSpawnLists = new HashMap();

    private ExtendedStructureEntitySpawnManager() {
    }

    public ExtendedStructureEntitySpawner get(ResourceLocation p_186521_1_) {
        return this.spawners.getOrDefault(p_186521_1_, ExtendedStructureEntitySpawner.EMPTY);
    }

    public List<String> getEntities(String location, List<ExtendedStructureEntitySpawnerEntry> defaultEntrys) {
        if (this.cachedSpawnLists.containsKey(location)) {
            return this.cachedSpawnLists.get(location);
        }
        ArrayList<String> returnList = new ArrayList<String>();
        for (ExtendedStructureEntitySpawnerEntry entry : defaultEntrys) {
            entry.getAllEntities().forEach(stringEntity -> {
                if (!returnList.contains(stringEntity)) {
                    returnList.add((String)stringEntity);
                }
            });
        }
        this.cachedSpawnLists.put(location, returnList);
        return returnList;
    }

    protected void apply(Map<ResourceLocation, JsonElement> json, IResourceManager p_212853_2_, IProfiler p_212853_3_) {
        ImmutableMap immutablemap;
        ImmutableMap.Builder builder = ImmutableMap.builder();
        JsonElement jsonelement = json.remove(ExtendedSpawners.EMPTY);
        if (jsonelement != null) {
            ExtendedLog.warn("Datapack tried to redefine {} loot table, ignoring", ExtendedSpawners.EMPTY);
        }
        json.forEach((spawnName, spawnListJson) -> {
            try {
                ExtendedStructureEntitySpawner spawnerData = ExtendedStructureEntitySpawnManager.deserialize(GSON, spawnListJson, ExtendedStructureEntitySpawner.class);
                if (spawnerData.isCustom) {
                    ExtendedLog.warn("Loaded a Entity Structure Spawner with the customLoad flag enabled, THIS SHOULD NOT BE SET IN JSON! Disabling flag!", spawnName);
                    spawnerData.isCustom = false;
                }
                if (spawnerData != null) {
                    builder.put(spawnName, (Object)spawnerData);
                }
            }
            catch (Exception exception) {
                ExtendedLog.error("Failed to load Extended Entity Structure Spawner %s from file", spawnName);
                exception.printStackTrace();
            }
        });
        builder.put((Object)ExtendedSpawners.EMPTY, (Object)ExtendedStructureEntitySpawner.EMPTY);
        this.spawners = immutablemap = builder.build();
        ExtendedLog.info("Loaded Structure Entity Spawners from Json - %s spawners", this.spawners.size() - 1);
    }

    protected Map<ResourceLocation, JsonElement> prepare(IResourceManager pResourceManager, IProfiler pProfiler) {
        HashMap map = Maps.newHashMap();
        int i = this.directory.length() + 1;
        for (ResourceLocation resourcelocation : pResourceManager.func_199003_a(this.directory, p_223379_0_ -> p_223379_0_.endsWith(".json"))) {
            String s = resourcelocation.func_110623_a();
            ResourceLocation resourcelocation1 = new ResourceLocation(resourcelocation.func_110624_b(), s.substring(i, s.length() - PATH_SUFFIX_LENGTH));
            try {
                IResource iresource = pResourceManager.func_199002_a(resourcelocation);
                Throwable throwable = null;
                try {
                    InputStream inputstream = iresource.func_199027_b();
                    Throwable throwable2 = null;
                    try {
                        BufferedReader reader = new BufferedReader(new InputStreamReader(inputstream, StandardCharsets.UTF_8));
                        Throwable throwable3 = null;
                        try {
                            JsonElement jsonelement = (JsonElement)JSONUtils.func_193839_a((Gson)GSON, (Reader)reader, JsonElement.class);
                            if (jsonelement != null) {
                                JsonElement jsonelement1 = map.put(resourcelocation1, jsonelement);
                                if (jsonelement1 == null) continue;
                                throw new IllegalStateException("Duplicate data file ignored with ID " + resourcelocation1);
                            }
                            ExtendedLog.error("Couldn't load data file {} from {} as it's null or empty", resourcelocation1, resourcelocation);
                        }
                        catch (Throwable throwable4) {
                            throwable3 = throwable4;
                            throw throwable4;
                        }
                        finally {
                            if (reader == null) continue;
                            if (throwable3 != null) {
                                try {
                                    ((Reader)reader).close();
                                }
                                catch (Throwable throwable5) {
                                    throwable3.addSuppressed(throwable5);
                                }
                                continue;
                            }
                            ((Reader)reader).close();
                        }
                    }
                    catch (Throwable throwable6) {
                        throwable2 = throwable6;
                        throw throwable6;
                    }
                    finally {
                        if (inputstream == null) continue;
                        if (throwable2 != null) {
                            try {
                                inputstream.close();
                            }
                            catch (Throwable throwable7) {
                                throwable2.addSuppressed(throwable7);
                            }
                            continue;
                        }
                        inputstream.close();
                    }
                }
                catch (Throwable throwable8) {
                    throwable = throwable8;
                    throw throwable8;
                }
                finally {
                    if (iresource == null) continue;
                    if (throwable != null) {
                        try {
                            iresource.close();
                        }
                        catch (Throwable throwable9) {
                            throwable.addSuppressed(throwable9);
                        }
                        continue;
                    }
                    iresource.close();
                }
            }
            catch (JsonParseException | IOException | IllegalArgumentException jsonparseexception) {
                ExtendedLog.error("Couldn't parse data file {} from {}", resourcelocation1, resourcelocation, jsonparseexception);
            }
        }
        return map;
    }

    public static String serialize(Gson gson, ExtendedStructureEntitySpawner data) {
        return gson.toJson((Object)data);
    }

    public static <T> T deserialize(Gson gson, JsonElement data, Class<T> classToConvert) {
        return (T)gson.fromJson(data, classToConvert);
    }

    public static <T> T deserialize(Gson gson, String data, Class<T> classToConvert) {
        return (T)gson.fromJson(data, classToConvert);
    }

    public Set<ResourceLocation> getIds() {
        return this.spawners.keySet();
    }
}

