/*
 * Decompiled with CFR 0.152.
 */
package com.github.maximuslotro.lotrrextended.common.spawners;

import com.github.maximuslotro.lotrrextended.ExtendedLog;
import com.github.maximuslotro.lotrrextended.common.config.ExtendedServerConfig;
import com.github.maximuslotro.lotrrextended.common.spawners.ExtendedSpawnerBoundsEntry;
import com.github.maximuslotro.lotrrextended.common.spawners.ExtendedSpawners;
import com.github.maximuslotro.lotrrextended.common.spawners.ExtendedStructureEntitySpawnerEntry;
import com.github.maximuslotro.lotrrextended.common.spawners.SpawnerType;
import com.github.maximuslotro.lotrrextended.common.spawners.types.MultiSpawnType;
import com.github.maximuslotro.lotrrextended.common.spawners.types.SingleSpawnType;
import com.google.common.collect.Lists;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.function.Consumer;
import net.minecraft.entity.EntityType;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.WeightedRandom;

public class ExtendedStructureEntitySpawner {
    public static final ExtendedStructureEntitySpawner EMPTY = new ExtendedStructureEntitySpawner(ExtendedSpawners.EMPTY, new ArrayList<ExtendedStructureEntitySpawnerEntry>(), SpawnerType.UNKNOWN, ExtendedSpawnerBoundsEntry.DEFAULT, ExtendedSpawnerBoundsEntry.DEFAULT);
    private static final int defaultEntitySpawnTickRate = 6000;
    private static final int defaultPlayerMinSpawnDistance = 15;
    private static final int defaultPlayerMaxSpawnDistance = 64;
    private static final int defultHomeRadius = 16;
    private static final int defaultLocalSpawnCap = 4;
    private final List<ExtendedStructureEntitySpawnerEntry> entries;
    private final ResourceLocation id;
    private final SpawnerType spawnType;
    private boolean setHomePositionOnSpawn = false;
    private boolean setHomeRandom = false;
    private int homeRadius = 16;
    private int entitySpawnTickRate = 6000;
    private int playerMinSpawnDistance = 15;
    private int playerMaxSpawnDistance = 64;
    private ExtendedSpawnerBoundsEntry checkBoundaries = ExtendedSpawnerBoundsEntry.DEFAULT;
    private ExtendedSpawnerBoundsEntry spawnRegion = ExtendedSpawnerBoundsEntry.DEFAULT;
    private int poolRolls = 1;
    private int localSpawnCap = 4;
    protected boolean isCustom = false;
    private boolean shouldDisableFutureSpawn = false;
    private int randomDiscardChance = 0;
    private boolean enableInsideSpawning = false;
    private int enableInsideSpawningChance = 100;

    private ExtendedStructureEntitySpawner(ResourceLocation id, List<ExtendedStructureEntitySpawnerEntry> entries, SpawnerType spawnType, ExtendedSpawnerBoundsEntry checkBoundaries, ExtendedSpawnerBoundsEntry spawnRegion) {
        this.id = id;
        this.entries = entries;
        this.spawnType = spawnType;
        this.checkBoundaries = checkBoundaries;
        this.spawnRegion = spawnRegion;
    }

    public ExtendedStructureEntitySpawner(ResourceLocation id, List<ExtendedStructureEntitySpawnerEntry> entries, SpawnerType spawnType, boolean setHomePositionOnSpawn, boolean setHomeRandom, int homeRadius, int entitySpawnTickRate, int playerMinSpawnDistance, int playerMaxSpawnDistance, ExtendedSpawnerBoundsEntry checkBoundaries, ExtendedSpawnerBoundsEntry spawnRegion, int poolRolls, int localSpawnCap, boolean shouldDisableFutureSpawn, int randomDiscardChance, boolean enableInsideSpawning, int enableInsideSpawningChance) {
        this(id, entries, spawnType, checkBoundaries, spawnRegion);
        this.setHomePositionOnSpawn = setHomePositionOnSpawn;
        this.setHomeRandom = setHomeRandom;
        this.homeRadius = homeRadius;
        this.entitySpawnTickRate = entitySpawnTickRate;
        this.playerMinSpawnDistance = playerMinSpawnDistance;
        this.playerMaxSpawnDistance = playerMaxSpawnDistance;
        this.poolRolls = poolRolls;
        this.localSpawnCap = localSpawnCap;
        this.shouldDisableFutureSpawn = shouldDisableFutureSpawn;
        this.randomDiscardChance = randomDiscardChance;
        this.enableInsideSpawning = enableInsideSpawning;
        this.enableInsideSpawningChance = enableInsideSpawningChance;
    }

    public ResourceLocation getId() {
        return this.id;
    }

    public boolean isEmptySpawner() {
        return this.equals(EMPTY) || this.id.equals((Object)ExtendedSpawners.EMPTY);
    }

    public boolean shouldTick() {
        return (Boolean)ExtendedServerConfig.enableDevMode.get() == false && !this.shouldDisableFutureSpawn;
    }

    public boolean isCustom() {
        return this.isCustom;
    }

    public List<ExtendedStructureEntitySpawnerEntry> getEntries() {
        return new ArrayList<ExtendedStructureEntitySpawnerEntry>(this.entries);
    }

    public List<EntityType<?>> getSpawns(Random random) {
        return ((ExtendedStructureEntitySpawnerEntry)WeightedRandom.func_76271_a((Random)random, this.entries)).getSpawns(random);
    }

    public SpawnerType getSpawnType() {
        return this.spawnType;
    }

    public boolean isSetHomePositionOnSpawn() {
        return this.setHomePositionOnSpawn;
    }

    public void setSetHomePositionOnSpawn(boolean setHomePositionOnSpawn) {
        this.isCustom = true;
        this.setHomePositionOnSpawn = setHomePositionOnSpawn;
    }

    public boolean isSetHomeRandom() {
        return this.setHomeRandom;
    }

    public void setSetHomeRandom(boolean setHomeRandom) {
        this.isCustom = true;
        this.setHomeRandom = setHomeRandom;
    }

    public int getHomeRadius() {
        return this.homeRadius;
    }

    public boolean setHomeRadius(int homeRadius) {
        this.isCustom = true;
        if (homeRadius < 1) {
            this.homeRadius = 16;
            return false;
        }
        this.homeRadius = homeRadius;
        return true;
    }

    public int getEntitySpawnTickRate() {
        return this.entitySpawnTickRate;
    }

    public boolean setEntitySpawnTickRate(int entitySpawnTickRate) {
        this.isCustom = true;
        if (entitySpawnTickRate < 1) {
            this.entitySpawnTickRate = 6000;
            return false;
        }
        this.entitySpawnTickRate = entitySpawnTickRate;
        return true;
    }

    public int getPoolRolls() {
        return this.poolRolls;
    }

    public boolean setPoolRolls(int poolRolls) {
        this.isCustom = true;
        if (poolRolls < 1) {
            this.poolRolls = 1;
            return false;
        }
        this.poolRolls = poolRolls;
        return true;
    }

    public int getLocalSpawnCap() {
        return this.localSpawnCap;
    }

    public boolean setLocalSpawnCap(int localSpawnCap) {
        this.isCustom = true;
        if (localSpawnCap < 0) {
            this.localSpawnCap = 4;
            return false;
        }
        this.localSpawnCap = localSpawnCap;
        return true;
    }

    public boolean isShouldDisableFutureSpawn() {
        return this.shouldDisableFutureSpawn;
    }

    public void setShouldDisableFutureSpawn(boolean shouldDisableFutureSpawn) {
        this.isCustom = true;
        this.shouldDisableFutureSpawn = shouldDisableFutureSpawn;
    }

    public boolean setRandomDiscardChance(int chance) {
        this.isCustom = true;
        if (chance < 0) {
            this.randomDiscardChance = 0;
            return false;
        }
        if (chance > 100) {
            this.randomDiscardChance = 100;
            return false;
        }
        this.randomDiscardChance = chance;
        return true;
    }

    public int getRandomDiscardChance() {
        return this.randomDiscardChance;
    }

    public boolean shouldCheckRandomDiscardChance() {
        return this.randomDiscardChance != 0;
    }

    public boolean insideSpawning() {
        return this.enableInsideSpawning;
    }

    public void setInsideSpawn(boolean enableInsideSpawning) {
        this.isCustom = true;
        this.enableInsideSpawning = enableInsideSpawning;
    }

    public void setInsideSpawn(boolean enableInsideSpawning, int chance) {
        this.isCustom = true;
        this.enableInsideSpawning = enableInsideSpawning;
        this.enableInsideSpawningChance = chance;
    }

    public int getinsideSpawningChance() {
        return this.enableInsideSpawningChance;
    }

    public void setInsideSpawnChance(int chance) {
        this.isCustom = true;
        this.enableInsideSpawningChance = chance;
    }

    public int getPlayerMinSpawnDistance() {
        return this.playerMinSpawnDistance;
    }

    public boolean setPlayerMinSpawnDistance(int playerMinSpawnDistance) {
        this.isCustom = true;
        if (playerMinSpawnDistance < 0) {
            this.playerMinSpawnDistance = 15;
            return false;
        }
        this.playerMinSpawnDistance = playerMinSpawnDistance;
        return true;
    }

    public int getPlayerMaxSpawnDistance() {
        return this.playerMaxSpawnDistance;
    }

    public boolean setPlayerMaxSpawnDistance(int playerMaxSpawnDistance) {
        this.isCustom = true;
        if (playerMaxSpawnDistance < 0) {
            this.playerMaxSpawnDistance = 64;
            return false;
        }
        this.playerMaxSpawnDistance = playerMaxSpawnDistance;
        return true;
    }

    public boolean setPlayerSpawnDistance(int playerMinSpawnDistance, int playerMaxSpawnDistance) {
        this.isCustom = true;
        return this.setPlayerMinSpawnDistance(playerMinSpawnDistance) && this.setPlayerMaxSpawnDistance(playerMaxSpawnDistance);
    }

    public ExtendedSpawnerBoundsEntry getCheckBoundaries() {
        return this.checkBoundaries;
    }

    public void setCBoundaries(int topY, int bottomY, int horizontal) {
        this.isCustom = true;
        this.setCheckBoundaries(new ExtendedSpawnerBoundsEntry(topY, bottomY, horizontal));
    }

    public void setCheckBoundaries(ExtendedSpawnerBoundsEntry checkBoundaries) {
        this.isCustom = true;
        this.checkBoundaries = checkBoundaries;
    }

    public ExtendedSpawnerBoundsEntry getSpawnBoundaries() {
        return this.spawnRegion;
    }

    public void setSpawnArea(int topY, int bottomY, int horizontal) {
        this.isCustom = true;
        this.setSpawnArea(new ExtendedSpawnerBoundsEntry(topY, bottomY, horizontal));
    }

    public void setSpawnArea(ExtendedSpawnerBoundsEntry spawnBoundaries) {
        this.isCustom = true;
        this.spawnRegion = spawnBoundaries;
    }

    public void setAreas(int topYC, int bottomYC, int horizontalC, int topYS, int bottomYS, int horizontalS) {
        this.isCustom = true;
        this.setCheckBoundaries(new ExtendedSpawnerBoundsEntry(topYC, bottomYC, horizontalC));
        this.setSpawnArea(new ExtendedSpawnerBoundsEntry(topYS, bottomYS, horizontalS));
    }

    public static class Builder {
        private List<ExtendedStructureEntitySpawnerEntry> entries = new ArrayList<ExtendedStructureEntitySpawnerEntry>();
        private final SpawnerType spawnType;
        private boolean setHomePositionOnSpawn = false;
        private boolean setHomeRandom = false;
        private int homeRadius = 16;
        private int entitySpawnTickRate = 6000;
        private int playerMinSpawnDistance = 15;
        private int playerMaxSpawnDistance = 64;
        private ExtendedSpawnerBoundsEntry checkBoundaries = ExtendedSpawnerBoundsEntry.DEFAULT;
        private ExtendedSpawnerBoundsEntry spawnRegion = ExtendedSpawnerBoundsEntry.DEFAULT;
        private int poolRolls = 1;
        private int localSpawnCap = 4;
        private boolean shouldDisableFutureSpawn = false;
        private int randomDiscardChance = 0;
        private boolean enableInsideSpawning = false;
        private int enableInsideSpawningChance = 100;

        public Builder(List<ExtendedStructureEntitySpawnerEntry> entries, SpawnerType spawnType, boolean setHomePositionOnSpawn, boolean setHomeRandom, int homeRadius, int entitySpawnTickRate, int playerMinSpawnDistance, int playerMaxSpawnDistance, ExtendedSpawnerBoundsEntry checkBoundaries, ExtendedSpawnerBoundsEntry spawnRegion, int poolRolls, int localSpawnCap, boolean shouldDisableFutureSpawn, int randomDiscardChance, boolean enableInsideSpawning, int enableInsideSpawningChance) {
            this.entries = entries;
            this.spawnType = spawnType;
            this.setHomePositionOnSpawn = setHomePositionOnSpawn;
            this.setHomeRandom = setHomeRandom;
            this.homeRadius = homeRadius;
            this.entitySpawnTickRate = entitySpawnTickRate;
            this.playerMinSpawnDistance = playerMinSpawnDistance;
            this.playerMaxSpawnDistance = playerMaxSpawnDistance;
            this.checkBoundaries = checkBoundaries;
            this.spawnRegion = spawnRegion;
            this.poolRolls = poolRolls;
            this.localSpawnCap = localSpawnCap;
            this.shouldDisableFutureSpawn = shouldDisableFutureSpawn;
            this.randomDiscardChance = randomDiscardChance;
            this.enableInsideSpawning = enableInsideSpawning;
            this.enableInsideSpawningChance = enableInsideSpawningChance;
        }

        private Builder(SpawnerType spawnType) {
            this.spawnType = spawnType;
        }

        public Builder setHomeInfo(boolean setHomeRandom, int homeRadius) {
            this.setHomePositionOnSpawn = true;
            this.setHomeRandom = setHomeRandom;
            this.homeRadius = homeRadius;
            return this;
        }

        public Builder setPlayerDistance(int min, int max) {
            this.playerMinSpawnDistance = min;
            this.playerMaxSpawnDistance = max;
            return this;
        }

        public Builder setBoundaries(int topYC, int bottomYC, int horizontalC, int topYS, int bottomYS, int horizontalS) {
            this.checkBoundaries = new ExtendedSpawnerBoundsEntry(topYC, bottomYC, horizontalC);
            this.spawnRegion = new ExtendedSpawnerBoundsEntry(topYS, bottomYS, horizontalS);
            return this;
        }

        public Builder setEntitySpawnTickRate(int ticks) {
            this.entitySpawnTickRate = ticks;
            return this;
        }

        public Builder setEntitySpawnSeconds(int seconds) {
            this.entitySpawnTickRate = seconds * 20;
            return this;
        }

        public Builder setEntitySpawnMinutes(int minutes) {
            this.entitySpawnTickRate = minutes * 60 * 20;
            return this;
        }

        public Builder setPoolRolls(int rolls) {
            this.poolRolls = rolls;
            return this;
        }

        public Builder setlocalSpawnCap(int cap) {
            this.localSpawnCap = cap;
            return this;
        }

        public Builder setRandomDiscardChance(int chance) {
            this.randomDiscardChance = chance;
            return this;
        }

        public Builder disableForFutureSpawning() {
            this.shouldDisableFutureSpawn = true;
            return this;
        }

        public Builder enableNonRandomSpawning() {
            this.enableInsideSpawning = true;
            this.enableInsideSpawningChance = 100;
            return this;
        }

        public Builder enableNonRandomSpawning(int chance) {
            this.enableInsideSpawning = true;
            this.enableInsideSpawningChance = chance;
            return this;
        }

        public ExtendedStructureEntitySpawner build(ResourceLocation id, boolean isCustom) {
            ExtendedStructureEntitySpawner spawner = new ExtendedStructureEntitySpawner(id, this.entries, this.spawnType, this.setHomePositionOnSpawn, this.setHomeRandom, this.homeRadius, this.entitySpawnTickRate, this.playerMinSpawnDistance, this.playerMaxSpawnDistance, this.checkBoundaries, this.spawnRegion, this.poolRolls, this.localSpawnCap, this.shouldDisableFutureSpawn, this.randomDiscardChance, this.enableInsideSpawning, this.enableInsideSpawningChance);
            spawner.isCustom = isCustom;
            return spawner;
        }

        public ExtendedStructureEntitySpawner save(Consumer<ExtendedStructureEntitySpawner> pConsumer, String pId) {
            return this.save(pConsumer, new ResourceLocation(pId));
        }

        public ExtendedStructureEntitySpawner save(Consumer<ExtendedStructureEntitySpawner> pConsumer, ResourceLocation pId) {
            ExtendedStructureEntitySpawner spawner = this.build(pId, false);
            pConsumer.accept(spawner);
            return spawner;
        }

        public static Builder spawner(SpawnerType spawnType) {
            return new Builder(spawnType);
        }

        public static Builder spawner(SpawnerType spawnType, boolean setHomePositionOnSpawn, int homeRadius) {
            return new Builder(spawnType).setHomeInfo(setHomePositionOnSpawn, homeRadius);
        }

        public Builder addSinglePool(EntityType<?> type, int weight, int minSpawnCount, int maxSpawnCount) {
            this.entries.add(new ExtendedStructureEntitySpawnerEntry(new SingleSpawnType(type), weight, minSpawnCount, maxSpawnCount));
            return this;
        }

        public Builder addMultiPool(MultiSpawnType multiPool, int weight, int minSpawnCount, int maxSpawnCount) {
            this.entries.add(new ExtendedStructureEntitySpawnerEntry(multiPool, weight, minSpawnCount, maxSpawnCount));
            return this;
        }
    }

    public static class Serializer
    implements JsonDeserializer<ExtendedStructureEntitySpawner>,
    JsonSerializer<ExtendedStructureEntitySpawner> {
        public ExtendedStructureEntitySpawner deserialize(JsonElement json, Type p_deserialize_2_, JsonDeserializationContext context) throws JsonParseException {
            JsonObject jsonobject = JSONUtils.func_151210_l((JsonElement)json, (String)"ExtendedStructureEntitySpawner");
            ArrayList alootpool = Lists.newArrayList((Object[])((Object[])JSONUtils.func_188177_a((JsonObject)jsonobject, (String)"pools", (Object)new ExtendedStructureEntitySpawnerEntry[0], (JsonDeserializationContext)context, ExtendedStructureEntitySpawnerEntry[].class)));
            String id = jsonobject.get("id").getAsString();
            if (id == null || !id.contains(":")) {
                ExtendedLog.warn("Failed to load structure spawner due to invalid id: %s!", id);
                return null;
            }
            if (alootpool.size() < 1) {
                ExtendedLog.warn("Failed to load structure spawner due to spawner pool size less than 1: %s!", id);
                return null;
            }
            SpawnerType type = SpawnerType.bySpawnerName(jsonobject.get("spawner_type").getAsString());
            if (type == SpawnerType.UNKNOWN) {
                ExtendedLog.warn("Failed to load structure spawner %s due to invalid spawn type!", id);
                return null;
            }
            if (type == SpawnerType.SINGLE_FAMILY && alootpool.size() > 1) {
                ExtendedLog.warn("Failed to load structure spawner %s due to single_family_spawner type spawners not allowing more than one entity pool!", id);
                return null;
            }
            if (type == SpawnerType.SINGLE_FAMILY && alootpool.size() == 1 && ((ExtendedStructureEntitySpawnerEntry)((Object)alootpool.get(0))).getSpawnerForTypeArguments() instanceof MultiSpawnType) {
                ExtendedLog.warn("Failed to load structure spawner %s due to single_family_spawner type not supporting multiSpawnTypes (entity_types), should only contain an (entity_type)!", id);
                return null;
            }
            ExtendedSpawnerBoundsEntry check = (ExtendedSpawnerBoundsEntry)JSONUtils.func_188177_a((JsonObject)jsonobject, (String)"check_boundaries", (Object)ExtendedSpawnerBoundsEntry.DEFAULT, (JsonDeserializationContext)context, ExtendedSpawnerBoundsEntry.class);
            ExtendedSpawnerBoundsEntry spawn = (ExtendedSpawnerBoundsEntry)JSONUtils.func_188177_a((JsonObject)jsonobject, (String)"spawn_area", (Object)ExtendedSpawnerBoundsEntry.DEFAULT, (JsonDeserializationContext)context, ExtendedSpawnerBoundsEntry.class);
            ExtendedStructureEntitySpawner spawner = new ExtendedStructureEntitySpawner(new ResourceLocation(id), alootpool, type, check, spawn);
            if (jsonobject.has("setHomeOnSpawn") && jsonobject.get("setHomeOnSpawn").getAsBoolean()) {
                spawner.setSetHomePositionOnSpawn(true);
                if (!jsonobject.has("homeRadius")) {
                    ExtendedLog.error("Loaded Structure Spawner with invalid settings! homeRadius must be set if setHomeOnSpawn is enabled. Ignoring spawner - %s", id);
                    return null;
                }
                if (!spawner.setHomeRadius(jsonobject.get("homeRadius").getAsInt())) {
                    ExtendedLog.warn("Loaded Structure Spawner with invalid homeRadius set! Resetting to default! - %s", id);
                }
            }
            if (jsonobject.has("setHomeRandomly")) {
                if (!spawner.isSetHomePositionOnSpawn() || type == SpawnerType.SINGLE_FAMILY) {
                    if (type == SpawnerType.SINGLE_FAMILY) {
                        ExtendedLog.warn("Loaded Structure Spawner with invalid settings! Can't set setHomeRandomly if single_family_spawner type! - %s", id);
                    }
                    if (!spawner.isSetHomePositionOnSpawn()) {
                        ExtendedLog.warn("Loaded Structure Spawner with invalid settings! Can't set setHomeRandomly if setHomeOnSpawn is not set! - %s", id);
                    }
                } else {
                    spawner.setSetHomeRandom(jsonobject.get("setHomeRandomly").getAsBoolean());
                }
            }
            if (jsonobject.has("entitySpawnTickRate") && !spawner.setEntitySpawnTickRate(jsonobject.get("entitySpawnTickRate").getAsInt())) {
                ExtendedLog.warn("Loaded Structure Spawner with invalid entitySpawnTickRate set! Resetting to default! - %s", id);
            }
            if (jsonobject.has("playerMinSpawnDistance") || jsonobject.has("playerMaxSpawnDistance")) {
                if (!jsonobject.has("playerMinSpawnDistance") || !jsonobject.has("playerMaxSpawnDistance")) {
                    ExtendedLog.error("Loaded Structure Spawner with invalid playerSpawnDistances set! Both must be set if either are set! Ignoring spawner - %s", id);
                    return null;
                }
                if (!spawner.setPlayerMinSpawnDistance(jsonobject.get("playerMinSpawnDistance").getAsInt())) {
                    ExtendedLog.warn("Loaded Structure Spawner with invalid playerMinSpawnDistance set! Resetting to default! - %s", id);
                }
                if (!spawner.setPlayerMaxSpawnDistance(jsonobject.get("playerMaxSpawnDistance").getAsInt())) {
                    ExtendedLog.warn("Loaded Structure Spawner with invalid playerMaxSpawnDistance set! Resetting to default! - %s", id);
                }
            }
            if (jsonobject.has("numRolls") && !spawner.setPoolRolls(jsonobject.get("numRolls").getAsInt())) {
                ExtendedLog.warn("Loaded Structure Spawner with invalid numRolls set! Resetting to default! - %s", id);
            }
            if (jsonobject.has("spawnCap")) {
                if (type.isSingleSpawnType()) {
                    ExtendedLog.warn("Loaded Structure Spawner with invalid settings! spawnCap should be set to 0 if spawner is of the Single types - %s", id);
                } else if (!spawner.setLocalSpawnCap(jsonobject.get("spawnCap").getAsInt())) {
                    ExtendedLog.warn("Loaded Structure Spawner with invalid spawnCap set! Resetting to default! - %s", id);
                }
            }
            if (jsonobject.has("disable_for_use_in_future")) {
                spawner.setShouldDisableFutureSpawn(jsonobject.get("disable_for_use_in_future").getAsBoolean());
            }
            if (jsonobject.has("inside_spawning")) {
                spawner.setInsideSpawn(jsonobject.get("inside_spawning").getAsBoolean());
                if (!spawner.insideSpawning()) {
                    ExtendedLog.info("Loaded Structure Spawner with weird inside_spawning configuration, value is false by default, no need to force this! - %s", id);
                }
                if (jsonobject.has("inside_spawning_chance")) {
                    spawner.setInsideSpawnChance(jsonobject.get("inside_spawning_chance").getAsInt());
                    if (spawner.getinsideSpawningChance() == 100) {
                        ExtendedLog.info("Loaded Structure Spawner with weird inside_spawning_chance configuration, value is 100 by default, no need to force this! - %s", id);
                    }
                }
            }
            if (jsonobject.has("randomDiscardChance") && !spawner.setRandomDiscardChance(jsonobject.get("randomDiscardChance").getAsInt())) {
                ExtendedLog.warn("Loaded Structure Spawner with invalid randomDiscardChance set! Resetting to default! - %s", id);
            }
            spawner.isCustom = false;
            if (jsonobject.has("customLoad")) {
                spawner.isCustom = jsonobject.get("customLoad").getAsBoolean();
            }
            return spawner;
        }

        public JsonElement serialize(ExtendedStructureEntitySpawner entitySpawner, Type p_serialize_2_, JsonSerializationContext context) {
            JsonObject jsonobject = new JsonObject();
            jsonobject.addProperty("id", entitySpawner.getId().toString());
            jsonobject.addProperty("spawner_type", entitySpawner.spawnType.getString());
            if (entitySpawner.isShouldDisableFutureSpawn()) {
                jsonobject.addProperty("disable_for_use_in_future", Boolean.valueOf(true));
            }
            if (entitySpawner.getCheckBoundaries() != ExtendedSpawnerBoundsEntry.DEFAULT) {
                jsonobject.add("check_boundaries", context.serialize((Object)entitySpawner.checkBoundaries));
            }
            if (entitySpawner.getSpawnBoundaries() != ExtendedSpawnerBoundsEntry.DEFAULT) {
                jsonobject.add("spawn_area", context.serialize((Object)entitySpawner.spawnRegion));
            }
            if (entitySpawner.insideSpawning()) {
                jsonobject.addProperty("inside_spawning", Boolean.valueOf(entitySpawner.insideSpawning()));
                if (entitySpawner.getinsideSpawningChance() != 100) {
                    jsonobject.addProperty("inside_spawning_chance", (Number)entitySpawner.getinsideSpawningChance());
                }
            }
            if (entitySpawner.isSetHomePositionOnSpawn()) {
                jsonobject.addProperty("setHomeOnSpawn", Boolean.valueOf(entitySpawner.isSetHomePositionOnSpawn()));
                if (entitySpawner.isSetHomeRandom()) {
                    jsonobject.addProperty("setHomeRandomly", Boolean.valueOf(entitySpawner.isSetHomeRandom()));
                }
                jsonobject.addProperty("homeRadius", (Number)entitySpawner.getHomeRadius());
            }
            if (entitySpawner.getEntitySpawnTickRate() != 6000) {
                jsonobject.addProperty("entitySpawnTickRate", (Number)entitySpawner.getEntitySpawnTickRate());
            }
            if (entitySpawner.getPlayerMinSpawnDistance() != 15 || entitySpawner.getPlayerMaxSpawnDistance() != 64) {
                jsonobject.addProperty("playerMinSpawnDistance", (Number)entitySpawner.getPlayerMinSpawnDistance());
                jsonobject.addProperty("playerMaxSpawnDistance", (Number)entitySpawner.getPlayerMaxSpawnDistance());
            }
            if (!entitySpawner.getSpawnType().isSingleSpawnType()) {
                jsonobject.addProperty("spawnCap", (Number)entitySpawner.getLocalSpawnCap());
            }
            if (entitySpawner.isCustom()) {
                jsonobject.addProperty("customLoad", Boolean.valueOf(true));
            }
            if (entitySpawner.shouldCheckRandomDiscardChance()) {
                jsonobject.addProperty("randomDiscardChance", (Number)entitySpawner.getRandomDiscardChance());
            }
            if (entitySpawner.getPoolRolls() != 1) {
                jsonobject.addProperty("numRolls", (Number)entitySpawner.getPoolRolls());
            }
            if (!entitySpawner.entries.isEmpty()) {
                jsonobject.add("pools", context.serialize((Object)entitySpawner.entries));
            }
            return jsonobject;
        }
    }
}

