/*
 * Decompiled with CFR 0.152.
 */
package com.github.maximuslotro.lotrrextended.common.spawners;

public enum SpawnerType {
    SINGLE("single_use_spawner", 0, false, true),
    SINGLE_FAMILY("single_family_spawner", 1, false, true),
    PERSISTED("persisted_use_spawner", 2, true, false),
    UNKNOWN("unknown", 66, false, true);

    private final String name;
    private final int id;
    private final boolean shoudlCheckBoundries;
    private final boolean singleSpawnType;

    private SpawnerType(String pName, int pID, boolean shoudlCheckBoundries, boolean singleSpawnType) {
        this.name = pName;
        this.id = pID;
        this.shoudlCheckBoundries = shoudlCheckBoundries;
        this.singleSpawnType = singleSpawnType;
    }

    public String getString() {
        return this.name;
    }

    public boolean isUnknown() {
        return this.equals((Object)UNKNOWN) || this.id == SpawnerType.UNKNOWN.id;
    }

    public int getSpawnerIdDoNotUse() {
        return this.id;
    }

    public boolean isShouldCheckBoundries() {
        return this.shoudlCheckBoundries;
    }

    public boolean isSingleSpawnType() {
        return this.singleSpawnType;
    }

    public static SpawnerType bySpawnerName(String queryName) {
        for (SpawnerType type : SpawnerType.values()) {
            if (!type.name.equals(queryName)) continue;
            return type;
        }
        return UNKNOWN;
    }

    public static SpawnerType bySpawnerId(int queryID) {
        for (SpawnerType type : SpawnerType.values()) {
            if (type.id != queryID) continue;
            return type;
        }
        return UNKNOWN;
    }
}

