/*
 * Decompiled with CFR 0.152.
 */
package com.github.maximuslotro.lotrrextended.common.spawners.types;

import com.github.maximuslotro.lotrrextended.common.spawners.types.ExtendedStructureEntityTypeInterface;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.stream.Collectors;
import net.minecraft.entity.EntityType;
import net.minecraft.util.WeightedRandom;

public class MultiSpawnType
implements ExtendedStructureEntityTypeInterface {
    private final List<MultiSpawnEntry> entities;

    public MultiSpawnType(List<MultiSpawnEntry> entities) {
        this.entities = entities;
    }

    @Override
    public EntityType<?> getSpawn(Random random) {
        return ((MultiSpawnEntry)WeightedRandom.func_76271_a((Random)random, this.entities)).getEntity();
    }

    @Override
    public List<EntityType<?>> getAllPossableEntities() {
        return this.entities.stream().map(MultiSpawnEntry::getEntity).collect(Collectors.toList());
    }

    public List<MultiSpawnEntry> getEntities() {
        return this.entities;
    }

    public static class Builder {
        private List<MultiSpawnEntry> entries = new ArrayList<MultiSpawnEntry>();

        public Builder(List<MultiSpawnEntry> entries) {
            this.entries = entries;
        }

        private Builder() {
        }

        public static Builder multi() {
            return new Builder();
        }

        public Builder addPool(EntityType<?> type, int weight) {
            this.entries.add(new MultiSpawnEntry(weight, type));
            return this;
        }

        public MultiSpawnType build() {
            return new MultiSpawnType(this.entries);
        }
    }

    public static class MultiSpawnEntry
    extends WeightedRandom.Item {
        private final EntityType<?> entity;

        public MultiSpawnEntry(int weight, EntityType<?> entity) {
            super(weight);
            this.entity = entity;
        }

        public EntityType<?> getEntity() {
            return this.entity;
        }
    }
}

