/*
 * Decompiled with CFR 0.152.
 */
package com.github.maximuslotro.lotrrextended.common.tileentity;

import com.github.maximuslotro.lotrrextended.common.block.ExtendedGrinderBlock;
import com.github.maximuslotro.lotrrextended.common.init.ExtendedTags;
import com.github.maximuslotro.lotrrextended.common.inventory.container.ExtendedGrinderContainer;
import com.github.maximuslotro.lotrrextended.common.recipe.ExtendeGrinderRecipe;
import com.github.maximuslotro.lotrrextended.common.recipe.ExtendedRecipes;
import com.google.common.collect.Lists;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import lotr.common.init.ExtendedTileEntities;
import lotr.common.item.VesselDrinkItem;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ExperienceOrbEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.IRecipeHelperPopulator;
import net.minecraft.inventory.IRecipeHolder;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.inventory.container.Container;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.PotionItem;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.RecipeItemHelper;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.state.Property;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.LockableTileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.IIntArray;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.SidedInvWrapper;

public class ExtendedGrinderTileEntity
extends LockableTileEntity
implements ISidedInventory,
IRecipeHolder,
IRecipeHelperPopulator,
ITickableTileEntity {
    private static final int[] SLOTS_FOR_UP = new int[]{0};
    private static final int[] SLOTS_FOR_DOWN = new int[]{2, 1};
    private static final int[] SLOTS_FOR_SIDES = new int[]{0, 1};
    protected NonNullList<ItemStack> items = NonNullList.func_191197_a((int)3, (Object)ItemStack.field_190927_a);
    private int grindingProgress = 0;
    private int grindingTotalTime = 0;
    private boolean usingLubrication = false;
    protected final IIntArray dataAccess = new IIntArray(){

        public int func_221476_a(int pIndex) {
            switch (pIndex) {
                case 0: {
                    return ExtendedGrinderTileEntity.this.grindingProgress;
                }
                case 1: {
                    return ExtendedGrinderTileEntity.this.grindingTotalTime;
                }
                case 2: {
                    return ExtendedGrinderTileEntity.this.usingLubrication ? 1 : 0;
                }
            }
            return 0;
        }

        public void func_221477_a(int pIndex, int pValue) {
            switch (pIndex) {
                case 0: {
                    ExtendedGrinderTileEntity.this.grindingProgress = pValue;
                    break;
                }
                case 1: {
                    ExtendedGrinderTileEntity.this.grindingTotalTime = pValue;
                    break;
                }
                case 2: {
                    ExtendedGrinderTileEntity.this.usingLubrication = pValue != 0;
                }
            }
        }

        public int func_221478_a() {
            return 3;
        }
    };
    private final Object2IntOpenHashMap<ResourceLocation> recipesUsed = new Object2IntOpenHashMap();
    LazyOptional<? extends IItemHandler>[] handlers = SidedInvWrapper.create((ISidedInventory)this, (Direction[])new Direction[]{Direction.UP, Direction.DOWN, Direction.NORTH});

    private ExtendedGrinderTileEntity(TileEntityType<?> tileEntityType) {
        super(tileEntityType);
    }

    public ExtendedGrinderTileEntity() {
        this((TileEntityType)ExtendedTileEntities.MILLSTONE.get());
    }

    private boolean isPowered() {
        return (Boolean)this.func_195044_w().func_177229_b((Property)ExtendedGrinderBlock.POWERED);
    }

    public void func_230337_a_(BlockState p_230337_1_, CompoundNBT p_230337_2_) {
        super.func_230337_a_(p_230337_1_, p_230337_2_);
        this.items = NonNullList.func_191197_a((int)this.func_70302_i_(), (Object)ItemStack.field_190927_a);
        ItemStackHelper.func_191283_b((CompoundNBT)p_230337_2_, this.items);
        this.grindingProgress = p_230337_2_.func_74762_e("GrindingTime");
        this.grindingTotalTime = p_230337_2_.func_74762_e("GrindingTimeTotal");
        CompoundNBT compoundnbt = p_230337_2_.func_74775_l("RecipesUsed");
        for (String s : compoundnbt.func_150296_c()) {
            this.recipesUsed.put((Object)new ResourceLocation(s), compoundnbt.func_74762_e(s));
        }
    }

    public CompoundNBT func_189515_b(CompoundNBT pCompound) {
        super.func_189515_b(pCompound);
        pCompound.func_74768_a("GrindingTime", this.grindingProgress);
        pCompound.func_74768_a("GrindingTimeTotal", this.grindingTotalTime);
        ItemStackHelper.func_191282_a((CompoundNBT)pCompound, this.items);
        CompoundNBT compoundnbt = new CompoundNBT();
        this.recipesUsed.forEach((p_235643_1_, p_235643_2_) -> compoundnbt.func_74768_a(p_235643_1_.toString(), p_235643_2_.intValue()));
        pCompound.func_218657_a("RecipesUsed", (INBT)compoundnbt);
        return pCompound;
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K) {
            if (this.canLubeItem((ItemStack)this.items.get(1))) {
                if (this.grindingProgress < 100 && !this.usingLubrication) {
                    this.usingLubrication = true;
                }
            } else {
                this.usingLubrication = false;
            }
            if (this.isPowered() && !((ItemStack)this.items.get(0)).func_190926_b()) {
                ExtendeGrinderRecipe irecipe = this.field_145850_b.func_199532_z().func_215371_a(ExtendedRecipes.MILLSTONE, (IInventory)this, this.field_145850_b).orElse(null);
                if (this.isPowered() && this.canGrind(irecipe)) {
                    ++this.grindingProgress;
                    if (this.grindingProgress == this.grindingTotalTime) {
                        this.grindingProgress = 0;
                        this.grindingTotalTime = this.getTotalMillingTime();
                        this.grind(irecipe);
                    }
                } else {
                    this.grindingProgress = 0;
                }
            } else if (!this.isPowered() && this.grindingProgress > 0) {
                this.grindingProgress = MathHelper.func_76125_a((int)(this.grindingProgress - 2), (int)0, (int)this.grindingTotalTime);
            }
        }
    }

    public boolean canLubeItem(ItemStack pStack) {
        return ExtendedTags.Items.STONE_GRINDER_LUBRICANTS.func_230235_a_((Object)pStack.func_77973_b());
    }

    protected boolean canGrind(@Nullable ExtendeGrinderRecipe recipe) {
        if (!((ItemStack)this.items.get(0)).func_190926_b() && recipe != null) {
            ItemStack itemstack = recipe.func_77572_b((IInventory)this);
            if (itemstack.func_190926_b()) {
                return false;
            }
            ItemStack itemstack1 = (ItemStack)this.items.get(2);
            if (itemstack1.func_190926_b()) {
                return true;
            }
            if (!itemstack1.func_77969_a(itemstack)) {
                return false;
            }
            if (itemstack1.func_190916_E() + itemstack.func_190916_E() <= this.func_70297_j_() && itemstack1.func_190916_E() + itemstack.func_190916_E() <= itemstack1.func_77976_d()) {
                return true;
            }
            return itemstack1.func_190916_E() + itemstack.func_190916_E() <= itemstack.func_77976_d();
        }
        return false;
    }

    private void grind(@Nullable ExtendeGrinderRecipe recipe) {
        if (recipe != null && this.canGrind(recipe)) {
            ItemStack itemstack = (ItemStack)this.items.get(0);
            ItemStack itemstack1 = recipe.func_77572_b((IInventory)this);
            ItemStack itemstack2 = (ItemStack)this.items.get(2);
            boolean needsLubeRemoving = false;
            if (recipe.getBreakChance() > 0.0f) {
                Random rand = new Random();
                if (rand.nextFloat() < recipe.getBreakChance() && !this.usingLubrication) {
                    itemstack.func_190918_g(1);
                    return;
                }
                needsLubeRemoving = true;
            }
            if (itemstack2.func_190926_b()) {
                this.items.set(2, (Object)itemstack1.func_77946_l());
            } else if (itemstack2.func_77973_b() == itemstack1.func_77973_b()) {
                itemstack2.func_190917_f(itemstack1.func_190916_E());
            }
            if (!this.field_145850_b.field_72995_K) {
                this.func_193056_a(recipe);
            }
            if (this.usingLubrication && needsLubeRemoving) {
                ItemStack itemstack3 = (ItemStack)this.items.get(1);
                if (itemstack3.hasContainerItem()) {
                    this.items.set(1, (Object)itemstack3.getContainerItem());
                } else if (itemstack3.func_77973_b() instanceof VesselDrinkItem) {
                    this.items.set(1, (Object)((VesselDrinkItem)itemstack3.func_77973_b()).getContainerItem(itemstack3));
                } else if (itemstack3.func_77973_b() instanceof PotionItem) {
                    this.items.set(1, (Object)new ItemStack((IItemProvider)Items.field_151069_bo));
                } else if (!itemstack3.func_190926_b()) {
                    Item item = itemstack3.func_77973_b();
                    itemstack3.func_190918_g(1);
                    if (itemstack3.func_190926_b()) {
                        this.items.set(1, (Object)itemstack3.getContainerItem());
                    }
                }
                this.usingLubrication = false;
            }
            itemstack.func_190918_g(1);
        }
    }

    protected int getTotalMillingTime() {
        return this.field_145850_b.func_199532_z().func_215371_a(ExtendedRecipes.MILLSTONE, (IInventory)this, this.field_145850_b).map(ExtendeGrinderRecipe::getMillingTime).orElse(200);
    }

    public int[] func_180463_a(Direction pSide) {
        if (pSide == Direction.DOWN) {
            return SLOTS_FOR_DOWN;
        }
        return pSide == Direction.UP ? SLOTS_FOR_UP : SLOTS_FOR_SIDES;
    }

    public boolean func_180462_a(int pIndex, ItemStack pItemStack, @Nullable Direction pDirection) {
        return this.func_94041_b(pIndex, pItemStack);
    }

    public boolean func_94041_b(int pIndex, ItemStack pStack) {
        if (pIndex == 2) {
            return false;
        }
        if (pIndex == 0) {
            return !this.canLubeItem(pStack);
        }
        return this.canLubeItem(pStack);
    }

    public boolean func_180461_b(int pIndex, ItemStack pStack, Direction pDirection) {
        return pDirection != Direction.DOWN || pIndex != 1 || !this.canLubeItem(pStack);
    }

    public int func_70302_i_() {
        return this.items.size();
    }

    public boolean func_191420_l() {
        for (ItemStack itemstack : this.items) {
            if (itemstack.func_190926_b()) continue;
            return false;
        }
        return true;
    }

    public ItemStack func_70301_a(int pIndex) {
        return (ItemStack)this.items.get(pIndex);
    }

    public ItemStack func_70298_a(int pIndex, int pCount) {
        return ItemStackHelper.func_188382_a(this.items, (int)pIndex, (int)pCount);
    }

    public ItemStack func_70304_b(int pIndex) {
        return ItemStackHelper.func_188383_a(this.items, (int)pIndex);
    }

    public void func_70299_a(int pIndex, ItemStack pStack) {
        ItemStack itemstack = (ItemStack)this.items.get(pIndex);
        boolean flag = !pStack.func_190926_b() && pStack.func_77969_a(itemstack) && ItemStack.func_77970_a((ItemStack)pStack, (ItemStack)itemstack);
        this.items.set(pIndex, (Object)pStack);
        if (pStack.func_190916_E() > this.func_70297_j_()) {
            pStack.func_190920_e(this.func_70297_j_());
        }
        if (pIndex == 0 && !flag) {
            this.grindingTotalTime = this.getTotalMillingTime();
            this.grindingProgress = 0;
            this.func_70296_d();
        }
    }

    public boolean func_70300_a(PlayerEntity pPlayer) {
        if (this.field_145850_b.func_175625_s(this.field_174879_c) != this) {
            return false;
        }
        return pPlayer.func_70092_e((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5) <= 64.0;
    }

    public void func_174888_l() {
        this.items.clear();
    }

    public void func_193056_a(@Nullable IRecipe<?> pRecipe) {
        if (pRecipe != null) {
            ResourceLocation resourcelocation = pRecipe.func_199560_c();
            this.recipesUsed.addTo((Object)resourcelocation, 1);
        }
    }

    @Nullable
    public IRecipe<?> func_193055_i() {
        return null;
    }

    public void func_201560_d(PlayerEntity pPlayer) {
    }

    public void awardUsedRecipesAndPopExperience(PlayerEntity p_235645_1_) {
        List<IRecipe<?>> list = this.getRecipesToAwardAndPopExperience(p_235645_1_.field_70170_p, p_235645_1_.func_213303_ch());
        p_235645_1_.func_195065_a(list);
        this.recipesUsed.clear();
    }

    public List<IRecipe<?>> getRecipesToAwardAndPopExperience(World p_235640_1_, Vector3d p_235640_2_) {
        ArrayList list = Lists.newArrayList();
        for (Object2IntMap.Entry entry : this.recipesUsed.object2IntEntrySet()) {
            p_235640_1_.func_199532_z().func_215367_a((ResourceLocation)entry.getKey()).ifPresent(p_235642_4_ -> {
                list.add(p_235642_4_);
                ExtendedGrinderTileEntity.createExperience(p_235640_1_, p_235640_2_, entry.getIntValue(), ((ExtendeGrinderRecipe)p_235642_4_).getExperience());
            });
        }
        return list;
    }

    private static void createExperience(World p_235641_0_, Vector3d p_235641_1_, int p_235641_2_, float p_235641_3_) {
        int i = MathHelper.func_76141_d((float)((float)p_235641_2_ * p_235641_3_));
        float f = MathHelper.func_226164_h_((float)((float)p_235641_2_ * p_235641_3_));
        if (f != 0.0f && Math.random() < (double)f) {
            ++i;
        }
        while (i > 0) {
            int j = ExperienceOrbEntity.func_70527_a((int)i);
            i -= j;
            p_235641_0_.func_217376_c((Entity)new ExperienceOrbEntity(p_235641_0_, p_235641_1_.field_72450_a, p_235641_1_.field_72448_b, p_235641_1_.field_72449_c, j));
        }
    }

    public void func_194018_a(RecipeItemHelper pHelper) {
        for (ItemStack itemstack : this.items) {
            pHelper.func_194112_a(itemstack);
        }
    }

    public <T> LazyOptional<T> getCapability(Capability<T> capability, @Nullable Direction facing) {
        if (!this.field_145846_f && facing != null && capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            if (facing == Direction.UP) {
                return this.handlers[0].cast();
            }
            if (facing == Direction.DOWN) {
                return this.handlers[1].cast();
            }
            return this.handlers[2].cast();
        }
        return super.getCapability(capability, facing);
    }

    protected void invalidateCaps() {
        super.invalidateCaps();
        for (LazyOptional<? extends IItemHandler> handler : this.handlers) {
            handler.invalidate();
        }
    }

    protected ITextComponent func_213907_g() {
        return new TranslationTextComponent("container.lotrextended.stone_grinder");
    }

    protected Container func_213906_a(int pId, PlayerInventory pPlayer) {
        return new ExtendedGrinderContainer(pId, pPlayer, (IInventory)this, this.dataAccess, null);
    }
}

