/*
 * Decompiled with CFR 0.152.
 */
package com.github.maximuslotro.lotrrextended.common.tileentity;

import com.github.maximuslotro.lotrrextended.ExtendedLog;
import com.github.maximuslotro.lotrrextended.common.bannerprotection.whitelist.ExtendedBannerProfileBase;
import com.github.maximuslotro.lotrrextended.common.bannerprotection.whitelist.ExtendedBannerProfileFellowship;
import com.github.maximuslotro.lotrrextended.common.bannerprotection.whitelist.ExtendedBannerProfilePlayer;
import com.github.maximuslotro.lotrrextended.common.block.ExtendedMEBannerBlock;
import com.github.maximuslotro.lotrrextended.common.entity.special.ExtendedBannerEntity;
import com.github.maximuslotro.lotrrextended.common.enums.BannerPermission;
import com.github.maximuslotro.lotrrextended.common.enums.BannerProtectionLevel;
import com.github.maximuslotro.lotrrextended.common.enums.BannerProtectionType;
import com.github.maximuslotro.lotrrextended.common.enums.BannerTypes;
import com.github.maximuslotro.lotrrextended.common.network.ExtendedSBannerOpenChangedScreenPacket;
import com.github.maximuslotro.lotrrextended.common.utils.AxisAlignedBBUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.Predicate;
import lotr.common.data.ExtendedFellowshipDataModule;
import lotr.common.data.ExtendedLOTRPlayerData;
import lotr.common.data.LOTRLevelData;
import lotr.common.fac.FactionPointer;
import lotr.common.fac.FactionPointers;
import lotr.common.fellowship.ExtendedFellowship;
import lotr.common.init.ExtendedEntities;
import lotr.common.init.ExtendedTileEntities;
import lotr.common.init.LOTRBlocks;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.state.properties.DoubleBlockHalf;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.Util;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraftforge.common.UsernameCache;
import net.minecraftforge.fml.server.ServerLifecycleHooks;

public class ExtendedMEBannerTileEntity
extends TileEntity
implements ITickableTileEntity {
    private boolean isActiveHalf = false;
    private List<ProtectionEntry> protectionWhitelist = new ArrayList<ProtectionEntry>();
    private float alignmentLevel = 1.0f;
    private BannerProtectionType protectionType = BannerProtectionType.FACTION;
    private List<BannerPermission> defaultPerms = new ArrayList<BannerPermission>();
    private boolean canProtectSelf = true;
    private boolean used = false;
    private UUID placedPlayerUUID;
    private String placedPlayerName;
    private UUID connectedEntity;
    private BannerProtectionLevel protectionLevel = BannerProtectionLevel.NONE;

    public ExtendedMEBannerTileEntity() {
        super((TileEntityType)ExtendedTileEntities.BANNER_STANDING.get());
    }

    public void func_73660_a() {
        boolean bl = this.isActiveHalf = this.func_195044_w().func_177229_b(ExtendedMEBannerBlock.HALF) == DoubleBlockHalf.LOWER;
        if (this.isActiveHalf) {
            this.setProtectionLevelFromBelowBlock();
            if (this.isProtecting()) {
                if (this.connectedEntity == null) {
                    this.createAndSetBannerEntity();
                } else {
                    Predicate<ExtendedBannerEntity> pred;
                    AxisAlignedBB checkBox = AxisAlignedBBUtils.makeCroppedBB(this.func_174877_v());
                    List banners = this.field_145850_b.func_175647_a(ExtendedBannerEntity.class, checkBox, pred = bannerEntity -> bannerEntity.func_110124_au().equals(this.connectedEntity));
                    if (banners.size() <= 0) {
                        this.createAndSetBannerEntity();
                    } else if (banners.size() > 1) {
                        for (ExtendedBannerEntity banner : banners) {
                            banner.func_70106_y();
                        }
                        this.createAndSetBannerEntity();
                    }
                }
            }
        }
    }

    private void setProtectionLevelFromBelowBlock() {
        BlockState belowBlockstate = this.field_145850_b.func_180495_p(this.func_174877_v().func_177977_b());
        if (belowBlockstate.func_203425_a(Blocks.field_150340_R)) {
            this.setProtectionLevel(BannerProtectionLevel.GOLD);
        } else if (belowBlockstate.func_203425_a((Block)LOTRBlocks.SILVER_BLOCK.get())) {
            this.setProtectionLevel(BannerProtectionLevel.SILVER);
        } else if (belowBlockstate.func_203425_a((Block)LOTRBlocks.BRONZE_BLOCK.get())) {
            this.setProtectionLevel(BannerProtectionLevel.BRONZE);
        } else if (belowBlockstate.func_203425_a((Block)LOTRBlocks.COPPER_BLOCK.get())) {
            this.setProtectionLevel(BannerProtectionLevel.COPPER);
        } else {
            this.setProtectionLevel(BannerProtectionLevel.NONE);
        }
    }

    private void createAndSetBannerEntity() {
        EntityType newBannerEntity;
        ExtendedBannerEntity banner;
        if (!this.field_145850_b.field_72995_K && (banner = (ExtendedBannerEntity)(newBannerEntity = (EntityType)ExtendedEntities.BANNER_HOLDER.get()).func_200721_a(this.field_145850_b)) != null) {
            banner.func_174828_a(this.func_174877_v().func_177963_a(0.5, 0.0, 0.5), 0.0f, 0.0f);
            this.field_145850_b.func_217376_c((Entity)banner);
            this.connectedEntity = banner.func_110124_au();
        }
    }

    public boolean isActiveHalf() {
        return this.isActiveHalf;
    }

    public boolean isProtecting() {
        return this.protectionLevel.getProtectionRadius() > 0;
    }

    public int getProtectionRadius() {
        return this.protectionLevel.getProtectionRadius();
    }

    public BannerProtectionLevel getProtectionLevel() {
        return this.protectionLevel;
    }

    public void setProtectionLevel(BannerProtectionLevel protectionLevel) {
        this.protectionLevel = protectionLevel;
        if (protectionLevel.getProtectionRadius() > 0) {
            this.used = true;
        }
    }

    public void setProtectionType(BannerProtectionType protectionType) {
        this.protectionType = protectionType;
    }

    public BannerProtectionType getProtectionType() {
        return this.protectionType;
    }

    public boolean isFactionProtecting() {
        return this.protectionType == BannerProtectionType.FACTION;
    }

    public boolean isWhitelistProtecting() {
        return this.protectionType == BannerProtectionType.PLAYER;
    }

    public FactionPointer getFactionProtcting() {
        Block abstractBlock = this.func_195044_w().func_177230_c();
        if (abstractBlock instanceof ExtendedMEBannerBlock) {
            return ((ExtendedMEBannerBlock)abstractBlock).getBanner().getFaction();
        }
        return FactionPointers.UNALIGNED;
    }

    public float getAlignmentLevel() {
        return this.alignmentLevel;
    }

    public void setAlignmentLevel(float level) {
        this.alignmentLevel = level;
    }

    public UUID getEntityID() {
        return this.connectedEntity;
    }

    public UUID getPlacedPlayerUUID() {
        return this.placedPlayerUUID;
    }

    public String getPlacedPlayerName() {
        if (this.placedPlayerName == null) {
            String lastKnownUsername;
            if (this.placedPlayerUUID == null) {
                this.placedPlayerName = "UNKNOWN";
                return this.placedPlayerName;
            }
            this.placedPlayerName = lastKnownUsername = UsernameCache.getLastKnownUsername((UUID)this.placedPlayerUUID);
            ExtendedLog.warn("Fixed missing banner player username!");
        }
        return this.placedPlayerName;
    }

    public void setPlacedPlayerUUID(UUID placedPlayer) {
        this.placedPlayerUUID = placedPlayer;
    }

    public void setPlacedPlayerName(String placedPlayerName) {
        this.placedPlayerName = placedPlayerName;
    }

    public void setPlacedPlayerNameAndID(UUID placedPlayer, String placedPlayerName) {
        this.setPlacedPlayerUUID(placedPlayer);
        this.setPlacedPlayerName(placedPlayerName);
    }

    public void setDefaultPerms(List<BannerPermission> perms) {
        this.defaultPerms.clear();
        this.defaultPerms.addAll(perms);
    }

    public List<BannerPermission> getDefaultPerms() {
        return this.defaultPerms;
    }

    public boolean hasDefaultPerm(BannerPermission perm) {
        if (perm == BannerPermission.BANNER) {
            return this.defaultPerms.contains((Object)perm);
        }
        return this.defaultPerms.contains((Object)BannerPermission.EVERYTHING) || this.defaultPerms.contains((Object)perm);
    }

    public void setProtectionWhitelist(List<ProtectionEntry> whitelist) {
        this.protectionWhitelist.clear();
        this.protectionWhitelist.addAll(whitelist);
    }

    public List<ProtectionEntry> getProtectionWhitelist() {
        return this.protectionWhitelist;
    }

    public void addWhitelistPlayer(PlayerEntity player) {
        this.protectionWhitelist.add(new ProtectionEntry(new ExtendedBannerProfilePlayer(player.func_110124_au(), player.func_146103_bH().getName())));
    }

    public void addWhitelistPlayerWithPerms(PlayerEntity player, List<BannerPermission> perms) {
        this.protectionWhitelist.add(new ProtectionEntry(new ExtendedBannerProfilePlayer(player.func_110124_au(), player.func_146103_bH().getName())).setPerms(perms));
    }

    public void addWhitelistPlayer(ExtendedFellowship fellowship) {
        this.protectionWhitelist.add(new ProtectionEntry(new ExtendedBannerProfileFellowship(fellowship.getFellowshipId())));
    }

    public void addWhitelistPlayerWithPerms(ExtendedFellowship fellowship, List<BannerPermission> perms) {
        this.protectionWhitelist.add(new ProtectionEntry(new ExtendedBannerProfileFellowship(fellowship.getFellowshipId())).setPerms(perms));
    }

    public boolean isCanProtectSelf() {
        return this.canProtectSelf;
    }

    public void setCanProtectSelf(boolean canProtectSelf) {
        this.canProtectSelf = canProtectSelf;
    }

    public ExtendedSBannerOpenChangedScreenPacket verifyInfo(boolean shouldReturn, ServerPlayerEntity serverPlayer) {
        boolean fixedBroken = false;
        if (this.alignmentLevel <= 0.0f) {
            this.alignmentLevel = 0.1f;
            fixedBroken = true;
        }
        if (this.alignmentLevel > 1000.0f) {
            this.alignmentLevel = 1000.0f;
            fixedBroken = true;
        }
        ArrayList<ProtectionEntry> toRemove = new ArrayList<ProtectionEntry>();
        for (ProtectionEntry entry : this.protectionWhitelist) {
            if (entry.getProfile() instanceof ExtendedBannerProfilePlayer) {
                if (entry.getProfile().getId().equals(Util.field_240973_b_)) {
                    ServerPlayerEntity player = ServerLifecycleHooks.getCurrentServer().func_184103_al().func_152612_a(entry.getProfile().getName());
                    if (player != null) {
                        entry.updateProfile(new ExtendedBannerProfilePlayer(player.func_110124_au(), player.func_146103_bH().getName()));
                        fixedBroken = true;
                        continue;
                    }
                    boolean foundPlayer = false;
                    for (Map.Entry profile : UsernameCache.getMap().entrySet()) {
                        if (!((String)profile.getValue()).equals(entry.getProfile().getName())) continue;
                        entry.updateProfile(new ExtendedBannerProfilePlayer((UUID)profile.getKey(), entry.getProfile().getName()));
                        foundPlayer = true;
                        fixedBroken = true;
                        break;
                    }
                    if (foundPlayer) continue;
                    toRemove.add(entry);
                    continue;
                }
                String lastKnownUsername = UsernameCache.getLastKnownUsername((UUID)entry.getProfile().getId());
                if (lastKnownUsername.equals(entry.getProfile().getName())) continue;
                entry.updateProfile(new ExtendedBannerProfilePlayer(entry.getProfile().getId(), lastKnownUsername));
                fixedBroken = true;
                continue;
            }
            if (!(entry.getProfile() instanceof ExtendedBannerProfileFellowship)) continue;
            if (entry.getProfile().getId().equals(Util.field_240973_b_) && serverPlayer != null) {
                ExtendedFellowshipDataModule fellowshipModule = ((ExtendedLOTRPlayerData)LOTRLevelData.getSidedData((PlayerEntity)serverPlayer)).getFellowshipData();
                if (fellowshipModule.anyMatchingFellowshipNames(entry.getProfile().getName())) {
                    ExtendedFellowship fellow = fellowshipModule.getFellowshipByName(entry.getProfile().getName());
                    entry.updateProfile(new ExtendedBannerProfileFellowship(fellow.getFellowshipId()));
                    fixedBroken = true;
                    continue;
                }
                toRemove.add(entry);
                continue;
            }
            if (entry.getProfile().isValid()) continue;
            toRemove.add(entry);
        }
        if (!toRemove.isEmpty()) {
            this.protectionWhitelist.removeAll(toRemove);
            fixedBroken = true;
        }
        if (shouldReturn) {
            return new ExtendedSBannerOpenChangedScreenPacket(this);
        }
        return null;
    }

    public void func_230337_a_(BlockState blockState, CompoundNBT pCompound) {
        super.func_230337_a_(blockState, pCompound);
        this.loadProtectionData(pCompound);
    }

    public void loadProtectionData(CompoundNBT loadableData) {
        if (loadableData.func_74764_b("ProtectionDataUnique") && loadableData.func_74764_b("connectedEntity")) {
            this.connectedEntity = loadableData.func_186857_a("connectedEntity");
        }
        if (loadableData.func_74764_b("ProtectionData")) {
            CompoundNBT pCompound = loadableData.func_74775_l("ProtectionData");
            this.protectionType = BannerProtectionType.getByID(pCompound.func_74762_e("protectionType"));
            this.used = true;
            if (pCompound.func_74764_b("placedPlayer")) {
                this.placedPlayerUUID = pCompound.func_186857_a("placedPlayer");
            }
            if (pCompound.func_74764_b("placedPlayerName")) {
                this.placedPlayerName = pCompound.func_74779_i("placedPlayerName");
            }
            if (pCompound.func_74764_b("alignmentThreshold")) {
                this.alignmentLevel = pCompound.func_74760_g("alignmentThreshold");
            }
            if (pCompound.func_74764_b("whitelistEntrys")) {
                ListNBT whitelist = pCompound.func_150295_c("whitelistEntrys", 10);
                for (int i = 0; i < whitelist.size(); ++i) {
                    ProtectionEntry entry;
                    CompoundNBT node = whitelist.func_150305_b(i);
                    if (node == null || (entry = ProtectionEntry.fromNBT(node)) == null) continue;
                    this.protectionWhitelist.add(entry);
                }
            }
            if (pCompound.func_150297_b("defaultPerms", 7)) {
                byte[] ordinalValues = pCompound.func_74770_j("perms");
                this.defaultPerms.clear();
                for (byte ordinal : ordinalValues) {
                    this.defaultPerms.add(BannerPermission.values[ordinal]);
                }
                if (this.defaultPerms.contains((Object)BannerPermission.EVERYTHING)) {
                    this.defaultPerms.removeIf(permission -> permission != BannerPermission.BANNER && permission != BannerPermission.EVERYTHING);
                }
            }
            if (pCompound.func_74764_b("protectionSelf")) {
                this.canProtectSelf = pCompound.func_74767_n("protectionSelf");
            }
            if (pCompound.func_74764_b("used")) {
                this.used = pCompound.func_74767_n("used");
            }
        }
    }

    public CompoundNBT func_189515_b(CompoundNBT pCompound) {
        super.func_189515_b(pCompound);
        CompoundNBT pUniqueCompound = new CompoundNBT();
        if (this.connectedEntity != null) {
            pUniqueCompound.func_186854_a("connectedEntity", this.connectedEntity);
        }
        if (!pUniqueCompound.isEmpty()) {
            pCompound.func_218657_a("ProtectionDataUnique", (INBT)pUniqueCompound);
        }
        this.saveProtectionData(pCompound);
        return pCompound;
    }

    public CompoundNBT saveProtectionData(CompoundNBT returnCompound) {
        if (this.used) {
            CompoundNBT pCompound = new CompoundNBT();
            pCompound.func_74768_a("protectionType", this.protectionType.getId());
            pCompound.func_74757_a("used", this.used);
            if (this.alignmentLevel != 1.0f) {
                pCompound.func_74776_a("alignmentThreshold", this.alignmentLevel);
            }
            if (this.placedPlayerUUID != null) {
                pCompound.func_186854_a("placedPlayer", this.placedPlayerUUID);
            }
            if (this.placedPlayerName != null) {
                pCompound.func_74778_a("placedPlayerName", this.placedPlayerName);
            }
            if (!this.protectionWhitelist.isEmpty()) {
                ListNBT whitelist = new ListNBT();
                for (ProtectionEntry protectionWWhitelist : this.protectionWhitelist) {
                    whitelist.add((Object)protectionWWhitelist.save());
                }
                pCompound.func_218657_a("whitelistEntrys", (INBT)whitelist);
            }
            if (!this.defaultPerms.isEmpty()) {
                byte[] ordinalValues = new byte[this.defaultPerms.size()];
                for (int i = 0; i < this.defaultPerms.size(); ++i) {
                    ordinalValues[i] = (byte)this.defaultPerms.get(i).ordinal();
                }
                pCompound.func_74773_a("defaultPerms", ordinalValues);
            }
            if (!this.canProtectSelf) {
                pCompound.func_74757_a("protectionSelf", this.canProtectSelf);
            }
            returnCompound.func_218657_a("ProtectionData", (INBT)pCompound);
        }
        return returnCompound;
    }

    public ItemStack getItem(BannerTypes bannerType) {
        ItemStack itemstack = new ItemStack((IItemProvider)bannerType.getBannerItem().get());
        if (this.used) {
            this.saveProtectionData(itemstack.func_196082_o());
        }
        return itemstack;
    }

    public static class ProtectionEntry {
        private List<BannerPermission> entryPerms = new ArrayList<BannerPermission>();
        private ExtendedBannerProfileBase profile;

        public ProtectionEntry(ExtendedBannerProfileBase profile) {
            this.profile = profile;
        }

        public ProtectionEntry setPerms(List<BannerPermission> perms) {
            this.entryPerms = perms;
            return this;
        }

        public ProtectionEntry addPerm(BannerPermission perm) {
            this.entryPerms.add(perm);
            return this;
        }

        public boolean containsPermissionNode(BannerPermission permission) {
            return this.entryPerms.contains((Object)permission);
        }

        public boolean hasPermission(BannerPermission permission) {
            if (permission == BannerPermission.BANNER) {
                return this.containsPermissionNode(permission);
            }
            return this.entryPerms.contains((Object)BannerPermission.EVERYTHING) || this.containsPermissionNode(permission);
        }

        public ExtendedBannerProfileBase getProfile() {
            return this.profile;
        }

        public void updateProfile(ExtendedBannerProfileBase newProfile) {
            this.profile = newProfile;
        }

        public List<BannerPermission> getEntryPerms() {
            return this.entryPerms;
        }

        public CompoundNBT save() {
            CompoundNBT data = new CompoundNBT();
            if (!this.entryPerms.isEmpty()) {
                byte[] ordinalValues = new byte[this.entryPerms.size()];
                for (int i = 0; i < this.entryPerms.size(); ++i) {
                    ordinalValues[i] = (byte)this.entryPerms.get(i).ordinal();
                }
                data.func_74773_a("perms", ordinalValues);
            }
            this.profile.writeGameProfile(data);
            return data;
        }

        public static ProtectionEntry fromNBT(CompoundNBT nbt) {
            ExtendedBannerProfileBase type;
            ArrayList<BannerPermission> entryPerms = new ArrayList<BannerPermission>();
            if (nbt.func_150297_b("perms", 7)) {
                byte[] ordinalValues;
                for (byte ordinal : ordinalValues = nbt.func_74770_j("perms")) {
                    entryPerms.add(BannerPermission.values[ordinal]);
                }
            }
            if (entryPerms.contains((Object)BannerPermission.EVERYTHING)) {
                entryPerms.removeIf(permission -> permission != BannerPermission.BANNER && permission != BannerPermission.EVERYTHING);
            }
            if ("player".equals(nbt.func_74779_i("type"))) {
                type = ExtendedBannerProfilePlayer.readGameProfile(nbt);
            } else if ("fellowship".equals(nbt.func_74779_i("type"))) {
                type = ExtendedBannerProfileFellowship.readGameProfile(nbt);
            } else {
                ExtendedLog.error("Read an unknown ExtendedBannerProfileBase data type!");
                ExtendedLog.error("The following data has been removed from the banner: " + nbt.toString());
                ExtendedLog.error("PLEASE REPORT THIS!");
                return null;
            }
            if (type == null || !((ExtendedBannerProfileBase)type).isValid()) {
                return null;
            }
            ProtectionEntry entry = new ProtectionEntry(type);
            entry.setPerms(entryPerms);
            return entry;
        }
    }
}

