/*
 * Decompiled with CFR 0.152.
 */
package com.github.maximuslotro.lotrrextended.common.tileentity;

import com.github.maximuslotro.lotrrextended.ExtendedLog;
import com.github.maximuslotro.lotrrextended.common.config.ExtendedServerConfig;
import java.util.List;
import javax.annotation.Nullable;
import lotr.common.init.ExtendedTileEntities;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.loot.LootContext;
import net.minecraft.loot.LootParameterSets;
import net.minecraft.loot.LootParameters;
import net.minecraft.loot.LootTable;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.LockableLootTileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.server.ServerWorld;

public class ExtendedWeaponRackTileEntity
extends LockableLootTileEntity
implements ITickableTileEntity {
    private static final String tagName = "extended_ditem";
    private ItemStack containedItem = ItemStack.field_190927_a;
    private boolean ticked = false;

    public ExtendedWeaponRackTileEntity() {
        super((TileEntityType)ExtendedTileEntities.WEAPON_RACK.get());
    }

    public void func_73660_a() {
        if (!((Boolean)ExtendedServerConfig.enableDevMode.get()).booleanValue() && this.field_184284_m != null && !this.field_145850_b.field_72995_K && this.playerInDistance() && !this.ticked) {
            this.ticked = true;
            this.func_184281_d(null);
            this.markAndUpdate();
        }
    }

    private boolean playerInDistance() {
        return this.field_145850_b.func_217358_a((double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), 50.0);
    }

    public void func_70296_d() {
        super.func_70296_d();
    }

    public void func_230337_a_(BlockState p_230337_1_, CompoundNBT nbt) {
        super.func_230337_a_(p_230337_1_, nbt);
        if (this.func_184283_b(nbt)) {
            this.containedItem = ItemStack.field_190927_a;
        } else if (nbt.func_150297_b(tagName, 10)) {
            this.containedItem = ItemStack.func_199557_a((CompoundNBT)nbt.func_74775_l(tagName));
            if (this.containedItem == null) {
                ExtendedLog.warn("Weapon Rack Loaded with a null Item, this should not happen. All Contained Items Have been lost!");
                this.containedItem = ItemStack.field_190927_a;
                this.markAndUpdate();
            }
        }
    }

    public CompoundNBT func_189515_b(CompoundNBT nbt) {
        super.func_189515_b(nbt);
        if (!this.func_184282_c(nbt)) {
            if (this.containedItem == null) {
                ExtendedLog.warn("Weapon Rack failed to save as contained item is NULL! This should not happen. All Contained Items Have been lost!");
                this.containedItem = ItemStack.field_190927_a;
                this.markAndUpdate();
            }
            nbt.func_218657_a(tagName, (INBT)this.containedItem.func_77955_b(new CompoundNBT()));
        }
        return nbt;
    }

    @Nullable
    public SUpdateTileEntityPacket func_189518_D_() {
        return new SUpdateTileEntityPacket(this.field_174879_c, 12, this.func_189517_E_());
    }

    public CompoundNBT func_189517_E_() {
        return this.func_189515_b(new CompoundNBT());
    }

    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket pkt) {
        super.onDataPacket(net, pkt);
        this.func_230337_a_(this.field_145850_b.func_180495_p(pkt.func_179823_a()), pkt.func_148857_g());
    }

    public void handleUpdateTag(BlockState state, CompoundNBT tag) {
        super.handleUpdateTag(state, tag);
    }

    public boolean func_145842_c(int id, int type) {
        return super.func_145842_c(id, type);
    }

    public void markAndUpdate() {
        this.func_70296_d();
        if (this.func_145830_o()) {
            this.func_145831_w().func_184138_a(this.func_174877_v(), this.func_195044_w(), this.func_195044_w(), 3);
        }
    }

    public boolean hasItem() {
        return this.containedItem != null && !this.containedItem.func_190926_b();
    }

    public ItemStack getContainedItem() {
        if (this.containedItem == null) {
            ExtendedLog.warn("Weapon Rack contains a null Item, this should not happen. All Contained Items Have been lost!");
            this.containedItem = ItemStack.field_190927_a;
            this.markAndUpdate();
        }
        return this.containedItem;
    }

    public void setContainedItem(ItemStack containedItem) {
        this.containedItem = containedItem;
        if (containedItem == null) {
            ExtendedLog.warn("Tried Setting a NULL item to a Weapon Rack, correcting to ItemStack.EMPTY!");
            containedItem = ItemStack.field_190927_a;
        }
        this.markAndUpdate();
    }

    public int func_70302_i_() {
        return 1;
    }

    protected NonNullList<ItemStack> func_190576_q() {
        return NonNullList.func_191197_a((int)1, (Object)(this.containedItem == null ? ItemStack.field_190927_a : this.containedItem));
    }

    protected void func_199721_a(NonNullList<ItemStack> list) {
        if (list.size() >= 1) {
            this.containedItem = (ItemStack)list.get(0);
        }
    }

    protected ITextComponent func_213907_g() {
        return new StringTextComponent("Weapon Rack Secret Lounge");
    }

    protected Container func_213906_a(int p_213906_1_, PlayerInventory p_213906_2_) {
        return null;
    }

    public void func_184281_d(@Nullable PlayerEntity p_184281_1_) {
        try {
            if (this.field_184284_m != null && this.field_145850_b.func_73046_m() != null) {
                List list;
                LootTable loottable = this.field_145850_b.func_73046_m().func_200249_aQ().func_186521_a(this.field_184284_m);
                if (p_184281_1_ instanceof ServerPlayerEntity) {
                    CriteriaTriggers.field_232608_N_.func_235478_a_((ServerPlayerEntity)p_184281_1_, this.field_184284_m);
                }
                this.field_184284_m = null;
                LootContext.Builder lootcontext$builder = new LootContext.Builder((ServerWorld)this.field_145850_b).func_216015_a(LootParameters.field_237457_g_, (Object)Vector3d.func_237489_a_((Vector3i)this.field_174879_c)).func_216016_a(this.field_184285_n);
                if (p_184281_1_ != null) {
                    lootcontext$builder.func_186469_a(p_184281_1_.func_184817_da()).func_216015_a(LootParameters.field_216281_a, (Object)p_184281_1_);
                }
                if ((list = loottable.func_216113_a(lootcontext$builder.func_216022_a(LootParameterSets.field_216261_b))).size() > 0) {
                    ItemStack stack = (ItemStack)list.get(0);
                    stack.func_190920_e(1);
                    this.setContainedItem(stack);
                }
            }
        }
        catch (NullPointerException e) {
            ExtendedLog.error("Caught a null-pointer exception while unpacking weapon rack loot-table");
            ExtendedLog.error("Location: " + this.field_184284_m.toString() + ", Pos: " + this.func_174877_v().toString());
            e.printStackTrace();
            ExtendedLog.error("Please report this if it happens again");
        }
    }
}

