/*
 * Decompiled with CFR 0.152.
 */
package com.github.maximuslotro.lotrrextended.common.utils;

import com.github.maximuslotro.lotrrextended.ExtendedLog;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.UUID;
import lotr.common.block.LOTRTorchBlock;
import lotr.common.block.LOTRWallTorchBlock;
import lotr.common.data.PlayerDataModule;

public class ExtendedReflectionHelper {
    public static UUID getAlignmentData(PlayerDataModule data) {
        UUID underlyingPlayerUUID = null;
        try {
            Method fooMethod = PlayerDataModule.class.getDeclaredMethod("getPlayerUUID", new Class[0]);
            fooMethod.setAccessible(true);
            underlyingPlayerUUID = (UUID)fooMethod.invoke((Object)data, new Object[0]);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            e.printStackTrace();
            ExtendedLog.error("Reflection failed to get PlayerDataModule UUID");
        }
        return underlyingPlayerUUID;
    }

    public static void setTorchValues(Object obj, LOTRTorchBlock copyFromBlock) {
        try {
            Field privateField = LOTRWallTorchBlock.class.getDeclaredField("torchParticles");
            privateField.setAccessible(true);
            privateField.set(obj, copyFromBlock.copyTorchParticles());
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException e) {
            ExtendedLog.error("Reflection failed to set torchParticles for ExtendedLOTRWallTorchBlock, of type " + copyFromBlock.getRegistryName().toString());
        }
    }

    public static String getStringFieldFromClass(Class<?> classThing, Object obj, String fieldName) {
        String data = null;
        try {
            Field field = classThing.getDeclaredField(fieldName);
            boolean isAccessable = field.isAccessible();
            if (!isAccessable) {
                field.setAccessible(true);
            }
            data = (String)field.get(obj);
            if (!isAccessable) {
                field.setAccessible(false);
            }
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException e) {
            e.printStackTrace();
            ExtendedLog.error("Reflection failed to get " + classThing.getName() + " String field: " + fieldName);
        }
        return data;
    }

    public static Boolean getBooleanFieldFromClass(Class<?> classThing, Object obj, String fieldName) {
        Boolean data = null;
        try {
            Field field = classThing.getDeclaredField(fieldName);
            boolean isAccessable = field.isAccessible();
            if (!isAccessable) {
                field.setAccessible(true);
            }
            data = (boolean)((Boolean)field.get(obj));
            if (!isAccessable) {
                field.setAccessible(false);
            }
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException e) {
            e.printStackTrace();
            ExtendedLog.error("Reflection failed to get " + classThing.getName() + " Boolean field: " + fieldName);
        }
        return data;
    }
}

