/*
 * Decompiled with CFR 0.152.
 */
package com.github.maximuslotro.lotrrextended.common.world.gen.feature;

import com.github.maximuslotro.lotrrextended.common.world.gen.placement.ExtendedCaveSurface;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Random;
import java.util.function.Supplier;
import net.minecraft.block.Block;
import net.minecraft.tags.ITag;
import net.minecraft.tags.TagCollectionManager;
import net.minecraft.world.gen.blockstateprovider.BlockStateProvider;
import net.minecraft.world.gen.feature.ConfiguredFeature;
import net.minecraft.world.gen.feature.IFeatureConfig;

public class ExtendedVegetationPatchConfig
implements IFeatureConfig {
    public static final Codec<ExtendedVegetationPatchConfig> CODEC = RecordCodecBuilder.create(p_161304_ -> p_161304_.group((App)ITag.func_232947_a_(() -> TagCollectionManager.func_242178_a().func_241835_a()).fieldOf("tag").forGetter(p_204869_ -> p_204869_.replaceable), (App)BlockStateProvider.field_236796_a_.fieldOf("ground_state").forGetter(p_161322_ -> p_161322_.groundState), (App)ConfiguredFeature.field_236264_b_.fieldOf("vegetation_feature").forGetter(p_236494_0_ -> p_236494_0_.vegetationFeature), (App)ExtendedCaveSurface.CODEC.fieldOf("surface").forGetter(p_161318_ -> p_161318_.surface), (App)Codec.intRange((int)1, (int)4).fieldOf("depth").forGetter(p_161316_ -> p_161316_.depth), (App)Codec.floatRange((float)0.0f, (float)1.0f).fieldOf("extra_bottom_block_chance").forGetter(p_161314_ -> Float.valueOf(p_161314_.extraBottomBlockChance)), (App)Codec.intRange((int)1, (int)256).fieldOf("vertical_range").forGetter(p_161312_ -> p_161312_.verticalRange), (App)Codec.floatRange((float)0.0f, (float)1.0f).fieldOf("vegetation_chance").forGetter(p_161310_ -> Float.valueOf(p_161310_.vegetationChance)), (App)Codec.intRange((int)1, (int)256).fieldOf("xz_radius_min").forGetter(p_161312_ -> p_161312_.xzRadiusMin), (App)Codec.intRange((int)1, (int)256).fieldOf("xz_radius_max").forGetter(p_161312_ -> p_161312_.xzRadiusMax), (App)Codec.floatRange((float)0.0f, (float)1.0f).fieldOf("extra_edge_column_chance").forGetter(p_161306_ -> Float.valueOf(p_161306_.extraEdgeColumnChance)), (App)Codec.floatRange((float)0.0f, (float)1.0f).fieldOf("discard_block_chance").forGetter(p_161306_ -> Float.valueOf(p_161306_.discardBlockChance))).apply((Applicative)p_161304_, ExtendedVegetationPatchConfig::new));
    public final ITag<Block> replaceable;
    public final BlockStateProvider groundState;
    public final Supplier<ConfiguredFeature<?, ?>> vegetationFeature;
    public final ExtendedCaveSurface surface;
    public final int depth;
    public final float extraBottomBlockChance;
    public final int verticalRange;
    public final float vegetationChance;
    public final int xzRadiusMin;
    public final int xzRadiusMax;
    public final float extraEdgeColumnChance;
    public final float discardBlockChance;

    public ExtendedVegetationPatchConfig(ITag<Block> replaceable, BlockStateProvider groundState, Supplier<ConfiguredFeature<?, ?>> vegetationFeature, ExtendedCaveSurface surface, int depth, float extraBottomBlockChance, int verticalRange, float vegetationChance, int xzRadiusMin, int xzRadiusMax, float extraEdgeColumnChance, float discardBlockChance) {
        this.replaceable = replaceable;
        this.groundState = groundState;
        this.vegetationFeature = vegetationFeature;
        this.surface = surface;
        this.depth = depth;
        this.extraBottomBlockChance = extraBottomBlockChance;
        this.verticalRange = verticalRange;
        this.vegetationChance = vegetationChance;
        this.xzRadiusMin = xzRadiusMin;
        this.xzRadiusMax = xzRadiusMax;
        this.extraEdgeColumnChance = extraEdgeColumnChance;
        this.discardBlockChance = discardBlockChance;
    }

    public int samplexzRadius(Random random) {
        return random.nextInt(this.xzRadiusMax - this.xzRadiusMin + 1) + this.xzRadiusMin;
    }

    public boolean shouldUseBlock(Random random) {
        return this.discardBlockChance == 0.0f ? true : random.nextFloat() > this.discardBlockChance;
    }
}

