/*
 * Decompiled with CFR 0.152.
 */
package com.github.maximuslotro.lotrrextended.common.world.gen.feature;

import com.github.maximuslotro.lotrrextended.common.world.gen.feature.ExtendedVegetationPatchConfig;
import com.mojang.serialization.Codec;
import java.util.HashSet;
import java.util.Random;
import java.util.Set;
import java.util.function.Predicate;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.BlockState;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.feature.Feature;

public class ExtendedVegetationPatchFeature
extends Feature<ExtendedVegetationPatchConfig> {
    public ExtendedVegetationPatchFeature(Codec<ExtendedVegetationPatchConfig> p_160588_) {
        super(p_160588_);
    }

    public boolean place(ISeedReader worldgenlevel, ChunkGenerator chunkGenerator, Random random, BlockPos blockpos, ExtendedVegetationPatchConfig vegetationpatchconfiguration) {
        Predicate<BlockState> predicate = blockState -> blockState.func_235714_a_(vegetationpatchconfiguration.replaceable);
        int i = vegetationpatchconfiguration.samplexzRadius(random) + 1;
        int j = vegetationpatchconfiguration.samplexzRadius(random) + 1;
        Set<BlockPos> set = this.placeGroundPatch(worldgenlevel, vegetationpatchconfiguration, random, blockpos, predicate, i, j);
        this.distributeVegetation(chunkGenerator, worldgenlevel, vegetationpatchconfiguration, random, set, i, j);
        return !set.isEmpty();
    }

    protected Set<BlockPos> placeGroundPatch(ISeedReader worldgenlevel, ExtendedVegetationPatchConfig vegetationpatchconfiguration, Random random, BlockPos pBlockpos, Predicate<BlockState> predicate, int pI, int pJ) {
        BlockPos.Mutable blockpos$mutableblockpos = pBlockpos.func_239590_i_();
        BlockPos.Mutable blockpos$mutableblockpos1 = blockpos$mutableblockpos.func_239590_i_();
        Direction direction = vegetationpatchconfiguration.surface.getDirection();
        Direction direction1 = direction.func_176734_d();
        HashSet<BlockPos> set = new HashSet<BlockPos>();
        for (int i = -pI; i <= pI; ++i) {
            boolean isXbounds = i == -pI || i == pI;
            for (int j = -pJ; j <= pJ; ++j) {
                boolean isOnlyNotBothBounds;
                boolean isZbounds = j == -pJ || j == pJ;
                boolean isSomeBounds = isXbounds || isZbounds;
                boolean isBothBounds = isXbounds && isZbounds;
                boolean bl = isOnlyNotBothBounds = isSomeBounds && !isBothBounds;
                if (isBothBounds || isOnlyNotBothBounds && (vegetationpatchconfiguration.extraEdgeColumnChance == 0.0f || random.nextFloat() > vegetationpatchconfiguration.extraEdgeColumnChance)) continue;
                blockpos$mutableblockpos.func_239621_a_((Vector3i)pBlockpos, i, 0, j);
                for (int k = 0; worldgenlevel.func_217375_a((BlockPos)blockpos$mutableblockpos, AbstractBlock.AbstractBlockState::func_196958_f) && k < vegetationpatchconfiguration.verticalRange; ++k) {
                    blockpos$mutableblockpos.func_189536_c(direction);
                }
                for (int i1 = 0; worldgenlevel.func_217375_a((BlockPos)blockpos$mutableblockpos, p_204784_ -> !p_204784_.func_196958_f()) && i1 < vegetationpatchconfiguration.verticalRange; ++i1) {
                    blockpos$mutableblockpos.func_189536_c(direction1);
                }
                blockpos$mutableblockpos1.func_239622_a_((Vector3i)blockpos$mutableblockpos, vegetationpatchconfiguration.surface.getDirection());
                BlockState blockstate = worldgenlevel.func_180495_p((BlockPos)blockpos$mutableblockpos1);
                if (!worldgenlevel.func_175623_d((BlockPos)blockpos$mutableblockpos) || !blockstate.func_224755_d((IBlockReader)worldgenlevel, (BlockPos)blockpos$mutableblockpos1, vegetationpatchconfiguration.surface.getDirection().func_176734_d())) continue;
                int l = vegetationpatchconfiguration.depth + (vegetationpatchconfiguration.extraBottomBlockChance > 0.0f && random.nextFloat() < vegetationpatchconfiguration.extraBottomBlockChance ? 1 : 0);
                BlockPos blockpos = blockpos$mutableblockpos1.func_185334_h();
                boolean flag5 = this.placeGround(worldgenlevel, vegetationpatchconfiguration, predicate, random, blockpos$mutableblockpos1, l);
                if (!flag5) continue;
                set.add(blockpos);
            }
        }
        return set;
    }

    private void distributeVegetation(ChunkGenerator chunkGenerator, ISeedReader worldgenlevel, ExtendedVegetationPatchConfig config, Random random, Set<BlockPos> blockLists, int p_160619_, int p_160620_) {
        for (BlockPos blockpos : blockLists) {
            if (!(config.vegetationChance > 0.0f) || !(random.nextFloat() < config.vegetationChance)) continue;
            this.placeVegetation(worldgenlevel, config, chunkGenerator, random, blockpos);
        }
    }

    private boolean placeVegetation(ISeedReader worldgenlevel, ExtendedVegetationPatchConfig config, ChunkGenerator chunkGenerator, Random random, BlockPos blockPos) {
        return config.vegetationFeature.get().func_242765_a(worldgenlevel, chunkGenerator, random, blockPos.func_177972_a(config.surface.getDirection().func_176734_d()));
    }

    private boolean placeGround(ISeedReader worldgenlevel, ExtendedVegetationPatchConfig config, Predicate<BlockState> predicate, Random random, BlockPos.Mutable blockPosMutable, int p_160610_) {
        for (int i = 0; i < p_160610_; ++i) {
            BlockState blockstate1;
            BlockState blockstate = config.groundState.func_225574_a_(random, (BlockPos)blockPosMutable);
            if (blockstate.func_203425_a((blockstate1 = worldgenlevel.func_180495_p((BlockPos)blockPosMutable)).func_177230_c())) continue;
            if (!predicate.test(blockstate1) || !config.shouldUseBlock(random)) {
                return i != 0;
            }
            worldgenlevel.func_180501_a((BlockPos)blockPosMutable, blockstate, 2);
            blockPosMutable.func_189536_c(config.surface.getDirection());
        }
        return true;
    }
}

