/*
 * Decompiled with CFR 0.152.
 */
package com.github.maximuslotro.lotrrextended.common.world.gen.structure.processor.wood;

import com.github.maximuslotro.lotrrextended.ExtendedLog;
import com.github.maximuslotro.lotrrextended.common.init.ExtendedStructureProcessors;
import com.github.maximuslotro.lotrrextended.common.utils.BlockStateUtils;
import com.github.maximuslotro.lotrrextended.common.world.gen.structure.processor.wood.WoodPallet;
import com.github.maximuslotro.lotrrextended.common.world.gen.structure.processor.wood.WoodPallets;
import com.google.common.collect.Lists;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Map;
import java.util.Random;
import javax.annotation.Nullable;
import lotr.common.block.LOTRBlockStates;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.state.Property;
import net.minecraft.util.Direction;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.gen.feature.template.IStructureProcessorType;
import net.minecraft.world.gen.feature.template.PlacementSettings;
import net.minecraft.world.gen.feature.template.StructureProcessor;
import net.minecraft.world.gen.feature.template.Template;
import net.minecraftforge.registries.ForgeRegistries;

public class WoodPaletteProcessor
extends StructureProcessor {
    public static final Codec<WoodPaletteProcessor> CODEC = RecordCodecBuilder.create(processorInstance -> processorInstance.group((App)Codec.STRING.fieldOf("built_pallet").forGetter(WoodPaletteProcessor::getBasePalletName), (App)Codec.STRING.fieldOf("picked_pallet").orElse((Object)"null").forGetter(WoodPaletteProcessor::getPickedPalletName), (App)Codec.mapPair((MapCodec)Codec.STRING.fieldOf("wood_type"), (MapCodec)Codec.INT.fieldOf("weight")).codec().listOf().promotePartial(Util.func_240982_a_((String)"Pool element: ", ExtendedLog::error)).fieldOf("woodTypes").forGetter(WoodPaletteProcessor::getRawPallets)).apply((Applicative)processorInstance, WoodPaletteProcessor::new));
    private WoodPallet pickedPallet;
    private final WoodPallet basePallet;
    private final List<Pair<String, Integer>> rawPallets;
    public final List<String> pallets;
    private boolean flaged = false;
    private boolean applied = false;

    public WoodPaletteProcessor(String defaultName, String selectedpallet, List<Pair<String, Integer>> rawPallets) {
        this.rawPallets = rawPallets;
        this.pallets = Lists.newArrayList();
        for (Pair<String, Integer> pair : rawPallets) {
            String pallet = (String)pair.getFirst();
            for (int i = 0; i < (Integer)pair.getSecond(); ++i) {
                this.pallets.add(pallet);
            }
        }
        if (!selectedpallet.equals("null")) {
            this.pickedPallet = WoodPallets.getPalletForname(selectedpallet);
        }
        this.basePallet = WoodPallets.getPalletForname(defaultName);
    }

    public boolean isInitialized() {
        return this.pickedPallet != null;
    }

    private WoodPallet getRandomTemplate(Random pRandom) {
        return WoodPallets.getPalletForname(this.pallets.get(pRandom.nextInt(this.pallets.size())));
    }

    public void generateAndSetPallet(Random random) {
        this.pickedPallet = this.getRandomTemplate(random);
    }

    public Template.BlockInfo process(IWorldReader world, BlockPos pos, BlockPos blockPos, Template.BlockInfo blockInfoLocal, Template.BlockInfo blockInfoWorld, PlacementSettings placmentData, @Nullable Template template) {
        if (!this.isInitialized()) {
            ExtendedLog.warn("Needed to set WoodPallet on BlockProcess, this should not happen! Please report this and what you did!");
            this.generateAndSetPallet(placmentData.func_189947_a(blockInfoWorld.field_186242_a));
            if (!this.flaged) {
                IllegalStateException e = new IllegalStateException("WoodPaller set on runTime!");
                e.printStackTrace();
                this.flaged = true;
            }
        }
        if (!this.applied) {
            ExtendedLog.info("Replaceing " + this.basePallet.getName() + " pallet with " + this.pickedPallet.getName());
            this.applied = true;
        }
        if (this.pickedPallet.isEmpty() || this.pickedPallet.equals(this.basePallet)) {
            return blockInfoWorld;
        }
        BlockState blockstate = blockInfoWorld.field_186243_b;
        if (blockstate.func_177230_c().equals(Blocks.field_150350_a)) {
            return blockInfoWorld;
        }
        if (this.basePallet.getBlockMap().containsValue(blockstate.func_177230_c().getRegistryName())) {
            String key = this.getKey(this.basePallet.getBlockMap(), blockstate.func_177230_c().getRegistryName());
            Block pickedBlock = (Block)ForgeRegistries.BLOCKS.getValue(this.pickedPallet.getBlockMap().get(key));
            if ("SLAB_VERT".equals(key) && pickedBlock.equals(Blocks.field_150350_a)) {
                Block newPickedBlock = (Block)ForgeRegistries.BLOCKS.getValue(this.pickedPallet.getBlockMap().get("SLAB"));
                if (pickedBlock.equals(Blocks.field_150350_a)) {
                    return blockInfoWorld;
                }
                pickedBlock = newPickedBlock;
            } else if ("SLAB".equals(key) && blockstate.func_235901_b_((Property)LOTRBlockStates.SLAB_AXIS) && blockstate.func_177229_b((Property)LOTRBlockStates.SLAB_AXIS) != Direction.Axis.Y) {
                Block newPickedBlock = (Block)ForgeRegistries.BLOCKS.getValue(this.pickedPallet.getBlockMap().get("SLAB_VERT"));
                if (pickedBlock.equals(Blocks.field_150350_a)) {
                    return blockInfoWorld;
                }
                pickedBlock = newPickedBlock;
            }
            if (pickedBlock == null) {
                ExtendedLog.error("Found Missing Block in WoodPallet: " + this.pickedPallet.getName() + ", KEY: " + key);
                return blockInfoWorld;
            }
            return new Template.BlockInfo(blockInfoWorld.field_186242_a, BlockStateUtils.copyBlockStateToBlock(pickedBlock, blockstate), (CompoundNBT)null);
        }
        return blockInfoWorld;
    }

    protected IStructureProcessorType<?> func_215192_a() {
        return ExtendedStructureProcessors.WOOD_PALETTE_PROCESSOR;
    }

    @Nullable
    public WoodPallet getPickedPallet() {
        return this.pickedPallet;
    }

    public String getPickedPalletName() {
        if (!this.isInitialized()) {
            return "null";
        }
        return this.pickedPallet.getName();
    }

    public WoodPallet getBasePallet() {
        return this.basePallet;
    }

    public String getBasePalletName() {
        return this.basePallet.getName();
    }

    private <K, V> K getKey(Map<K, V> map, V value) {
        for (Map.Entry<K, V> entry : map.entrySet()) {
            if (!entry.getValue().equals(value)) continue;
            return entry.getKey();
        }
        return null;
    }

    public List<Pair<String, Integer>> getRawPallets() {
        return this.rawPallets;
    }
}

