/*
 * Decompiled with CFR 0.152.
 */
package com.github.maximuslotro.lotrrextended.common.world.gen.structureV5;

import com.github.maximuslotro.lotrrextended.ExtendedLog;
import com.github.maximuslotro.lotrrextended.common.world.gen.structure.processor.wood.WoodPaletteProcessor;
import com.google.common.collect.Lists;
import com.google.common.collect.Queues;
import java.util.ArrayList;
import java.util.Deque;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Random;
import net.minecraft.block.BlockState;
import net.minecraft.block.JigsawBlock;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.util.math.shapes.IBooleanFunction;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.util.registry.DynamicRegistries;
import net.minecraft.util.registry.MutableRegistry;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.feature.jigsaw.EmptyJigsawPiece;
import net.minecraft.world.gen.feature.jigsaw.JigsawJunction;
import net.minecraft.world.gen.feature.jigsaw.JigsawPattern;
import net.minecraft.world.gen.feature.jigsaw.JigsawPatternRegistry;
import net.minecraft.world.gen.feature.jigsaw.JigsawPiece;
import net.minecraft.world.gen.feature.jigsaw.SingleJigsawPiece;
import net.minecraft.world.gen.feature.structure.AbstractVillagePiece;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.gen.feature.structure.VillageConfig;
import net.minecraft.world.gen.feature.template.StructureProcessor;
import net.minecraft.world.gen.feature.template.StructureProcessorList;
import net.minecraft.world.gen.feature.template.Template;
import net.minecraft.world.gen.feature.template.TemplateManager;
import org.apache.commons.lang3.mutable.MutableObject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ExtendedJigsawManager {
    private static final Logger LOGGER = LogManager.getLogger();

    public static void addPieces(DynamicRegistries registry, VillageConfig structureConfig, IPieceFactory villagePieceBuilder, ChunkGenerator chunkGenerator, TemplateManager templateManager, BlockPos blockpos, List<? super AbstractVillagePiece> pieces, Random random, boolean doExpansionHack, boolean projectStartToHeightmap) {
        Structure.func_236397_g_();
        MutableRegistry mutableregistry = registry.func_243612_b(Registry.field_243555_ax);
        Rotation rotation = Rotation.func_222466_a((Random)random);
        JigsawPattern jigsawpattern = (JigsawPattern)structureConfig.func_242810_c().get();
        JigsawPiece jigsawpiece = jigsawpattern.func_214944_a(random);
        Optional<Object> carryOverProcessor = Optional.empty();
        if (jigsawpiece instanceof SingleJigsawPiece) {
            ArrayList<StructureProcessor> processors = new ArrayList<StructureProcessor>(((StructureProcessorList)((SingleJigsawPiece)jigsawpiece).field_214862_b.get()).func_242919_a());
            boolean foundProcessor = false;
            for (StructureProcessor processor : ((StructureProcessorList)((SingleJigsawPiece)jigsawpiece).field_214862_b.get()).func_242919_a()) {
                if (!(processor instanceof WoodPaletteProcessor)) continue;
                if (foundProcessor) {
                    IllegalStateException e = new IllegalStateException("Structure Processor can't have more than one WoodPaletteProcessor instance!");
                    e.printStackTrace();
                    ExtendedLog.info("Error adding wood processor present in " + jigsawpattern.func_214947_b().toString() + " to parent stack! Skipping structure");
                    return;
                }
                foundProcessor = true;
                WoodPaletteProcessor processorWood = (WoodPaletteProcessor)processor;
                processors.removeIf(pro -> pro instanceof WoodPaletteProcessor);
                processorWood.generateAndSetPallet(random);
                processors.add(processorWood);
                StructureProcessorList list = new StructureProcessorList(processors);
                ((SingleJigsawPiece)jigsawpiece).field_214862_b = () -> list;
                carryOverProcessor = Optional.of(processorWood);
            }
        }
        AbstractVillagePiece abstractvillagepiece = villagePieceBuilder.create(templateManager, jigsawpiece, blockpos, jigsawpiece.func_214850_d(), rotation, jigsawpiece.func_214852_a(templateManager, blockpos, rotation));
        MutableBoundingBox mutableboundingbox = abstractvillagepiece.func_74874_b();
        int structureBBAverageX = (mutableboundingbox.field_78893_d + mutableboundingbox.field_78897_a) / 2;
        int structureBBAverageZ = (mutableboundingbox.field_78892_f + mutableboundingbox.field_78896_c) / 2;
        int structureStartHeight = projectStartToHeightmap ? blockpos.func_177956_o() + chunkGenerator.func_222532_b(structureBBAverageX, structureBBAverageZ, Heightmap.Type.WORLD_SURFACE_WG) : blockpos.func_177956_o();
        int relativeStructureYShift = mutableboundingbox.field_78895_b + abstractvillagepiece.func_214830_d();
        abstractvillagepiece.func_181138_a(0, structureStartHeight - relativeStructureYShift, 0);
        pieces.add((AbstractVillagePiece)abstractvillagepiece);
        if (structureConfig.func_236534_a_() > 0) {
            int maxPlaceDistance = 80;
            AxisAlignedBB axisalignedbb = new AxisAlignedBB((double)(structureBBAverageX - maxPlaceDistance), (double)(structureStartHeight - maxPlaceDistance), (double)(structureBBAverageZ - maxPlaceDistance), (double)(structureBBAverageX + maxPlaceDistance + 1), (double)(structureStartHeight + maxPlaceDistance + 1), (double)(structureBBAverageZ + maxPlaceDistance + 1));
            Assembler jigsawmanager$assembler = new Assembler((Registry)mutableregistry, structureConfig.func_236534_a_(), villagePieceBuilder, chunkGenerator, templateManager, pieces, random, carryOverProcessor);
            jigsawmanager$assembler.placing.addLast(new Entry(abstractvillagepiece, new MutableObject((Object)VoxelShapes.func_197878_a((VoxelShape)VoxelShapes.func_197881_a((AxisAlignedBB)axisalignedbb), (VoxelShape)VoxelShapes.func_197881_a((AxisAlignedBB)AxisAlignedBB.func_216363_a((MutableBoundingBox)mutableboundingbox)), (IBooleanFunction)IBooleanFunction.field_223234_e_)), structureStartHeight + 80, 0));
            while (!jigsawmanager$assembler.placing.isEmpty()) {
                Entry jigsawmanager$entry = (Entry)jigsawmanager$assembler.placing.removeFirst();
                jigsawmanager$assembler.tryPlacingChildren(jigsawmanager$entry.piece, (MutableObject<VoxelShape>)jigsawmanager$entry.free, jigsawmanager$entry.boundsTop, jigsawmanager$entry.depth, doExpansionHack);
            }
        }
    }

    public static void addPieces(DynamicRegistries registry, AbstractVillagePiece preBuiltAbstractVillagePiece, int buildLevels, IPieceFactory villagePieceBuilder, ChunkGenerator chunkGenerator, TemplateManager templateManager, List<? super AbstractVillagePiece> listBuildablePieces, Random random) {
        MutableRegistry mutableregistry = registry.func_243612_b(Registry.field_243555_ax);
        Assembler jigsawmanager$assembler = new Assembler((Registry)mutableregistry, buildLevels, villagePieceBuilder, chunkGenerator, templateManager, listBuildablePieces, random, Optional.empty());
        jigsawmanager$assembler.placing.addLast(new Entry(preBuiltAbstractVillagePiece, new MutableObject((Object)VoxelShapes.field_216389_a), 0, 0));
        while (!jigsawmanager$assembler.placing.isEmpty()) {
            Entry jigsawmanager$entry = (Entry)jigsawmanager$assembler.placing.removeFirst();
            jigsawmanager$assembler.tryPlacingChildren(jigsawmanager$entry.piece, (MutableObject<VoxelShape>)jigsawmanager$entry.free, jigsawmanager$entry.boundsTop, jigsawmanager$entry.depth, false);
        }
    }

    public static interface IPieceFactory {
        public AbstractVillagePiece create(TemplateManager var1, JigsawPiece var2, BlockPos var3, int var4, Rotation var5, MutableBoundingBox var6);
    }

    static final class Entry {
        private final AbstractVillagePiece piece;
        private final MutableObject<VoxelShape> free;
        private final int boundsTop;
        private final int depth;

        private Entry(AbstractVillagePiece pPiece, MutableObject<VoxelShape> pFree, int pBoundsTop, int pDepth) {
            this.piece = pPiece;
            this.free = pFree;
            this.boundsTop = pBoundsTop;
            this.depth = pDepth;
        }
    }

    static final class Assembler {
        private final Registry<JigsawPattern> pools;
        private final int maxDepth;
        private final IPieceFactory factory;
        private final ChunkGenerator chunkGenerator;
        private final TemplateManager structureManager;
        private final List<? super AbstractVillagePiece> pieces;
        private final Random random;
        private final Deque<Entry> placing = Queues.newArrayDeque();
        private final Optional<WoodPaletteProcessor> carryOverProcessor;

        private Assembler(Registry<JigsawPattern> pPools, int pMaxDepth, IPieceFactory pFactory, ChunkGenerator pChunkGenerator, TemplateManager pStructureManager, List<? super AbstractVillagePiece> pPieces, Random pRandom, Optional<WoodPaletteProcessor> pCarryOverProcessor) {
            this.pools = pPools;
            this.maxDepth = pMaxDepth;
            this.factory = pFactory;
            this.chunkGenerator = pChunkGenerator;
            this.structureManager = pStructureManager;
            this.pieces = pPieces;
            this.random = pRandom;
            this.carryOverProcessor = pCarryOverProcessor;
        }

        private void tryPlacingChildren(AbstractVillagePiece villagePiece, MutableObject<VoxelShape> freeVoxelShapes, int boundsTop, int depth, boolean doExpansionHack) {
            JigsawPiece jigsawpiece = villagePiece.func_214826_b();
            BlockPos blockpos = villagePiece.func_214828_c();
            Rotation rotation = villagePiece.func_214809_Y_();
            JigsawPattern.PlacementBehaviour jigsawPiecePlacementBehaviour = jigsawpiece.func_214854_c();
            boolean isParentPlacementRidged = jigsawPiecePlacementBehaviour == JigsawPattern.PlacementBehaviour.RIGID;
            MutableObject<VoxelShape> structureShapeInterpolated = new MutableObject<VoxelShape>();
            MutableBoundingBox mutableboundingbox = villagePiece.func_74874_b();
            int jigsawPieceRelativeBottomYValue = mutableboundingbox.field_78895_b;
            block0: for (Template.BlockInfo parentPieceJigsawBlockInfo : jigsawpiece.func_214849_a(this.structureManager, blockpos, rotation, this.random)) {
                Direction direction = JigsawBlock.func_235508_h_((BlockState)parentPieceJigsawBlockInfo.field_186243_b);
                BlockPos blockpos1 = parentPieceJigsawBlockInfo.field_186242_a;
                BlockPos blockpos2 = blockpos1.func_177972_a(direction);
                int jigsawYRelativeToActualPieceBottom = blockpos1.func_177956_o() - jigsawPieceRelativeBottomYValue;
                int chunkGeneratorUsableSpawwnHeight = -1;
                ResourceLocation jigsawPoolResourceLocation = new ResourceLocation(parentPieceJigsawBlockInfo.field_186244_c.func_74779_i("pool"));
                Optional jigsawPool = this.pools.func_241873_b(jigsawPoolResourceLocation);
                if (jigsawPool.isPresent() && (((JigsawPattern)jigsawPool.get()).func_214946_c() != 0 || Objects.equals(jigsawPoolResourceLocation, JigsawPatternRegistry.field_244091_a.func_240901_a_()))) {
                    ResourceLocation jigsawPoolFallbackResourceLocation = ((JigsawPattern)jigsawPool.get()).func_214948_a();
                    Optional jigsawFallbackPool = this.pools.func_241873_b(jigsawPoolFallbackResourceLocation);
                    if (jigsawFallbackPool.isPresent() && (((JigsawPattern)jigsawFallbackPool.get()).func_214946_c() != 0 || Objects.equals(jigsawPoolFallbackResourceLocation, JigsawPatternRegistry.field_244091_a.func_240901_a_()))) {
                        JigsawPiece connectingPoolJigsawPiece;
                        int parentPirceBoundsTop;
                        MutableObject<VoxelShape> childPieceStructureShapeInterpolated;
                        boolean isConnectingJigsawInsideCurrentStructure = mutableboundingbox.func_175898_b((Vector3i)blockpos2);
                        if (isConnectingJigsawInsideCurrentStructure) {
                            childPieceStructureShapeInterpolated = structureShapeInterpolated;
                            parentPirceBoundsTop = jigsawPieceRelativeBottomYValue;
                            if (structureShapeInterpolated.getValue() == null) {
                                structureShapeInterpolated.setValue((Object)VoxelShapes.func_197881_a((AxisAlignedBB)AxisAlignedBB.func_216363_a((MutableBoundingBox)mutableboundingbox)));
                            }
                        } else {
                            childPieceStructureShapeInterpolated = freeVoxelShapes;
                            parentPirceBoundsTop = boundsTop;
                        }
                        ArrayList jigsawPiecesConnectingPool = Lists.newArrayList();
                        if (depth != this.maxDepth) {
                            jigsawPiecesConnectingPool.addAll(((JigsawPattern)jigsawPool.get()).func_214943_b(this.random));
                        }
                        jigsawPiecesConnectingPool.addAll(((JigsawPattern)jigsawFallbackPool.get()).func_214943_b(this.random));
                        Iterator iterator = jigsawPiecesConnectingPool.iterator();
                        while (iterator.hasNext() && (connectingPoolJigsawPiece = (JigsawPiece)iterator.next()) != EmptyJigsawPiece.field_214856_a) {
                            for (Rotation rotation1 : Rotation.func_222467_b((Random)this.random)) {
                                List connectingPieceJigsawRandom = connectingPoolJigsawPiece.func_214849_a(this.structureManager, BlockPos.field_177992_a, rotation1, this.random);
                                MutableBoundingBox rotatedBBforJigsawRandom = connectingPoolJigsawPiece.func_214852_a(this.structureManager, BlockPos.field_177992_a, rotation1);
                                int expansionHackModifierValue = doExpansionHack && rotatedBBforJigsawRandom.func_78882_c() <= 16 ? connectingPieceJigsawRandom.stream().mapToInt(blockInfo -> {
                                    if (!rotatedBBforJigsawRandom.func_175898_b((Vector3i)blockInfo.field_186242_a.func_177972_a(JigsawBlock.func_235508_h_((BlockState)blockInfo.field_186243_b)))) {
                                        return 0;
                                    }
                                    ResourceLocation connectedPieceEXEesourceLocation = new ResourceLocation(blockInfo.field_186244_c.func_74779_i("pool"));
                                    Optional connectedPieceEX = this.pools.func_241873_b(connectedPieceEXEesourceLocation);
                                    Optional<Integer> connectedPieceFallbackEX = connectedPieceEX.flatMap(p_242843_1_ -> this.pools.func_241873_b(p_242843_1_.func_214948_a()));
                                    int pieceMaxSize = connectedPieceEX.map(p_242842_1_ -> p_242842_1_.func_214945_a(this.structureManager)).orElse(0);
                                    int pieceFallbackMaxSize = connectedPieceFallbackEX.map(p_242840_1_ -> p_242840_1_.func_214945_a(this.structureManager)).orElse(0);
                                    return Math.max(pieceMaxSize, pieceFallbackMaxSize);
                                }).max().orElse(0) : 0;
                                for (Template.BlockInfo connectingPieceJigsawBlockInfo : connectingPieceJigsawRandom) {
                                    int connectingPoolJigsawPieceSpawnHeight;
                                    int correctedYconnectingPieceSpawnHeight;
                                    if (!JigsawBlock.func_220171_a((Template.BlockInfo)parentPieceJigsawBlockInfo, (Template.BlockInfo)connectingPieceJigsawBlockInfo)) continue;
                                    BlockPos blockpos3 = connectingPieceJigsawBlockInfo.field_186242_a;
                                    BlockPos blockpos4 = new BlockPos(blockpos2.func_177958_n() - blockpos3.func_177958_n(), blockpos2.func_177956_o() - blockpos3.func_177956_o(), blockpos2.func_177952_p() - blockpos3.func_177952_p());
                                    MutableBoundingBox mutableboundingbox2 = connectingPoolJigsawPiece.func_214852_a(this.structureManager, blockpos4, rotation1);
                                    int connectingPoolJigsawPieceRelativeBottomYValue = mutableboundingbox2.field_78895_b;
                                    JigsawPattern.PlacementBehaviour connectingPoolJigsawPiecePlacementBehaviour = connectingPoolJigsawPiece.func_214854_c();
                                    boolean isAttachedPlacementRidged = connectingPoolJigsawPiecePlacementBehaviour == JigsawPattern.PlacementBehaviour.RIGID;
                                    int connectingPoolJigsawPieceRelativeYValue = blockpos3.func_177956_o();
                                    int relativeYconnectingPieceSpawnHeight = jigsawYRelativeToActualPieceBottom - connectingPoolJigsawPieceRelativeYValue + JigsawBlock.func_235508_h_((BlockState)parentPieceJigsawBlockInfo.field_186243_b).func_96559_d();
                                    if (isParentPlacementRidged && isAttachedPlacementRidged) {
                                        correctedYconnectingPieceSpawnHeight = jigsawPieceRelativeBottomYValue + relativeYconnectingPieceSpawnHeight;
                                    } else {
                                        if (chunkGeneratorUsableSpawwnHeight == -1) {
                                            chunkGeneratorUsableSpawwnHeight = this.chunkGenerator.func_222532_b(blockpos1.func_177958_n(), blockpos1.func_177952_p(), Heightmap.Type.WORLD_SURFACE_WG);
                                        }
                                        correctedYconnectingPieceSpawnHeight = chunkGeneratorUsableSpawwnHeight - connectingPoolJigsawPieceRelativeYValue;
                                    }
                                    int connectingPieceBBShiftYoffset = correctedYconnectingPieceSpawnHeight - connectingPoolJigsawPieceRelativeBottomYValue;
                                    MutableBoundingBox mutableboundingbox3 = mutableboundingbox2.func_215127_b(0, connectingPieceBBShiftYoffset, 0);
                                    BlockPos blockpos5 = blockpos4.func_177982_a(0, connectingPieceBBShiftYoffset, 0);
                                    if (expansionHackModifierValue > 0) {
                                        int expansionHackModifidYvalue = Math.max(expansionHackModifierValue + 1, mutableboundingbox3.field_78894_e - mutableboundingbox3.field_78895_b);
                                        mutableboundingbox3.field_78894_e = mutableboundingbox3.field_78895_b + expansionHackModifidYvalue;
                                    }
                                    if (VoxelShapes.func_197879_c((VoxelShape)((VoxelShape)childPieceStructureShapeInterpolated.getValue()), (VoxelShape)VoxelShapes.func_197881_a((AxisAlignedBB)AxisAlignedBB.func_216363_a((MutableBoundingBox)mutableboundingbox3).func_186664_h(0.25)), (IBooleanFunction)IBooleanFunction.field_223232_c_)) continue;
                                    childPieceStructureShapeInterpolated.setValue((Object)VoxelShapes.func_197882_b((VoxelShape)((VoxelShape)childPieceStructureShapeInterpolated.getValue()), (VoxelShape)VoxelShapes.func_197881_a((AxisAlignedBB)AxisAlignedBB.func_216363_a((MutableBoundingBox)mutableboundingbox3)), (IBooleanFunction)IBooleanFunction.field_223234_e_));
                                    int pieceGroundLevelData = villagePiece.func_214830_d();
                                    int connectingPoolJigsawPieceGroundLevelData = isAttachedPlacementRidged ? pieceGroundLevelData - relativeYconnectingPieceSpawnHeight : connectingPoolJigsawPiece.func_214850_d();
                                    if (this.carryOverProcessor.isPresent() && connectingPoolJigsawPiece instanceof SingleJigsawPiece) {
                                        ArrayList<StructureProcessor> processors = new ArrayList<StructureProcessor>(((StructureProcessorList)((SingleJigsawPiece)connectingPoolJigsawPiece).field_214862_b.get()).func_242919_a());
                                        processors.removeIf(pro -> pro instanceof WoodPaletteProcessor);
                                        processors.add(this.carryOverProcessor.get());
                                        StructureProcessorList list = new StructureProcessorList(processors);
                                        ((SingleJigsawPiece)connectingPoolJigsawPiece).field_214862_b = () -> list;
                                    }
                                    AbstractVillagePiece abstractvillagepiece = this.factory.create(this.structureManager, connectingPoolJigsawPiece, blockpos5, connectingPoolJigsawPieceGroundLevelData, rotation1, mutableboundingbox3);
                                    if (isParentPlacementRidged) {
                                        connectingPoolJigsawPieceSpawnHeight = jigsawPieceRelativeBottomYValue + jigsawYRelativeToActualPieceBottom;
                                    } else if (isAttachedPlacementRidged) {
                                        connectingPoolJigsawPieceSpawnHeight = correctedYconnectingPieceSpawnHeight + connectingPoolJigsawPieceRelativeYValue;
                                    } else {
                                        if (chunkGeneratorUsableSpawwnHeight == -1) {
                                            chunkGeneratorUsableSpawwnHeight = this.chunkGenerator.func_222532_b(blockpos1.func_177958_n(), blockpos1.func_177952_p(), Heightmap.Type.WORLD_SURFACE_WG);
                                        }
                                        connectingPoolJigsawPieceSpawnHeight = chunkGeneratorUsableSpawwnHeight + relativeYconnectingPieceSpawnHeight / 2;
                                    }
                                    villagePiece.func_214831_a(new JigsawJunction(blockpos2.func_177958_n(), connectingPoolJigsawPieceSpawnHeight - jigsawYRelativeToActualPieceBottom + pieceGroundLevelData, blockpos2.func_177952_p(), relativeYconnectingPieceSpawnHeight, connectingPoolJigsawPiecePlacementBehaviour));
                                    abstractvillagepiece.func_214831_a(new JigsawJunction(blockpos1.func_177958_n(), connectingPoolJigsawPieceSpawnHeight - connectingPoolJigsawPieceRelativeYValue + connectingPoolJigsawPieceGroundLevelData, blockpos1.func_177952_p(), -relativeYconnectingPieceSpawnHeight, jigsawPiecePlacementBehaviour));
                                    this.pieces.add((AbstractVillagePiece)abstractvillagepiece);
                                    if (depth + 1 > this.maxDepth) continue block0;
                                    this.placing.addLast(new Entry(abstractvillagepiece, childPieceStructureShapeInterpolated, parentPirceBoundsTop, depth + 1));
                                    continue block0;
                                }
                            }
                        }
                        continue;
                    }
                    LOGGER.warn("Empty or none existent fallback pool: {}", (Object)jigsawPoolFallbackResourceLocation);
                    continue;
                }
                LOGGER.warn("Empty or none existent pool: {}", (Object)jigsawPoolResourceLocation);
            }
        }
    }
}

