/*
 * Decompiled with CFR 0.152.
 */
package com.github.maximuslotro.lotrrextended.common.world.gen.structureV5;

import com.github.maximuslotro.lotrrextended.common.world.gen.structureV5.StructureType;
import com.github.maximuslotro.lotrrextended.common.world.gen.structureV5.config.SinglePoolConfig;
import com.github.maximuslotro.lotrrextended.common.world.gen.structureV5.config.WeightedStructureConfig;
import com.github.maximuslotro.lotrrextended.common.world.gen.structureV5.structures.SinglePoolStructure;
import com.github.maximuslotro.lotrrextended.common.world.gen.structureV5.structures.WeightedPoolStructure;
import com.github.maximuslotro.lotrrextended.common.world.gen.structureV5.structures.bree.SingleBreeHamletPoolStructure;
import com.github.maximuslotro.lotrrextended.common.world.gen.structureV5.structures.hobbits.HobbitHoleLargeStructure;
import com.github.maximuslotro.lotrrextended.common.world.gen.structureV5.structures.hobbits.HobbitTavernLargeStructure;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.util.registry.WorldGenRegistries;
import net.minecraft.world.gen.DimensionSettings;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.gen.settings.DimensionStructuresSettings;
import net.minecraft.world.gen.settings.StructureSeparationSettings;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;

public class ExtendedStructuresV5 {
    public static final DeferredRegister<Structure<?>> STRUCTURE_REGISTRY = DeferredRegister.create((IForgeRegistry)ForgeRegistries.STRUCTURE_FEATURES, (String)"lotrextended");
    public static final RegistryObject<Structure<SinglePoolConfig>> HOBBIT_BARN = STRUCTURE_REGISTRY.register("hobbit_barn", () -> new SinglePoolStructure(StructureType.HOBBIT));
    public static final RegistryObject<Structure<SinglePoolConfig>> HOBBIT_HOLE_SMALL = STRUCTURE_REGISTRY.register("hobbit_hole_small", () -> new SinglePoolStructure(StructureType.HOBBIT));
    public static final RegistryObject<Structure<NoFeatureConfig>> HOBBIT_HOLE_LARGE = STRUCTURE_REGISTRY.register("hobbit_hole_large", () -> new HobbitHoleLargeStructure(StructureType.HOBBIT));
    public static final RegistryObject<Structure<SinglePoolConfig>> HOBBIT_HOUSE = STRUCTURE_REGISTRY.register("hobbit_house", () -> new SinglePoolStructure(StructureType.HOBBIT));
    public static final RegistryObject<Structure<SinglePoolConfig>> HOBBIT_PICNIC_BLANKET = STRUCTURE_REGISTRY.register("hobbit_picnic_blanket", () -> new SinglePoolStructure(StructureType.HOBBIT));
    public static final RegistryObject<Structure<SinglePoolConfig>> HOBBIT_PICNIC_TABLE = STRUCTURE_REGISTRY.register("hobbit_picnic_table", () -> new SinglePoolStructure(StructureType.HOBBIT));
    public static final RegistryObject<Structure<SinglePoolConfig>> HOBBIT_TAVERN_SMALL = STRUCTURE_REGISTRY.register("hobbit_tavern_small", () -> new SinglePoolStructure(StructureType.HOBBIT));
    public static final RegistryObject<Structure<NoFeatureConfig>> HOBBIT_TAVERN_LARGE = STRUCTURE_REGISTRY.register("hobbit_tavern_large", () -> new HobbitTavernLargeStructure(StructureType.HOBBIT));
    public static final RegistryObject<Structure<SinglePoolConfig>> HOBBIT_WINDMILL = STRUCTURE_REGISTRY.register("hobbit_windmill", () -> new SinglePoolStructure(StructureType.HOBBIT));
    public static final RegistryObject<Structure<SinglePoolConfig>> RANGER_CAMP = STRUCTURE_REGISTRY.register("ranger_camp", () -> new SinglePoolStructure(StructureType.RANGER));
    public static final RegistryObject<Structure<SinglePoolConfig>> RANGER_ENCAMPMENT = STRUCTURE_REGISTRY.register("ranger_encampment", () -> new SinglePoolStructure(StructureType.RANGER));
    public static final RegistryObject<Structure<SinglePoolConfig>> RANGER_FORT = STRUCTURE_REGISTRY.register("ranger_fort", () -> new SinglePoolStructure(StructureType.RANGER));
    public static final RegistryObject<Structure<SinglePoolConfig>> RANGER_HIDEOUT = STRUCTURE_REGISTRY.register("ranger_hideout", () -> new SinglePoolStructure(StructureType.RANGER));
    public static final RegistryObject<Structure<SinglePoolConfig>> RANGER_WATCHTOWER = STRUCTURE_REGISTRY.register("ranger_watchtower", () -> new SinglePoolStructure(StructureType.RANGER));
    public static final RegistryObject<Structure<WeightedStructureConfig>> RANGER_HOUSE_HIDEOUT = STRUCTURE_REGISTRY.register("ranger_house_hideout", () -> new WeightedPoolStructure(StructureType.RANGER));
    public static final RegistryObject<Structure<SinglePoolConfig>> RANGER_HOUSE_RUIN = STRUCTURE_REGISTRY.register("ranger_house_ruin", () -> new SinglePoolStructure(StructureType.RANGER));
    public static final RegistryObject<Structure<WeightedStructureConfig>> ARNOR_RUINS = STRUCTURE_REGISTRY.register("arnor_ruins", () -> new WeightedPoolStructure(StructureType.RUIN));
    public static final RegistryObject<Structure<SinglePoolConfig>> GUNDABAD_CAMP = STRUCTURE_REGISTRY.register("gundabad_camp", () -> new SinglePoolStructure(StructureType.GUNDABAD_ORC));
    public static final RegistryObject<Structure<SinglePoolConfig>> GUNDABAD_ENCAMPMENT = STRUCTURE_REGISTRY.register("gundabad_encampment", () -> new SinglePoolStructure(StructureType.GUNDABAD_ORC));
    public static final RegistryObject<Structure<WeightedStructureConfig>> BARROW_DOWN_RUINS = STRUCTURE_REGISTRY.register("barrow_down_ruins", () -> new WeightedPoolStructure(StructureType.RUIN));
    public static final RegistryObject<Structure<WeightedStructureConfig>> BARROW_DOWN_BARROWS = STRUCTURE_REGISTRY.register("barrow_down_barrows", () -> new WeightedPoolStructure(StructureType.BARROW));
    public static final RegistryObject<Structure<SinglePoolConfig>> BREE_HAMLET = STRUCTURE_REGISTRY.register("bree_hamlet", () -> new SingleBreeHamletPoolStructure(StructureType.BREE_HAMLET));

    public static void setupStructures() {
        ExtendedStructuresV5.register((Structure<? extends IFeatureConfig>)((Structure)HOBBIT_BARN.get()), true, 32, 12, 795386759);
        ExtendedStructuresV5.register((Structure<? extends IFeatureConfig>)((Structure)HOBBIT_HOLE_SMALL.get()), true, 24, 9, 212561518);
        ExtendedStructuresV5.register((Structure<? extends IFeatureConfig>)((Structure)HOBBIT_HOLE_LARGE.get()), false, 40, 25, 445436264);
        ExtendedStructuresV5.register((Structure<? extends IFeatureConfig>)((Structure)HOBBIT_HOUSE.get()), true, 24, 5, 764008750);
        ExtendedStructuresV5.register((Structure<? extends IFeatureConfig>)((Structure)HOBBIT_PICNIC_BLANKET.get()), false, 20, 8, 639354136);
        ExtendedStructuresV5.register((Structure<? extends IFeatureConfig>)((Structure)HOBBIT_PICNIC_TABLE.get()), true, 30, 10, 852604573);
        ExtendedStructuresV5.register((Structure<? extends IFeatureConfig>)((Structure)HOBBIT_TAVERN_SMALL.get()), true, 30, 15, 489984587);
        ExtendedStructuresV5.register((Structure<? extends IFeatureConfig>)((Structure)HOBBIT_TAVERN_LARGE.get()), false, 50, 40, 230050245);
        ExtendedStructuresV5.register((Structure<? extends IFeatureConfig>)((Structure)HOBBIT_WINDMILL.get()), true, 40, 20, 965983479);
        ExtendedStructuresV5.register((Structure<? extends IFeatureConfig>)((Structure)RANGER_CAMP.get()), true, 55, 35, 6678446);
        ExtendedStructuresV5.register((Structure<? extends IFeatureConfig>)((Structure)RANGER_ENCAMPMENT.get()), true, 60, 40, 232963172);
        ExtendedStructuresV5.register((Structure<? extends IFeatureConfig>)((Structure)RANGER_FORT.get()), true, 56, 36, 213435145);
        ExtendedStructuresV5.register((Structure<? extends IFeatureConfig>)((Structure)RANGER_HIDEOUT.get()), true, 50, 38, 75222251);
        ExtendedStructuresV5.register((Structure<? extends IFeatureConfig>)((Structure)RANGER_WATCHTOWER.get()), true, 60, 38, 85027);
        ExtendedStructuresV5.register((Structure<? extends IFeatureConfig>)((Structure)RANGER_HOUSE_HIDEOUT.get()), true, 50, 35, 358719680);
        ExtendedStructuresV5.register((Structure<? extends IFeatureConfig>)((Structure)RANGER_HOUSE_RUIN.get()), true, 52, 26, 34063920);
        ExtendedStructuresV5.register((Structure<? extends IFeatureConfig>)((Structure)ARNOR_RUINS.get()), true, 29, 18, 365876386);
        ExtendedStructuresV5.register((Structure<? extends IFeatureConfig>)((Structure)GUNDABAD_CAMP.get()), true, 45, 25, 967990477);
        ExtendedStructuresV5.register((Structure<? extends IFeatureConfig>)((Structure)GUNDABAD_ENCAMPMENT.get()), true, 50, 35, 43757456);
        ExtendedStructuresV5.register((Structure<? extends IFeatureConfig>)((Structure)BARROW_DOWN_RUINS.get()), true, 7, 3, 45574576);
        ExtendedStructuresV5.register((Structure<? extends IFeatureConfig>)((Structure)BARROW_DOWN_BARROWS.get()), true, 7, 3, 57854769);
        ExtendedStructuresV5.register((Structure<? extends IFeatureConfig>)((Structure)BREE_HAMLET.get()), true, 60, 30, 57854769);
    }

    public static void register(Structure<? extends IFeatureConfig> structure, boolean editLand, int spacing, int seperation, int salt) {
        if (spacing - seperation <= 0) {
            throw new IllegalArgumentException("Structure SeperationSettings setup detected an invalid configuration where seperation>=spacing: " + seperation + ">=" + spacing);
        }
        StructureSeparationSettings SSsettings = new StructureSeparationSettings(spacing, seperation, salt);
        Structure.field_236365_a_.put((Object)structure.getRegistryName().toString(), structure);
        if (editLand) {
            Structure.field_236384_t_ = ImmutableList.builder().addAll((Iterable)Structure.field_236384_t_).add(structure).build();
        }
        DimensionStructuresSettings.field_236191_b_ = ImmutableMap.builder().putAll((Map)DimensionStructuresSettings.field_236191_b_).put(structure, (Object)SSsettings).build();
        WorldGenRegistries.field_243658_j.func_239659_c_().forEach(structureSettings -> {
            Map structureMap = ((DimensionSettings)structureSettings.getValue()).func_236108_a_().func_236195_a_();
            if (structureMap instanceof ImmutableMap) {
                HashMap<Structure, StructureSeparationSettings> tempMap = new HashMap<Structure, StructureSeparationSettings>(structureMap);
                tempMap.put(structure, SSsettings);
                ((DimensionSettings)structureSettings.getValue()).func_236108_a_().field_236193_d_ = tempMap;
            } else {
                structureMap.put(structure, SSsettings);
            }
        });
    }
}

