/*
 * Decompiled with CFR 0.152.
 */
package com.github.maximuslotro.lotrrextended.common.world.gen.structureV5.config;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.world.gen.feature.IFeatureConfig;

public class WeightedStructureConfig
implements IFeatureConfig {
    public static final Codec<WeightedStructureConfig> CODEC = RecordCodecBuilder.create(p_236650_0_ -> p_236650_0_.group((App)Codec.unboundedMap((Codec)Codec.STRING, (Codec)Codec.INT).fieldOf("weighted_pools").orElseGet(() -> new HashMap()).forGetter(config -> config.weightedPools)).apply((Applicative)p_236650_0_, WeightedStructureConfig::new));
    public final Map<String, Integer> weightedPools;

    public WeightedStructureConfig(Map<String, Integer> weightedPools) {
        this.weightedPools = weightedPools;
    }

    public WeightedStructureConfig() {
        this.weightedPools = new HashMap<String, Integer>();
    }

    public WeightedStructureConfig addStructureToPool(String pool, int weight) {
        this.weightedPools.put(pool, weight);
        return this;
    }

    public String getRandomLocation() {
        if (this.weightedPools.isEmpty()) {
            return null;
        }
        double completeWeight = 0.0;
        for (Map.Entry<String, Integer> item : this.weightedPools.entrySet()) {
            completeWeight += (double)item.getValue().intValue();
        }
        double r = Math.random() * completeWeight;
        double countWeight = 0.0;
        for (Map.Entry<String, Integer> item : this.weightedPools.entrySet()) {
            if (!((countWeight += (double)item.getValue().intValue()) >= r)) continue;
            return item.getKey();
        }
        throw new RuntimeException("LotrExtended error appeared when parsing weighted structure configs!");
    }
}

