/*
 * Decompiled with CFR 0.152.
 */
package com.github.maximuslotro.lotrrextended.common.world.gen.structureV5.extendedclasses;

import com.github.maximuslotro.lotrrextended.common.world.gen.structureV5.ExtendedStructuresV5;
import com.github.maximuslotro.lotrrextended.common.world.gen.structureV5.StructureType;
import com.mojang.serialization.Codec;
import lotr.common.world.map.MapSettingsManager;
import net.minecraft.block.BlockState;
import net.minecraft.util.SharedSeedRandom;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.provider.BiomeProvider;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.gen.settings.StructureSeparationSettings;

public abstract class ExtendedSurfaceStructuresV5<C extends IFeatureConfig>
extends Structure<C> {
    private final StructureType structureType;

    public ExtendedSurfaceStructuresV5(Codec<C> p_i231997_1_, StructureType type) {
        super(p_i231997_1_);
        this.structureType = type;
    }

    public GenerationStage.Decoration func_236396_f_() {
        return GenerationStage.Decoration.SURFACE_STRUCTURES;
    }

    public Structure.IStartFactory<C> func_214557_a() {
        return this.getStructureStartFactory();
    }

    public boolean canSpawnInWater() {
        return false;
    }

    public boolean canSpawnNearRoad() {
        return false;
    }

    public abstract Structure.IStartFactory<C> getStructureStartFactory();

    protected boolean func_230363_a_(ChunkGenerator chunkGenerator, BiomeProvider biomeSource, long seed, SharedSeedRandom chunkRandom, int chunkX, int chunkZ, Biome biome, ChunkPos chunkPos, C featureConfig) {
        boolean roadExistsInRange;
        boolean waterPresent;
        BlockPos centerOfChunk = new BlockPos(chunkX * 16, 0, chunkZ * 16);
        int landHeight = chunkGenerator.func_222531_c(centerOfChunk.func_177958_n(), centerOfChunk.func_177952_p(), Heightmap.Type.WORLD_SURFACE_WG);
        IBlockReader columnOfBlocks = chunkGenerator.func_230348_a_(centerOfChunk.func_177958_n(), centerOfChunk.func_177952_p());
        BlockState topBlock = columnOfBlocks.func_180495_p(centerOfChunk.func_177981_b(landHeight));
        boolean bl = waterPresent = !topBlock.func_204520_s().func_206888_e();
        if (!this.canSpawnInWater() && waterPresent) {
            return false;
        }
        boolean bl2 = roadExistsInRange = MapSettingsManager.serverInstance().getCurrentLoadedMap().getRoadPointCache().getRoadCentreCloseness(centerOfChunk.func_177958_n(), centerOfChunk.func_177952_p(), 16) >= 0.0f;
        if (!this.canSpawnNearRoad() && roadExistsInRange) {
            return false;
        }
        if (this.structureType == StructureType.RANGER) {
            int i = chunkX >> 4;
            int j = chunkZ >> 4;
            chunkRandom.setSeed((long)(i ^ j << 4) ^ seed);
            chunkRandom.nextInt();
            if (this.isNearStructure((Structure)ExtendedStructuresV5.GUNDABAD_CAMP.get(), chunkGenerator, seed, chunkRandom, chunkX, chunkZ, 10) || this.isNearStructure((Structure)ExtendedStructuresV5.GUNDABAD_ENCAMPMENT.get(), chunkGenerator, seed, chunkRandom, chunkX, chunkZ, 10)) {
                return false;
            }
        }
        if (this.structureType == StructureType.BREE_HAMLET) {
            if (ExtendedSurfaceStructuresV5.calculateChunkDistance(chunkX, chunkZ, 860, 36) < 16.0) {
                return false;
            }
            if (ExtendedSurfaceStructuresV5.calculateChunkDistance(chunkX, chunkZ, 916, 36) < 8.0) {
                return false;
            }
            if (ExtendedSurfaceStructuresV5.calculateChunkDistance(chunkX, chunkZ, 940, 12) < 8.0) {
                return false;
            }
            if (ExtendedSurfaceStructuresV5.calculateChunkDistance(chunkX, chunkZ, 948, -12) < 8.0) {
                return false;
            }
        }
        return true;
    }

    private boolean isNearStructure(Structure<?> structure, ChunkGenerator chunkGenerator, long seed, SharedSeedRandom sharedSeedRandom, int chunkPosX, int chunkPosZ, int checkRadius) {
        StructureSeparationSettings structureseparationsettings = chunkGenerator.func_235957_b_().func_236197_a_(Structure.field_236381_q_);
        if (structureseparationsettings == null) {
            return false;
        }
        for (int i = chunkPosX - checkRadius; i <= chunkPosX + checkRadius; ++i) {
            for (int j = chunkPosZ - checkRadius; j <= chunkPosZ + checkRadius; ++j) {
                ChunkPos chunkpos = structure.func_236392_a_(structureseparationsettings, seed, sharedSeedRandom, i, j);
                if (i != chunkpos.field_77276_a || j != chunkpos.field_77275_b) continue;
                return true;
            }
        }
        return false;
    }

    public static double calculateChunkDistance(int chunkX1, int chunkZ1, int chunkX2, int chunkZ2) {
        int deltaX = chunkX2 - chunkX1;
        int deltaZ = chunkZ2 - chunkZ1;
        return Math.sqrt(deltaX * deltaX + deltaZ * deltaZ);
    }
}

