/*
 * Decompiled with CFR 0.152.
 */
package com.github.maximuslotro.lotrrextended.common.world.gen.structureV5.structures;

import com.github.maximuslotro.lotrrextended.ExtendedLog;
import com.github.maximuslotro.lotrrextended.common.world.gen.structureV5.ExtendedJigsawManager;
import com.github.maximuslotro.lotrrextended.common.world.gen.structureV5.StructureType;
import com.github.maximuslotro.lotrrextended.common.world.gen.structureV5.config.SinglePoolConfig;
import com.github.maximuslotro.lotrrextended.common.world.gen.structureV5.extendedclasses.ExtendedStructureStartV5;
import com.github.maximuslotro.lotrrextended.common.world.gen.structureV5.extendedclasses.ExtendedSurfaceStructuresV5;
import java.util.Random;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.util.registry.DynamicRegistries;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.feature.jigsaw.JigsawPattern;
import net.minecraft.world.gen.feature.structure.AbstractVillagePiece;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.gen.feature.structure.VillageConfig;
import net.minecraft.world.gen.feature.template.TemplateManager;

public class SinglePoolStructure
extends ExtendedSurfaceStructuresV5<SinglePoolConfig> {
    public SinglePoolStructure(StructureType type) {
        super(SinglePoolConfig.CODEC, type);
    }

    @Override
    public Structure.IStartFactory<SinglePoolConfig> getStructureStartFactory() {
        return Start::new;
    }

    public static class Start
    extends ExtendedStructureStartV5<SinglePoolConfig> {
        public Start(Structure<SinglePoolConfig> structureIn, int chunkX, int chunkZ, MutableBoundingBox mutableBoundingBox, int referenceIn, long seedIn) {
            super(structureIn, chunkX, chunkZ, mutableBoundingBox, referenceIn, seedIn);
        }

        public void generatePieces(DynamicRegistries dynamicRegistryManager, ChunkGenerator chunkGenerator, TemplateManager templateManagerIn, int chunkX, int chunkZ, Biome biomeIn, SinglePoolConfig config) {
            int x = (chunkX << 4) + 7;
            int z = (chunkZ << 4) + 7;
            BlockPos blockpos = new BlockPos(x, 0, z);
            String pool = config.getPool();
            if ("empty".equals(pool)) {
                ExtendedLog.error("Tried generating a single pool structure using an empty pool!");
                return;
            }
            ResourceLocation location = pool.contains(":") ? new ResourceLocation(pool) : new ResourceLocation("lotrextended", pool);
            ExtendedJigsawManager.addPieces(dynamicRegistryManager, new VillageConfig(() -> (JigsawPattern)dynamicRegistryManager.func_243612_b(Registry.field_243555_ax).func_82594_a(location), this.maxDepth()), AbstractVillagePiece::new, chunkGenerator, templateManagerIn, blockpos, this.field_75075_a, (Random)this.field_214631_d, false, true);
            this.field_75075_a.forEach(piece -> piece.func_181138_a(0, this.yShift(), 0));
            this.func_202500_a();
        }

        @Override
        public String getLocation() {
            return "unused";
        }
    }
}

