/*
 * Decompiled with CFR 0.152.
 */
package com.github.maximuslotro.lotrrextended.common.world.gen.tree;

import com.github.maximuslotro.lotrrextended.common.world.gen.tree.ExtendedFoilagePlacers;
import com.github.maximuslotro.lotrrextended.common.world.gen.tree.ExtendedFoliagePlacer;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Random;
import java.util.Set;
import lotr.common.world.biome.ExtendedBiomeFeatures;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.gen.IWorldGenerationReader;
import net.minecraft.world.gen.feature.BaseTreeFeatureConfig;
import net.minecraft.world.gen.feature.FeatureSpread;
import net.minecraft.world.gen.foliageplacer.FoliagePlacer;
import net.minecraft.world.gen.foliageplacer.FoliagePlacerType;

public class BananaFoliagePlacer
extends ExtendedFoliagePlacer {
    public static final Codec<BananaFoliagePlacer> CODEC = RecordCodecBuilder.create(instance -> BananaFoliagePlacer.func_242830_b((RecordCodecBuilder.Instance)instance).and((App)FeatureSpread.func_242254_a((int)0, (int)8, (int)5).fieldOf("leaves_height").forGetter(foliage -> foliage.leavesHeight)).apply((Applicative)instance, BananaFoliagePlacer::new));
    private final FeatureSpread leavesHeight;

    public BananaFoliagePlacer(FeatureSpread radius, FeatureSpread offset, FeatureSpread trunkHeight) {
        super(radius, offset);
        this.leavesHeight = trunkHeight;
    }

    protected void func_230372_a_(IWorldGenerationReader world, Random rand, BaseTreeFeatureConfig config, int maxFreeTreeheight, FoliagePlacer.Foliage leaf, int leavesHeight, int leavesRadius, Set<BlockPos> leaves, int leavesOffset, MutableBoundingBox box) {
        BlockPos.Mutable blockpos$mutable = new BlockPos.Mutable();
        for (Direction dir : Direction.Plane.HORIZONTAL) {
            int radius;
            int y;
            int actualHeight = rand.nextInt(leavesHeight);
            int finalYValue = 0;
            int n = y = rand.nextInt(2) == 0 ? -1 : -2;
            for (radius = 1; y < actualHeight && radius <= leavesRadius; ++radius) {
                int xStep = dir.func_82601_c() * radius;
                int zStep = dir.func_82599_e() * radius;
                blockpos$mutable.func_239621_a_((Vector3i)leaf.func_236763_a_(), xStep, y, zStep);
                this.doPlaceLeafBlock(world, rand, config, blockpos$mutable, leaves, box);
                blockpos$mutable.func_239621_a_((Vector3i)leaf.func_236763_a_(), xStep, y + 1, zStep);
                this.doPlaceLeafBlock(world, rand, config, blockpos$mutable, leaves, box);
                if (rand.nextInt(3) == 0) {
                    blockpos$mutable.func_239621_a_((Vector3i)leaf.func_236763_a_(), xStep, y - 1, zStep);
                    this.doPlaceAdditionBlock(world, rand, config, blockpos$mutable, leaves, box, ExtendedBiomeFeatures.BANANA_FRUIT);
                }
                finalYValue = y++;
            }
            if (finalYValue < actualHeight && radius > leavesRadius) continue;
            blockpos$mutable.func_239621_a_((Vector3i)leaf.func_236763_a_(), dir.func_82601_c() * radius, finalYValue + 1, dir.func_82599_e() * radius);
            this.doPlaceLeafBlock(world, rand, config, blockpos$mutable, leaves, box);
        }
    }

    public int func_230374_a_(Random rand, int trunkHeight, BaseTreeFeatureConfig config) {
        return this.leavesHeight.func_242259_a(rand);
    }

    public int func_230376_a_(Random rand, int trunkHeight) {
        return super.func_230376_a_(rand, trunkHeight);
    }

    protected boolean func_230373_a_(Random rand, int absX, int layerY, int absZ, int layerWidth, boolean bool6) {
        return false;
    }

    protected FoliagePlacerType<BananaFoliagePlacer> func_230371_a_() {
        return ExtendedFoilagePlacers.BANANA_FOLIAGE;
    }
}

