/*
 * Decompiled with CFR 0.152.
 */
package com.github.maximuslotro.lotrrextended.mixins;

import com.github.maximuslotro.lotrrextended.mixins.ExtendedMixinLog;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.objectweb.asm.tree.ClassNode;
import org.spongepowered.asm.mixin.extensibility.IMixinConfigPlugin;
import org.spongepowered.asm.mixin.extensibility.IMixinInfo;

public class MIXINConfig
implements IMixinConfigPlugin {
    protected static TreeSet<String> injectedPatches = new TreeSet();
    protected static boolean isBrokenJavaFutureVersions = false;

    public void onLoad(String mixinPackage) {
        ExtendedMixinLog.make();
        ExtendedMixinLog.info("Running Java " + MIXINConfig.getJavaVersion());
        if (MIXINConfig.getJavaVersion() >= 9) {
            ExtendedMixinLog.info("Applying Java 9+ Patches to Renewed");
            isBrokenJavaFutureVersions = true;
        }
    }

    public String getRefMapperConfig() {
        return null;
    }

    public List<String> getMixins() {
        if (isBrokenJavaFutureVersions) {
            ExtendedMixinLog.info("Added Java 9+ Patches to Renewed");
        }
        return null;
    }

    public void acceptTargets(Set<String> myTargets, Set<String> otherTargets) {
    }

    public boolean shouldApplyMixin(String targetClassName, String mixinClassName) {
        ExtendedMixinLog.debug("ADDING MIXIN: " + targetClassName + ", " + mixinClassName);
        return true;
    }

    public void preApply(String targetClassName, ClassNode targetClass, String mixinClassName, IMixinInfo mixinInfo) {
    }

    public void postApply(String targetClassName, ClassNode targetClass, String mixinClassName, IMixinInfo mixinInfo) {
        injectedPatches.add(mixinInfo.getName());
    }

    public static TreeSet<String> getInjectedPatches() {
        return injectedPatches;
    }

    public boolean classExists(String name) {
        try {
            if (Class.forName(name, false, this.getClass().getClassLoader()) != null) {
                return true;
            }
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        return false;
    }

    private static int getJavaVersion() {
        String version = System.getProperty("java.version");
        if (version.startsWith("1.")) {
            version = version.substring(2, 3);
        } else {
            int dot = version.indexOf(".");
            if (dot != -1) {
                version = version.substring(0, dot);
            }
        }
        return Integer.parseInt(version);
    }

    public static boolean isBrokenJavaFutureVersions() {
        return isBrokenJavaFutureVersions;
    }
}

