/*
 * Decompiled with CFR 0.152.
 */
package com.github.maximuslotro.lotrrextended.mixins.lotr.client;

import com.github.maximuslotro.lotrrextended.mixinhelpers.ExtendedAlignmentKeyAction;
import com.google.common.collect.ImmutableMap;
import com.google.common.math.IntMath;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import lotr.client.LOTRKeyHandler;
import lotr.client.gui.MiddleEarthMasterMenuScreen;
import lotr.common.data.AlignmentDataModule;
import lotr.common.data.LOTRLevelData;
import lotr.common.fac.Faction;
import lotr.common.fac.FactionRegion;
import lotr.common.fac.FactionSettings;
import lotr.common.fac.FactionSettingsManager;
import lotr.common.init.LOTRDimensions;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.RegistryKey;
import net.minecraft.world.World;
import net.minecraftforge.client.event.InputEvent;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={LOTRKeyHandler.class})
public abstract class MixinLOTRKeyHandler {
    @Final
    @Shadow(remap=false)
    public static KeyBinding KEY_BIND_MENU;
    @Final
    @Shadow(remap=false)
    public static KeyBinding KEY_BIND_ALIGNMENT_PREVIOUS;
    @Final
    @Shadow(remap=false)
    public static KeyBinding KEY_BIND_ALIGNMENT_NEXT;
    @Final
    @Shadow(remap=false)
    public static KeyBinding KEY_BIND_ALIGNMENT_GROUP_PREVIOUS;
    @Final
    @Shadow(remap=false)
    public static KeyBinding KEY_BIND_ALIGNMENT_GROUP_NEXT;
    private static final Map<KeyBinding, ExtendedAlignmentKeyAction> ExtendedALIGNMENT_KEY_ACTIONS;
    @Shadow(remap=false)
    private static int alignmentChangeTick;

    @Inject(method={"onKeyInput(Lnet/minecraftforge/client/event/InputEvent$KeyInputEvent;)V"}, at={@At(value="HEAD")}, remap=false, cancellable=true)
    public void onKeyInput(InputEvent.KeyInputEvent event, CallbackInfo cl) {
        Screen menuScreen;
        cl.cancel();
        int key = event.getKey();
        int scancode = event.getScanCode();
        int action = event.getAction();
        Minecraft mc = Minecraft.func_71410_x();
        if (KEY_BIND_MENU.func_197976_a(key, scancode) && mc.field_71462_r == null && mc.field_71439_g != null && (menuScreen = MiddleEarthMasterMenuScreen.openMenu((PlayerEntity)mc.field_71439_g)) != null) {
            mc.func_147108_a(menuScreen);
        }
        if (mc.field_71462_r == null && mc.field_71439_g != null && (action == 1 || action == 2) && alignmentChangeTick <= 0) {
            Optional<ExtendedAlignmentKeyAction> optAlignmentAction = ExtendedALIGNMENT_KEY_ACTIONS.entrySet().stream().filter(e -> ((KeyBinding)e.getKey()).func_197976_a(key, scancode)).map(e -> (ExtendedAlignmentKeyAction)e.getValue()).findFirst();
            optAlignmentAction.ifPresent(alignmentAction -> {
                FactionSettings factionSettings = FactionSettingsManager.clientInstance().getCurrentLoadedFactions();
                AlignmentDataModule alignData = LOTRLevelData.clientInstance().getData((PlayerEntity)mc.field_71439_g).getAlignmentData();
                boolean changedAlignmentView = false;
                int factionShift = alignmentAction.factionShift;
                int groupShift = alignmentAction.groupShift;
                RegistryKey currentDimension = LOTRDimensions.getCurrentLOTRDimensionOrFallback((World)mc.field_71441_e);
                Faction currentFaction = alignData.getCurrentViewedFaction();
                if (currentFaction != null) {
                    int i;
                    FactionRegion currentRegion = currentFaction.getRegion();
                    List regionList = factionSettings.getRegionsForDimension(currentDimension);
                    List factionList = factionSettings.getFactionsForRegion(currentRegion);
                    if (factionShift != 0) {
                        i = factionList.indexOf(currentFaction);
                        i += factionShift;
                        i = IntMath.mod((int)i, (int)factionList.size());
                        alignData.setCurrentViewedFaction((Faction)factionList.get(i));
                        changedAlignmentView = true;
                    }
                    if (groupShift != 0 && regionList != null && currentRegion != null) {
                        alignData.setRegionLastViewedFaction(currentRegion, currentFaction);
                        i = regionList.indexOf(currentRegion);
                        i += groupShift;
                        i = IntMath.mod((int)i, (int)regionList.size());
                        if (((FactionRegion)regionList.get(i)).getName().toString().equals("lotr:special")) {
                            i += groupShift;
                            i = IntMath.mod((int)i, (int)regionList.size());
                        }
                        alignData.setCurrentViewedFaction(alignData.getRegionLastViewedFaction((FactionRegion)regionList.get(i)));
                        changedAlignmentView = true;
                    }
                }
                if (changedAlignmentView) {
                    alignData.sendViewedFactionsToServer();
                    alignmentChangeTick = 2;
                }
            });
        }
    }

    static {
        ExtendedALIGNMENT_KEY_ACTIONS = ImmutableMap.of((Object)KEY_BIND_ALIGNMENT_PREVIOUS, (Object)new ExtendedAlignmentKeyAction(-1, 0), (Object)KEY_BIND_ALIGNMENT_NEXT, (Object)new ExtendedAlignmentKeyAction(1, 0), (Object)KEY_BIND_ALIGNMENT_GROUP_PREVIOUS, (Object)new ExtendedAlignmentKeyAction(0, -1), (Object)KEY_BIND_ALIGNMENT_GROUP_NEXT, (Object)new ExtendedAlignmentKeyAction(0, 1));
    }
}

