/*
 * Decompiled with CFR 0.152.
 */
package com.github.maximuslotro.lotrrextended.mixins.lotr.client.event;

import com.mojang.blaze3d.systems.RenderSystem;
import lotr.client.event.AshfallFog;
import lotr.client.event.LOTRTickHandlerClient;
import lotr.client.event.MistyMountainsMist;
import lotr.client.event.RainMist;
import lotr.client.event.SandstormFog;
import lotr.client.render.world.LOTRDimensionRenderInfo;
import lotr.common.entity.npc.ExtendedBarrowWightEntity;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.renderer.FogRenderer;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.client.world.DimensionRenderInfo;
import net.minecraft.entity.Entity;
import net.minecraft.world.DimensionType;
import net.minecraft.world.World;
import net.minecraftforge.client.event.EntityViewRenderEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;

@Mixin(value={LOTRTickHandlerClient.class})
public class MixinLOTRTickHandlerClient {
    @Shadow(remap=false)
    public static float renderPartialTick;
    @Shadow(remap=false)
    @Final
    private RainMist rainMist;
    @Shadow(remap=false)
    @Final
    private MistyMountainsMist mountainsMist;
    @Shadow(remap=false)
    @Final
    private SandstormFog sandstormFog;
    @Shadow(remap=false)
    @Final
    private AshfallFog ashfallFog;
    @Shadow(remap=false)
    @Final
    private Minecraft mc;
    private float wightFogModifier;
    private float prevWightFogModifier;

    @Inject(method={"onClientTick(Lnet/minecraftforge/event/TickEvent$ClientTickEvent;)V"}, at={@At(value="INVOKE", target="Llotr/client/event/DateDisplay;update()V", shift=At.Shift.AFTER)}, locals=LocalCapture.CAPTURE_FAILHARD, remap=false)
    public void injectWightFogLogic(TickEvent.ClientTickEvent event, CallbackInfo ci) {
        ClientPlayerEntity player = this.mc.field_71439_g;
        Entity viewer = this.mc.field_175622_Z;
        ClientWorld world = (ClientWorld)player.field_70170_p;
        this.prevWightFogModifier = this.wightFogModifier;
        boolean noWights = world.func_217357_a(ExtendedBarrowWightEntity.class, viewer.func_174813_aQ().func_186662_g(32.0)).isEmpty();
        if (!noWights) {
            if (this.wightFogModifier < 100.0f) {
                this.wightFogModifier += 1.0f;
            }
        } else if (this.wightFogModifier > 0.0f) {
            this.wightFogModifier -= 1.0f;
        }
    }

    @Overwrite(remap=false)
    @SubscribeEvent
    public void onRenderFog(EntityViewRenderEvent.RenderFogEvent event) {
        Entity viewer = event.getInfo().func_216773_g();
        World world = viewer.field_70170_p;
        DimensionType dimension = world.func_230315_m_();
        world.func_226691_t_(viewer.func_233580_cy_());
        float farPlane = event.getFarPlaneDistance();
        FogRenderer.FogType fogType = event.getType();
        DimensionRenderInfo dimRenderInfo = DimensionRenderInfo.func_243495_a((DimensionType)dimension);
        if (dimRenderInfo instanceof LOTRDimensionRenderInfo) {
            float ashOpacityStart;
            float ashFog;
            float sandFog;
            float mountainsMistFactor;
            LOTRDimensionRenderInfo lDimRenderInfo = (LOTRDimensionRenderInfo)dimRenderInfo;
            float[] fogStartEnd = lDimRenderInfo.modifyFogIntensity(farPlane, fogType, viewer);
            float fogStart = fogStartEnd[0];
            float fogEnd = fogStartEnd[1];
            float rain = this.rainMist.getRainMistStrength(renderPartialTick);
            if (rain > 0.0f) {
                mountainsMistFactor = 0.95f;
                sandFog = 0.2f;
                fogStart -= fogStart * rain * mountainsMistFactor;
                fogEnd -= fogEnd * rain * sandFog;
            }
            if ((mountainsMistFactor = this.mountainsMist.getCurrentMistFactor(viewer, renderPartialTick)) > 0.0f) {
                sandFog = 0.95f;
                ashFog = 0.7f;
                fogStart -= fogStart * mountainsMistFactor * sandFog;
                fogEnd -= fogEnd * mountainsMistFactor * ashFog;
            }
            if ((sandFog = this.sandstormFog.getWeatherFogStrength(renderPartialTick)) > 0.0f) {
                ashFog = 0.99f;
                ashOpacityStart = 0.75f;
                fogStart -= fogStart * sandFog * ashFog;
                fogEnd -= fogEnd * sandFog * ashOpacityStart;
            }
            if ((ashFog = this.ashfallFog.getWeatherFogStrength(renderPartialTick)) > 0.0f) {
                ashOpacityStart = 0.95f;
                float ashOpacityEnd = 0.6f;
                fogStart -= fogStart * ashFog * ashOpacityStart;
                fogEnd -= fogEnd * ashFog * ashOpacityEnd;
            }
            float wightFog = this.prevWightFogModifier + (this.wightFogModifier - this.prevWightFogModifier) * renderPartialTick;
            if ((wightFog /= 100.0f) > 0.0f) {
                fogStart -= fogStart * wightFog * 0.97f;
                fogEnd -= fogEnd * wightFog * 0.75f;
            }
            RenderSystem.fogStart((float)fogStart);
            RenderSystem.fogEnd((float)fogEnd);
        }
    }
}

