/*
 * Decompiled with CFR 0.152.
 */
package com.github.maximuslotro.lotrrextended.mixins.lotr.client.render.model;

import com.github.maximuslotro.lotrrextended.ExtendedLog;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.ItemOverrideList;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;

@Mixin(targets={"lotr.client.render.model.HandheldItemModels$HandheldWrapperModel"})
public class MixinHandheldWrapperModelJavaPatch {
    @Overwrite(remap=false)
    public static void remapHandheldModelOverrides(ResourceLocation modelName, IBakedModel defaultModel, IBakedModel handheldModel) {
        try {
            ItemOverrideList overrides = handheldModel.func_188617_f();
            List overrideModels = overrides.field_209582_c;
            Class<?> handheldWrapperModelClass = Class.forName("lotr.client.render.model.HandheldItemModels$HandheldWrapperModel");
            Constructor<?> constructor = handheldWrapperModelClass.getDeclaredConstructor(IBakedModel.class, IBakedModel.class);
            constructor.setAccessible(true);
            List remappedOverrideModels = overrideModels.stream().map(handheldOverride -> {
                try {
                    return constructor.newInstance(defaultModel, handheldOverride);
                }
                catch (Exception e) {
                    throw new RuntimeException("Failed to instantiate HandheldWrapperModel", e);
                }
            }).collect(Collectors.toList());
            Field overrideModelsField = ObfuscationReflectionHelper.findField(ItemOverrideList.class, (String)"field_209582_c");
            overrideModelsField.setAccessible(true);
            overrideModelsField.set(overrides, remappedOverrideModels);
        }
        catch (Exception exception) {
            ExtendedLog.error("Java9+ Failed to remap handheld model overrides for model %s", modelName);
            exception.printStackTrace();
        }
    }
}

