/*
 * Decompiled with CFR 0.152.
 */
package com.github.maximuslotro.lotrrextended.mixins.lotr.client.render.tileentity;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import lotr.client.render.model.vessel.VesselDrinkModel;
import lotr.client.render.tileentity.VesselDrinkTileEntityRenderer;
import lotr.common.block.VesselDrinkBlock;
import lotr.common.item.VesselType;
import lotr.common.tileentity.VesselDrinkTileEntity;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.item.ItemStack;
import net.minecraft.state.Property;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Vector3f;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;

@Mixin(value={VesselDrinkTileEntityRenderer.class})
public abstract class MixinVesselDrinkTileEntityRenderer<T extends VesselDrinkTileEntity>
extends TileEntityRenderer<T> {
    public MixinVesselDrinkTileEntityRenderer(TileEntityRendererDispatcher p_i226006_1_) {
        super(p_i226006_1_);
    }

    @Shadow(remap=false)
    private void renderLiquidSurface(MatrixStack matStack, IVertexBuilder vb, TextureAtlasSprite icon, int uvMin, int uvMax, float x0, float z0, float x1, float z1, float y, int light, int overlay) {
    }

    @Shadow(remap=false)
    private void renderLiquidSurface(MatrixStack matStack, IVertexBuilder vb, TextureAtlasSprite icon, int uvMin, int uvMax, float width, float y, int light, int overlay) {
    }

    @Shadow(remap=false)
    private Direction getRotationToMatchBlockstateJson(Direction stateFacing) {
        return null;
    }

    public void render(T vessel, float partialTicks, MatrixStack matStack, IRenderTypeBuffer buffer, int combinedLight, int combinedOverlay) {
        if (!vessel.isEmpty()) {
            ItemStack vesselItem = vessel.getVesselItem();
            VesselType vesselType = vessel.getVesselType();
            RenderSystem.enableRescaleNormal();
            RenderSystem.disableCull();
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
            matStack.func_227860_a_();
            matStack.func_227861_a_(0.5, 0.0, 0.5);
            Direction rotateDir = this.getRotationToMatchBlockstateJson((Direction)vessel.func_195044_w().func_177229_b((Property)VesselDrinkBlock.field_185512_D));
            matStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(rotateDir.func_185119_l()));
            matStack.func_227861_a_(-0.5, 0.0, -0.5);
            matStack.func_227862_a_(0.0625f, 0.0625f, 0.0625f);
            TextureAtlasSprite liquidIcon = VesselDrinkModel.getLiquidIconFor((ItemStack)vesselItem);
            RenderType renderType = RenderType.func_228634_a_((ResourceLocation)liquidIcon.func_229241_m_().func_229223_g_());
            IVertexBuilder vb = buffer.getBuffer(renderType);
            if (vesselType == VesselType.WOODEN_MUG || vesselType == VesselType.CERAMIC_MUG) {
                this.renderLiquidSurface(matStack, vb, liquidIcon, 6, 10, 3.0f, 5.25f, combinedLight, combinedOverlay);
            } else if (vesselType == VesselType.GOLDEN_GOBLET || vesselType == VesselType.SILVER_GOBLET || vesselType == VesselType.COPPER_GOBLET || vesselType == VesselType.WOODEN_CUP) {
                this.renderLiquidSurface(matStack, vb, liquidIcon, 6, 9, 2.25f, 6.0f, combinedLight, combinedOverlay);
            } else if (vesselType == VesselType.ALE_HORN || vesselType == VesselType.GOLDEN_ALE_HORN) {
                this.renderLiquidSurface(matStack, vb, liquidIcon, 6, 9, 9.5f, 6.875f, 12.5f, 9.125f, 6.375f, combinedLight, combinedOverlay);
            } else if (vesselType == VesselType.valueOf((String)"SKULL_GOBLET")) {
                this.renderLiquidSurface(matStack, vb, liquidIcon, 6, 12, 6.0f, 9.0f, combinedLight, combinedOverlay);
            }
            matStack.func_227865_b_();
            RenderSystem.disableBlend();
            RenderSystem.enableCull();
            RenderSystem.disableRescaleNormal();
        }
    }
}

