/*
 * Decompiled with CFR 0.152.
 */
package com.github.maximuslotro.lotrrextended.mixins.lotr.common.data;

import com.github.maximuslotro.lotrrextended.common.advancements.ExtendedCriteriaTriggers;
import com.github.maximuslotro.lotrrextended.common.utils.ExtendedReflectionHelper;
import com.google.common.math.IntMath;
import java.util.List;
import java.util.UUID;
import lotr.common.LOTRMod;
import lotr.common.data.AlignmentDataModule;
import lotr.common.data.LOTRPlayerData;
import lotr.common.data.PlayerDataModule;
import lotr.common.fac.Faction;
import lotr.common.fac.FactionRegion;
import lotr.common.init.LOTRDimensions;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.RegistryKey;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.fml.server.ServerLifecycleHooks;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={AlignmentDataModule.class})
public abstract class MixinAlignmentDataModule
extends PlayerDataModule {
    @Shadow(remap=false)
    private Faction currentViewedFaction;
    @Shadow(remap=false)
    private int pledgeKillCooldown;
    @Shadow(remap=false)
    private int pledgeBreakCooldown;

    protected MixinAlignmentDataModule(LOTRPlayerData pd) {
        super(pd);
    }

    @Shadow(remap=false)
    private void runAlignmentDraining(ServerPlayerEntity player, int tick) {
    }

    @Shadow(remap=false)
    private void updateCurrentViewedFactionToNewDimension(RegistryKey<World> currentDimension) {
    }

    @Shadow(remap=false)
    public void setPledgeBreakCooldown(int i) {
    }

    @Shadow(remap=false)
    public Faction getRegionLastViewedFaction(FactionRegion region) {
        return null;
    }

    @Shadow(remap=false)
    public void setCurrentViewedFaction(Faction fac) {
    }

    @Inject(method={"setAlignment(Llotr/common/fac/Faction;F)V"}, at={@At(value="TAIL")}, remap=false)
    public void setAlignment(Faction faction, float alignment, CallbackInfo ci) {
        if (ServerLifecycleHooks.getCurrentServer() == null && LOTRMod.PROXY.isClient()) {
            return;
        }
        UUID uuid = ExtendedReflectionHelper.getAlignmentData((PlayerDataModule)((AlignmentDataModule)this));
        if (uuid != null) {
            ServerPlayerEntity player = ServerLifecycleHooks.getCurrentServer().func_184103_al().func_177451_a(uuid);
            ExtendedCriteriaTriggers.ALIGNMENT_TRIGGER.trigger(player, faction, Float.valueOf(alignment));
        }
    }

    @Overwrite(remap=false)
    protected void onUpdate(ServerPlayerEntity player, ServerWorld world, int tick) {
        RegistryKey currentDimension = LOTRDimensions.getCurrentLOTRDimensionOrFallback((World)world);
        if (this.currentViewedFaction != null) {
            FactionRegion currentRegion = this.currentViewedFaction.getRegion();
            if (!currentRegion.getDimension().equals(currentDimension)) {
                this.updateCurrentViewedFactionToNewDimension((RegistryKey<World>)currentDimension);
            }
            if (currentRegion.getName().toString().equals("lotr:special")) {
                List dimensionRegions = this.currentFactionSettings().getRegionsForDimension(currentDimension);
                int i = dimensionRegions.indexOf(currentRegion);
                ++i;
                i = IntMath.mod((int)i, (int)dimensionRegions.size());
                FactionRegion newRegion = (FactionRegion)dimensionRegions.get(i);
                List regionFacs = this.currentFactionSettings().getFactionsForRegion(newRegion);
                if (regionFacs != null && !regionFacs.isEmpty()) {
                    Faction fac = this.getRegionLastViewedFaction(newRegion);
                    if (fac != null) {
                        this.setCurrentViewedFaction(fac);
                    } else {
                        this.setCurrentViewedFaction((Faction)regionFacs.get(0));
                    }
                } else {
                    newRegion = (FactionRegion)dimensionRegions.get(0);
                    regionFacs = this.currentFactionSettings().getFactionsForRegion(newRegion);
                    if (regionFacs != null && !regionFacs.isEmpty()) {
                        Faction fac = this.getRegionLastViewedFaction(newRegion);
                        if (fac != null) {
                            this.setCurrentViewedFaction(fac);
                        } else {
                            this.setCurrentViewedFaction((Faction)regionFacs.get(0));
                        }
                    } else {
                        this.setCurrentViewedFaction((Faction)this.currentFactionSettings().getFactionsForRegion((FactionRegion)dimensionRegions.get(0)).get(0));
                    }
                }
            }
        } else {
            this.updateCurrentViewedFactionToNewDimension((RegistryKey<World>)currentDimension);
        }
        this.runAlignmentDraining(player, tick);
        if (this.pledgeKillCooldown > 0) {
            --this.pledgeKillCooldown;
            if (this.pledgeKillCooldown == 0 || MixinAlignmentDataModule.isTimerAutosaveTick()) {
                this.markDirty();
            }
        }
        if (this.pledgeBreakCooldown > 0) {
            this.setPledgeBreakCooldown(this.pledgeBreakCooldown - 1);
        }
    }
}

