/*
 * Decompiled with CFR 0.152.
 */
package com.github.maximuslotro.lotrrextended.mixins.lotr.common.data;

import com.github.maximuslotro.lotrrextended.common.config.ExtendedServerConfig;
import com.github.maximuslotro.lotrrextended.common.network.ExtendedPacketHandler;
import com.github.maximuslotro.lotrrextended.common.network.ExtendedSPacketSendServerSettings;
import java.util.ArrayList;
import java.util.UUID;
import lotr.common.config.LOTRConfig;
import lotr.common.data.ExtendedFellowshipDataModule;
import lotr.common.data.ExtendedLOTRPlayerData;
import lotr.common.data.LOTRLevelData;
import lotr.common.data.LOTRPlayerData;
import lotr.common.fellowship.ExtendedFellowship;
import lotr.common.fellowship.ExtendedFellowshipHolderServer;
import lotr.common.network.LOTRPacketHandler;
import lotr.common.network.SPacketMapPlayerLocations;
import lotr.common.world.map.MapPlayerLocation;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.server.ServerWorld;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={LOTRLevelData.class})
public class MixinLOTRLevelData {
    @Inject(method={"save(Lnet/minecraft/world/server/ServerWorld;)V"}, at={@At(value="HEAD")}, remap=false)
    public void saveFactionData(ServerWorld world, CallbackInfo info) {
        ExtendedFellowshipHolderServer.saveAll(world);
    }

    @Inject(method={"save(Lnet/minecraft/world/server/ServerWorld;)V"}, at={@At(value="HEAD")}, remap=false)
    public void loadFactionData(ServerWorld world, CallbackInfo info) {
        ExtendedFellowshipHolderServer.loadAll(world);
    }

    @Shadow(remap=false)
    public LOTRPlayerData getData(PlayerEntity player) {
        return null;
    }

    @Inject(method={"sendLoginPacket(Lnet/minecraft/entity/player/ServerPlayerEntity;)V"}, at={@At(value="TAIL")}, remap=false)
    public void sendLoginPacket(ServerPlayerEntity player, CallbackInfo ci) {
        ExtendedSPacketSendServerSettings packet = new ExtendedSPacketSendServerSettings();
        packet.setMakeMetalDoorsRequirePower((Boolean)ExtendedServerConfig.makeMetalDoorsRequirePower.get());
        ExtendedPacketHandler.sendToClient(packet, player);
    }

    @Overwrite(remap=false)
    public void sendPlayerLocationsToPlayer(PlayerEntity targetPlayer, ServerWorld world) {
        ArrayList<MapPlayerLocation> playerLocations = new ArrayList<MapPlayerLocation>();
        MinecraftServer server = world.func_73046_m();
        boolean isOp = server.func_184103_al().func_152596_g(targetPlayer.func_146103_bH());
        boolean creative = targetPlayer.field_71075_bZ.field_75098_d;
        ArrayList<ExtendedFellowship> fellowshipsMapShow = new ArrayList<ExtendedFellowship>();
        ExtendedFellowshipDataModule data = ((ExtendedLOTRPlayerData)this.getData(targetPlayer)).getFellowshipData();
        for (UUID fsID : data.getFellowshipIDs()) {
            ExtendedFellowship fs = ExtendedFellowshipHolderServer.getFellowship(world, fsID);
            if (fs == null || !fs.isHideMapLocation()) continue;
            fellowshipsMapShow.add(fs);
        }
        for (PlayerEntity otherPlayer : world.func_217369_A()) {
            boolean show;
            if (otherPlayer == targetPlayer) continue;
            boolean bl = show = !this.getData(otherPlayer).getHideMapLocation();
            if (!isOp && this.getData(otherPlayer).getAdminHideMap()) {
                show = false;
            } else if ((Integer)LOTRConfig.SERVER.forceMapLocations.get() == 1) {
                show = false;
            } else if ((Integer)LOTRConfig.SERVER.forceMapLocations.get() == 2) {
                show = true;
            } else if (!show) {
                if (isOp && creative) {
                    show = true;
                } else {
                    for (ExtendedFellowship fs : fellowshipsMapShow) {
                        if (!fs.isInFellowship(otherPlayer.func_110124_au())) continue;
                        show = true;
                        break;
                    }
                }
            }
            if (!show) continue;
            playerLocations.add(MapPlayerLocation.ofPlayer((PlayerEntity)otherPlayer));
        }
        SPacketMapPlayerLocations packet = new SPacketMapPlayerLocations(playerLocations);
        LOTRPacketHandler.sendTo((Object)packet, (ServerPlayerEntity)((ServerPlayerEntity)targetPlayer));
    }
}

