/*
 * Decompiled with CFR 0.152.
 */
package com.github.maximuslotro.lotrrextended.mixins.lotr.common.entity.npc;

import com.github.maximuslotro.lotrrextended.common.bannerprotection.ExtendedBannerProtectionManager;
import lotr.common.entity.npc.ExtendedNPCEntity;
import lotr.common.entity.npc.NPCEntity;
import lotr.common.entity.npc.data.ExtendedNpcMarriageHolder;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={NPCEntity.class})
public abstract class MixinNPCEntity
extends CreatureEntity
implements ExtendedNPCEntity {
    private ExtendedNpcMarriageHolder marriageInfo = new ExtendedNpcMarriageHolder((NPCEntity)this);
    @Shadow(remap=false)
    protected boolean spawnRequiresSurfaceBlock;
    @Shadow(remap=false)
    protected boolean spawnRequiresDarkness;

    protected MixinNPCEntity(EntityType<? extends CreatureEntity> p_i48575_1_, World p_i48575_2_) {
        super(p_i48575_1_, p_i48575_2_);
    }

    @Shadow(remap=false)
    private boolean checkSpawningOnSurfaceBlock(IWorld iworld, SpawnReason reason) {
        return false;
    }

    @Shadow(remap=false)
    private boolean isValidLightLevelForDarkSpawn(IWorld iworld) {
        return false;
    }

    @Inject(method={"addAdditionalSaveData(Lnet/minecraft/nbt/CompoundNBT;)V"}, at={@At(value="TAIL")})
    public void addAdditionalSaveData(CompoundNBT nbt, CallbackInfo ci) {
        this.marriageInfo.writeToNbt(nbt);
    }

    @Inject(method={"readAdditionalSaveData(Lnet/minecraft/nbt/CompoundNBT;)V"}, at={@At(value="TAIL")})
    public void readAdditionalSaveData(CompoundNBT nbt, CallbackInfo ci) {
        this.marriageInfo.loadFromNbt(nbt);
    }

    @Inject(method={"onPlayerStartTrackingNPC(Lnet/minecraft/entity/player/ServerPlayerEntity;)V"}, at={@At(value="TAIL")}, remap=false)
    public void onPlayerStartTrackingNPC(ServerPlayerEntity player, CallbackInfo ci) {
        this.marriageInfo.sendDataToPlayer(player);
    }

    @Inject(method={"tick()V"}, at={@At(value="TAIL")})
    public void tick(CallbackInfo ci) {
        this.marriageInfo.tick();
    }

    @Override
    public ExtendedNpcMarriageHolder getMarriageInfo() {
        return this.marriageInfo;
    }

    @Overwrite
    public boolean func_213380_a(IWorld iworld, SpawnReason reason) {
        if (super.func_213380_a(iworld, reason)) {
            if (reason == SpawnReason.NATURAL) {
                if (this.spawnRequiresDarkness && !this.isValidLightLevelForDarkSpawn(iworld) || ExtendedBannerProtectionManager.isBannerProtected((IWorld)this.field_70170_p, this.func_233580_cy_(), new ExtendedBannerProtectionManager.SingleProtectionInstance.EntityProtection((Entity)this), false, "checkSpawnRules")) {
                    return false;
                }
                if (this.spawnRequiresSurfaceBlock && !this.checkSpawningOnSurfaceBlock(iworld, reason)) {
                    return false;
                }
            }
            return true;
        }
        return false;
    }
}

